/*
 * Decompiled with CFR 0.152.
 */
package io.shiftleft.js2cpg.parser;

import better.files.File;
import better.files.File$;
import com.atlassian.sourcemap.Mapping;
import com.atlassian.sourcemap.ReadableSourceMap;
import com.atlassian.sourcemap.ReadableSourceMapImpl;
import com.oracle.js.parser.Source;
import com.oracle.js.parser.ir.Node;
import io.shiftleft.js2cpg.io.FileDefaults$;
import io.shiftleft.js2cpg.io.FileUtils$;
import io.shiftleft.js2cpg.parser.JsSource$;
import io.shiftleft.js2cpg.parser.JsSource$SourceMapOrigin$;
import io.shiftleft.js2cpg.preprocessing.NuxtTranspiler$;
import java.io.Serializable;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.SortedMap;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public class JsSource {
    private final File srcDir;
    private final Path projectDir;
    private final Source source;
    private final String absoluteFilePath;
    private final String mapFilePath;
    private final Option<SourceMapOrigin> sourceMap;
    private final SortedMap<Object, Object> positionToLineNumberMapping;
    private final SortedMap<Object, Object> positionToFirstPositionInLineMapping;
    public final JsSource$SourceMapOrigin$ SourceMapOrigin$lzy1;

    public static String shortenCode(String string, int n) {
        return JsSource$.MODULE$.shortenCode(string, n);
    }

    public static int shortenCode$default$2() {
        return JsSource$.MODULE$.shortenCode$default$2();
    }

    public JsSource(File srcDir, Path projectDir, Source source) {
        this.srcDir = srcDir;
        this.projectDir = projectDir;
        this.source = source;
        this.SourceMapOrigin$lzy1 = new JsSource$SourceMapOrigin$(this);
        this.absoluteFilePath = File$.MODULE$.apply(projectDir.toAbsolutePath()).$div(this.originalFilePath()).pathAsString();
        this.mapFilePath = new StringBuilder(4).append(this.absoluteFilePath).append(".map").toString();
        this.sourceMap = this.sourceMapOrigin();
        Tuple2<SortedMap<Object, Object>, SortedMap<Object, Object>> tuple2 = FileUtils$.MODULE$.positionLookupTables(source.getString());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        SortedMap positionToLineNumberMapping = (SortedMap)tuple2._1();
        SortedMap positionToFirstPositionInLineMapping = (SortedMap)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)positionToLineNumberMapping, (Object)positionToFirstPositionInLineMapping);
        this.positionToLineNumberMapping = (SortedMap)tuple22._1();
        this.positionToFirstPositionInLineMapping = (SortedMap)tuple22._2();
    }

    public File srcDir() {
        return this.srcDir;
    }

    public Path projectDir() {
        return this.projectDir;
    }

    public Source source() {
        return this.source;
    }

    private final JsSource$SourceMapOrigin$ SourceMapOrigin() {
        return this.SourceMapOrigin$lzy1;
    }

    public String filePath() {
        return this.filePathFromSourceMap();
    }

    public Option<Object> getLine(Node node) {
        return this.lineFromSourceMap(node);
    }

    public Option<Object> getColumn(Node node) {
        return this.columnFromSourceMap(node);
    }

    public String getCode(Node node) {
        return this.codeFromSourceMap(node);
    }

    public String getString(Node node) {
        return this.source().getString(node.getToken());
    }

    public String originalFilePath() {
        Option option = Option$.MODULE$.apply((Object)this.source().getURL());
        if (option instanceof Some) {
            URL url = (URL)((Some)option).value();
            return url.getPath();
        }
        if (None$.MODULE$.equals(option)) {
            return this.source().getName();
        }
        throw new MatchError((Object)option);
    }

    private File constructSourceFilePath(String sourceFileName) {
        File file;
        String lookupPath;
        String string = sourceFileName;
        if (this.absoluteFilePath.contains(NuxtTranspiler$.MODULE$.NUXT_FOLDER()) && this.srcDir().path().compareTo(this.projectDir()) == 0) {
            return File$.MODULE$.apply(this.absoluteFilePath, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0])).parent().$div(sourceFileName);
        }
        if (sourceFileName.startsWith(FileDefaults$.MODULE$.WEBPACK_PREFIX())) {
            String replacedName = sourceFileName.replace(FileDefaults$.MODULE$.WEBPACK_PREFIX(), "");
            return this.srcDir().$div(replacedName.substring(replacedName.indexOf("/") + 1));
        }
        String cleanedPath = FileUtils$.MODULE$.cleanPath(sourceFileName);
        String string2 = lookupPath = cleanedPath.contains(new StringBuilder(2).append("/").append(this.srcDir().name()).append("/").toString()) ? cleanedPath.substring(cleanedPath.lastIndexOf(new StringBuilder(2).append("/").append(this.srcDir().name()).append("/").toString()) + this.srcDir().name().length() + 2) : cleanedPath;
        if (cleanedPath.contains("AppData/Local/Temp")) {
            file = this.srcDir().root().$div("Users").$div(cleanedPath.replace(this.srcDir().toString(), ""));
        } else {
            File lookupFile = File$.MODULE$.apply(lookupPath, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0]));
            File file2 = lookupFile.parent();
            File file3 = lookupFile.root();
            file = (file2 == null ? file3 != null : !file2.equals(file3)) ? this.srcDir().$div(lookupPath) : this.srcDir().$div(lookupFile.name());
        }
        File srcFilePath = file;
        return srcFilePath;
    }

    private Option<SourceMapOrigin> sourceMapOrigin() {
        File file = File$.MODULE$.apply(this.mapFilePath, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0]));
        if (file.isEmpty(file.isEmpty$default$1())) {
            JsSource$.io$shiftleft$js2cpg$parser$JsSource$$$logger.debug(new StringBuilder(35).append("No source map file available for '").append(this.originalFilePath()).append("'").toString());
            return None$.MODULE$;
        }
        String sourceMapContent = FileUtils$.MODULE$.readLinesInFile(Paths.get(this.mapFilePath, new String[0])).mkString("\n");
        Try try_ = Try$.MODULE$.apply(() -> JsSource.sourceMapOrigin$$anonfun$1(sourceMapContent));
        if (try_ instanceof Failure) {
            Throwable exception = ((Failure)try_).exception();
            JsSource$.io$shiftleft$js2cpg$parser$JsSource$$$logger.debug(new StringBuilder(30).append("Invalid source map file for '").append(this.originalFilePath()).append("'").toString(), exception);
            return None$.MODULE$;
        }
        if (try_ instanceof Success) {
            ReadableSourceMap sourceMap = (ReadableSourceMap)((Success)try_).value();
            Buffer sourceFileNames = (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(sourceMap.getSources()).asScala().filter((Function1 & Serializable)_$1 -> _$1 != null);
            Option sourceFile = sourceFileNames.find((Function1 & Serializable)_$2 -> _$2.toLowerCase().endsWith(new StringBuilder(0).append(File$.MODULE$.apply(this.absoluteFilePath, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0])).nameWithoutExtension()).append(FileDefaults$.MODULE$.VUE_SUFFIX()).toString())).orElse(() -> JsSource.$anonfun$3(sourceFileNames));
            return sourceFile.flatMap((Function1 & Serializable)sourceFileName -> {
                File sourceFilePath = this.constructSourceFilePath((String)sourceFileName);
                if (!sourceFilePath.exists(sourceFilePath.exists$default$1())) {
                    JsSource$.io$shiftleft$js2cpg$parser$JsSource$$$logger.debug(new StringBuilder(95).append("Could not load source map file for '").append(this.originalFilePath()).append("'. The source map file refers to '").append(sourceFilePath).append("' but this does not exist").toString());
                    return None$.MODULE$;
                }
                Map<Object, String> sourceFileMapping = FileUtils$.MODULE$.contentMapFromFile(sourceFilePath.path());
                JsSource$.io$shiftleft$js2cpg$parser$JsSource$$$logger.debug(new StringBuilder(39).append("Successfully loaded source map file '").append(this.mapFilePath).append("':").append(new StringBuilder(23).append("\n\t* Transpiled file: '").append(this.absoluteFilePath).append("'").toString()).append(new StringBuilder(14).append("\n\t* Origin: '").append(sourceFilePath).append("'").toString()).toString());
                return Some$.MODULE$.apply((Object)this.SourceMapOrigin().apply(sourceFilePath.path(), (Option<ReadableSourceMap>)Some$.MODULE$.apply((Object)sourceMap), sourceFileMapping));
            });
        }
        throw new MatchError((Object)try_);
    }

    private String codeFromSourceMap(Node node) {
        SourceMapOrigin sourceMapOrigin;
        Option<SourceMapOrigin> option = this.sourceMap;
        if (option instanceof Some && (sourceMapOrigin = (SourceMapOrigin)((Some)option).value()) != null) {
            SourceMapOrigin sourceMapOrigin2 = this.SourceMapOrigin().unapply(sourceMapOrigin);
            Path path = sourceMapOrigin2._1();
            Option<ReadableSourceMap> option2 = sourceMapOrigin2._2();
            Map<Object, String> map = sourceMapOrigin2._3();
            if (option2 instanceof Some) {
                int other;
                int column;
                ReadableSourceMap sourceMap = (ReadableSourceMap)((Some)option2).value();
                Map<Object, String> sourceWithLineNumbers = map;
                int line = this.getLineOfSource(node.getStart()) - 1;
                Mapping mapping = sourceMap.getMapping(line, column = this.getColumnOfSource(node.getStart()));
                if (mapping == null) {
                    return this.source().getString(node.getStart(), node.getFinish() - node.getStart());
                }
                Mapping mapping2 = mapping;
                int originLine = mapping2.getSourceLine();
                int originColumn = mapping2.getSourceColumn();
                int n = node.getFinish() - node.getStart();
                int transpiledCodeLength = 0 == n ? node.toString().length() : (other = n);
                Option option3 = sourceWithLineNumbers.get((Object)BoxesRunTime.boxToInteger((int)originLine));
                if (option3 instanceof Some) {
                    String startingCodeLine = (String)((Some)option3).value();
                    int maxCodeLength = package$.MODULE$.min(transpiledCodeLength, JsSource$.io$shiftleft$js2cpg$parser$JsSource$$$MAX_CODE_LENGTH);
                    String startingCode = startingCodeLine.substring(package$.MODULE$.min(package$.MODULE$.max(startingCodeLine.length() - 1, 0), originColumn));
                    return this.calculateCode(sourceWithLineNumbers, startingCode, originLine, maxCodeLength);
                }
                if (None$.MODULE$.equals(option3)) {
                    return this.source().getString(node.getStart(), node.getFinish() - node.getStart());
                }
                throw new MatchError((Object)option3);
            }
        }
        return this.source().getString(node.getStart(), node.getFinish() - node.getStart());
    }

    private String calculateCode(Map<Object, String> sourceWithLineNumbers, String currentLine, int currentLineNumber, int transpiledCodeLength) {
        String string;
        while (true) {
            String line;
            if ((line = (string = currentLine)).length() >= transpiledCodeLength) {
                return JsSource$.MODULE$.shortenCode(line, transpiledCodeLength - 1);
            }
            String line2 = string;
            if (line2.length() >= transpiledCodeLength || !sourceWithLineNumbers.contains((Object)BoxesRunTime.boxToInteger((int)(currentLineNumber + 1)))) break;
            String string2 = new StringBuilder(1).append(line2).append("\n").append(sourceWithLineNumbers.apply((Object)BoxesRunTime.boxToInteger((int)(currentLineNumber + 1)))).toString();
            int n = currentLineNumber + 1;
            currentLine = string2;
            currentLineNumber = n;
        }
        String line = string;
        return StringOps$.MODULE$.stripLineEnd$extension(Predef$.MODULE$.augmentString(line));
    }

    private Option<Object> lineFromSourceMap(Node node) {
        SourceMapOrigin sourceMapOrigin;
        Option<SourceMapOrigin> option = this.sourceMap;
        if (option instanceof Some && (sourceMapOrigin = (SourceMapOrigin)((Some)option).value()) != null) {
            SourceMapOrigin sourceMapOrigin2 = this.SourceMapOrigin().unapply(sourceMapOrigin);
            Path path = sourceMapOrigin2._1();
            Option<ReadableSourceMap> option2 = sourceMapOrigin2._2();
            Map<Object, String> map = sourceMapOrigin2._3();
            if (option2 instanceof Some) {
                ReadableSourceMap sourceMap = (ReadableSourceMap)((Some)option2).value();
                int line = this.getLineOfSource(node.getStart()) - 1;
                int column = this.getColumnOfSource(node.getStart());
                return Option$.MODULE$.apply((Object)sourceMap.getMapping(line, column)).map((Function1 & Serializable)_$3 -> _$3.getSourceLine() + 1);
            }
        }
        return Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)this.getLineOfSource(node.getStart())));
    }

    private Option<Object> columnFromSourceMap(Node node) {
        SourceMapOrigin sourceMapOrigin;
        Option<SourceMapOrigin> option = this.sourceMap;
        if (option instanceof Some && (sourceMapOrigin = (SourceMapOrigin)((Some)option).value()) != null) {
            SourceMapOrigin sourceMapOrigin2 = this.SourceMapOrigin().unapply(sourceMapOrigin);
            Path path = sourceMapOrigin2._1();
            Option<ReadableSourceMap> option2 = sourceMapOrigin2._2();
            Map<Object, String> map = sourceMapOrigin2._3();
            if (option2 instanceof Some) {
                ReadableSourceMap sourceMap = (ReadableSourceMap)((Some)option2).value();
                int line = this.getLineOfSource(node.getStart()) - 1;
                int column = this.getColumnOfSource(node.getStart());
                return Option$.MODULE$.apply((Object)sourceMap.getMapping(line, column)).map((Function1 & Serializable)_$4 -> _$4.getSourceColumn());
            }
        }
        return Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)this.getColumnOfSource(node.getStart())));
    }

    private String filePathFromSourceMap() {
        SourceMapOrigin sourceMapOrigin;
        Option<SourceMapOrigin> option = this.sourceMap;
        if (option instanceof Some && (sourceMapOrigin = (SourceMapOrigin)((Some)option).value()) != null) {
            SourceMapOrigin sourceMapOrigin2 = this.SourceMapOrigin().unapply(sourceMapOrigin);
            Path path = sourceMapOrigin2._1();
            Option<ReadableSourceMap> option2 = sourceMapOrigin2._2();
            Map<Object, String> map = sourceMapOrigin2._3();
            Path sourceFilePath = path;
            if (this.absoluteFilePath.contains(NuxtTranspiler$.MODULE$.NUXT_FOLDER())) {
                return this.srcDir().relativize(File$.MODULE$.apply(NuxtTranspiler$.MODULE$.remapPath(sourceFilePath.toString()), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0]))).toString();
            }
            SourceMapOrigin sourceMapOrigin3 = this.SourceMapOrigin().unapply(sourceMapOrigin);
            Path path2 = sourceMapOrigin3._1();
            Option<ReadableSourceMap> option3 = sourceMapOrigin3._2();
            Map<Object, String> map2 = sourceMapOrigin3._3();
            Path sourceFilePath2 = path2;
            return this.srcDir().relativize(File$.MODULE$.apply(sourceFilePath2)).toString();
        }
        if (None$.MODULE$.equals(option)) {
            if (this.absoluteFilePath.contains(NuxtTranspiler$.MODULE$.NUXT_FOLDER())) {
                return NuxtTranspiler$.MODULE$.remapPath(this.originalFilePath());
            }
            return this.originalFilePath();
        }
        throw new MatchError(option);
    }

    private int getLineOfSource(int position) {
        Tuple2 tuple2 = (Tuple2)this.positionToLineNumberMapping.minAfter((Object)BoxesRunTime.boxToInteger((int)position)).get();
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int lineNumber = BoxesRunTime.unboxToInt((Object)tuple2._2());
        int lineNumber2 = lineNumber;
        return lineNumber2;
    }

    private int getColumnOfSource(int position) {
        Tuple2 tuple2 = (Tuple2)this.positionToFirstPositionInLineMapping.minAfter((Object)BoxesRunTime.boxToInteger((int)position)).get();
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int firstPositionInLine = BoxesRunTime.unboxToInt((Object)tuple2._2());
        int firstPositionInLine2 = firstPositionInLine;
        return position - firstPositionInLine2;
    }

    private static final ReadableSourceMap sourceMapOrigin$$anonfun$1(String sourceMapContent$1) {
        return ReadableSourceMapImpl.fromSource((String)sourceMapContent$1);
    }

    private static final Option $anonfun$3(Buffer sourceFileNames$1) {
        return sourceFileNames$1.headOption();
    }

    public class SourceMapOrigin
    implements Product,
    Serializable {
        private final Path sourceFilePath;
        private final Option sourceMap;
        private final Map sourceWithLineNumbers;
        private final /* synthetic */ JsSource $outer;

        public SourceMapOrigin(JsSource $outer, Path sourceFilePath, Option<ReadableSourceMap> sourceMap, Map<Object, String> sourceWithLineNumbers) {
            this.sourceFilePath = sourceFilePath;
            this.sourceMap = sourceMap;
            this.sourceWithLineNumbers = sourceWithLineNumbers;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof SourceMapOrigin)) return false;
            if (((SourceMapOrigin)object).io$shiftleft$js2cpg$parser$JsSource$SourceMapOrigin$$$outer() != this.$outer) return false;
            SourceMapOrigin sourceMapOrigin = (SourceMapOrigin)object;
            Path path = this.sourceFilePath();
            Path path2 = sourceMapOrigin.sourceFilePath();
            if (path == null) {
                if (path2 != null) {
                    return false;
                }
            } else if (!((Object)path).equals(path2)) return false;
            Option<ReadableSourceMap> option = this.sourceMap();
            Option<ReadableSourceMap> option2 = sourceMapOrigin.sourceMap();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            Map<Object, String> map = this.sourceWithLineNumbers();
            Map<Object, String> map2 = sourceMapOrigin.sourceWithLineNumbers();
            if (map == null) {
                if (map2 != null) {
                    return false;
                }
            } else if (!map.equals(map2)) return false;
            if (!sourceMapOrigin.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof SourceMapOrigin;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "SourceMapOrigin";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "sourceFilePath";
                }
                case 1: {
                    return "sourceMap";
                }
                case 2: {
                    return "sourceWithLineNumbers";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Path sourceFilePath() {
            return this.sourceFilePath;
        }

        public Option<ReadableSourceMap> sourceMap() {
            return this.sourceMap;
        }

        public Map<Object, String> sourceWithLineNumbers() {
            return this.sourceWithLineNumbers;
        }

        public SourceMapOrigin copy(Path sourceFilePath, Option<ReadableSourceMap> sourceMap, Map<Object, String> sourceWithLineNumbers) {
            return new SourceMapOrigin(this.$outer, sourceFilePath, sourceMap, sourceWithLineNumbers);
        }

        public Path copy$default$1() {
            return this.sourceFilePath();
        }

        public Option<ReadableSourceMap> copy$default$2() {
            return this.sourceMap();
        }

        public Map<Object, String> copy$default$3() {
            return this.sourceWithLineNumbers();
        }

        public Path _1() {
            return this.sourceFilePath();
        }

        public Option<ReadableSourceMap> _2() {
            return this.sourceMap();
        }

        public Map<Object, String> _3() {
            return this.sourceWithLineNumbers();
        }

        public final /* synthetic */ JsSource io$shiftleft$js2cpg$parser$JsSource$SourceMapOrigin$$$outer() {
            return this.$outer;
        }
    }
}

