/*
 * Decompiled with CFR 0.152.
 */
package io.shiftleft.js2cpg.preprocessing;

import better.files.File$;
import io.shiftleft.js2cpg.core.Config;
import io.shiftleft.js2cpg.io.ExternalCommand$;
import io.shiftleft.js2cpg.io.FileDefaults$;
import io.shiftleft.js2cpg.io.FileUtils$;
import io.shiftleft.js2cpg.preprocessing.Transpiler;
import io.shiftleft.js2cpg.preprocessing.TranspilingEnvironment;
import io.shiftleft.js2cpg.preprocessing.TranspilingEnvironment$;
import io.shiftleft.js2cpg.preprocessing.TranspilingEnvironment$Versions$;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.MatchError;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class PugTranspiler
implements TranspilingEnvironment,
Transpiler {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(PugTranspiler.class.getDeclaredField("0bitmap$1"));
    private Logger io$shiftleft$js2cpg$preprocessing$TranspilingEnvironment$$logger;
    public TranspilingEnvironment$Versions$ Versions$lzy1;
    public long 0bitmap$1;
    private List DEFAULT_IGNORED_DIRS;
    private List DEFAULT_IGNORED_TEST_DIRS;
    private final Config config;
    private final Path projectPath;
    private final Logger logger;
    private final String pug;
    private final String pugAndVersion;

    public PugTranspiler(Config config, Path projectPath) {
        this.config = config;
        this.projectPath = projectPath;
        TranspilingEnvironment.$init$(this);
        Transpiler.$init$(this);
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.pug = Paths.get(projectPath.toString(), "node_modules", ".bin", "pug").toString();
        this.pugAndVersion = this.Versions().nameAndVersion("pug-cli");
        Statics.releaseFence();
    }

    @Override
    public Logger io$shiftleft$js2cpg$preprocessing$TranspilingEnvironment$$logger() {
        return this.io$shiftleft$js2cpg$preprocessing$TranspilingEnvironment$$logger;
    }

    @Override
    public final TranspilingEnvironment$Versions$ Versions() {
        long l;
        long l2;
        while ((l2 = LazyVals$.MODULE$.STATE(l = LazyVals$.MODULE$.get((Object)this, OFFSET$0), 0)) != 3L) {
            if (l2 == 0L) {
                if (!LazyVals$.MODULE$.CAS((Object)this, OFFSET$0, l, 1, 0)) continue;
                try {
                    TranspilingEnvironment$Versions$ transpilingEnvironment$Versions$;
                    this.Versions$lzy1 = transpilingEnvironment$Versions$ = new TranspilingEnvironment$Versions$(this);
                    LazyVals$.MODULE$.setFlag((Object)this, OFFSET$0, 3, 0);
                    return transpilingEnvironment$Versions$;
                }
                catch (Throwable throwable) {
                    LazyVals$.MODULE$.setFlag((Object)this, OFFSET$0, 0, 0);
                    throw throwable;
                }
            }
            LazyVals$.MODULE$.wait4Notification((Object)this, OFFSET$0, l, 0);
        }
        return this.Versions$lzy1;
    }

    @Override
    public void io$shiftleft$js2cpg$preprocessing$TranspilingEnvironment$_setter_$io$shiftleft$js2cpg$preprocessing$TranspilingEnvironment$$logger_$eq(Logger x$0) {
        this.io$shiftleft$js2cpg$preprocessing$TranspilingEnvironment$$logger = x$0;
    }

    public List DEFAULT_IGNORED_DIRS() {
        return this.DEFAULT_IGNORED_DIRS;
    }

    public List DEFAULT_IGNORED_TEST_DIRS() {
        return this.DEFAULT_IGNORED_TEST_DIRS;
    }

    @Override
    public void io$shiftleft$js2cpg$preprocessing$Transpiler$_setter_$DEFAULT_IGNORED_DIRS_$eq(List x$0) {
        this.DEFAULT_IGNORED_DIRS = x$0;
    }

    @Override
    public void io$shiftleft$js2cpg$preprocessing$Transpiler$_setter_$DEFAULT_IGNORED_TEST_DIRS_$eq(List x$0) {
        this.DEFAULT_IGNORED_TEST_DIRS = x$0;
    }

    @Override
    public Config config() {
        return this.config;
    }

    @Override
    public Path projectPath() {
        return this.projectPath;
    }

    private boolean hasPugFiles() {
        return FileUtils$.MODULE$.getFileTree(this.projectPath(), this.config(), (List<String>)((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{FileDefaults$.MODULE$.PUG_SUFFIX()}))), FileUtils$.MODULE$.getFileTree$default$4()).nonEmpty();
    }

    @Override
    public boolean shouldRun() {
        return this.config().templateTranspiling() && this.hasPugFiles();
    }

    private boolean installPugPlugins() {
        String command = this.pnpmAvailable(this.projectPath()) ? new StringBuilder(5).append(TranspilingEnvironment$.MODULE$.PNPM_ADD()).append(" ").append(this.pugAndVersion).append(" && ").append(TranspilingEnvironment$.MODULE$.PNPM_INSTALL()).toString() : (this.yarnAvailable() ? new StringBuilder(5).append(TranspilingEnvironment$.MODULE$.YARN_ADD()).append(" ").append(this.pugAndVersion).append(" && ").append(TranspilingEnvironment$.MODULE$.YARN_INSTALL()).toString() : new StringBuilder(1).append(TranspilingEnvironment$.MODULE$.NPM_INSTALL()).append(" ").append(this.pugAndVersion).toString());
        this.logger.info("Installing Pug dependencies and plugins. That will take a while.");
        this.logger.debug(new StringBuilder(52).append("\t+ Installing Pug plugins with command '").append(command).append("' in path '").append(this.projectPath()).append("'").toString());
        Try<String> try_ = ExternalCommand$.MODULE$.run(command, this.projectPath().toString(), ExternalCommand$.MODULE$.run$default$3());
        if (try_ instanceof Success) {
            this.logger.info("\t+ Pug plugins installed");
            return true;
        }
        if (try_ instanceof Failure) {
            Throwable exception = ((Failure)try_).exception();
            this.logger.warn("\t- Failed to install Pug plugins", exception);
            return false;
        }
        throw new MatchError(try_);
    }

    @Override
    public boolean transpile(Path tmpTranspileDir) {
        if (this.installPugPlugins()) {
            String command = new StringBuilder(29).append(ExternalCommand$.MODULE$.toOSCommand(this.pug)).append(" --client --no-debug --out ").append(tmpTranspileDir).append(" .").toString();
            this.logger.debug(new StringBuilder(36).append("\t+ transpiling Pug templates in ").append(this.projectPath()).append(" to ").append(tmpTranspileDir).toString());
            Try<String> try_ = ExternalCommand$.MODULE$.run(command, this.projectPath().toString(), ExternalCommand$.MODULE$.run$default$3());
            if (try_ instanceof Success) {
                this.logger.debug("\t+ transpiling Pug templates finished");
            } else if (try_ instanceof Failure) {
                Throwable exception = ((Failure)try_).exception();
                this.logger.debug("\t- transpiling Pug templates failed", exception);
            } else {
                throw new MatchError(try_);
            }
        }
        return true;
    }

    @Override
    public boolean validEnvironment() {
        return this.valid(this.projectPath());
    }

    @Override
    public void logExecution() {
        this.logger.info(new StringBuilder(36).append("PUG - transpiling source files in '").append(File$.MODULE$.apply(this.projectPath()).name()).append("'").toString());
    }
}

