/*
 * Decompiled with CFR 0.152.
 */
package io.shiftleft.js2cpg.preprocessing;

import better.files.File;
import better.files.File$;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.shiftleft.js2cpg.core.Config;
import io.shiftleft.js2cpg.io.FileDefaults$;
import io.shiftleft.js2cpg.io.FileUtils$;
import io.shiftleft.js2cpg.parser.PackageJsonParser$;
import io.shiftleft.js2cpg.preprocessing.BabelTranspiler;
import io.shiftleft.js2cpg.preprocessing.BabelTranspiler$;
import io.shiftleft.js2cpg.preprocessing.EjsTranspiler;
import io.shiftleft.js2cpg.preprocessing.NuxtTranspiler;
import io.shiftleft.js2cpg.preprocessing.PugTranspiler;
import io.shiftleft.js2cpg.preprocessing.TranspilationRunner$;
import io.shiftleft.js2cpg.preprocessing.Transpiler;
import io.shiftleft.js2cpg.preprocessing.TranspilerGroup;
import io.shiftleft.js2cpg.preprocessing.TranspilerGroup$;
import io.shiftleft.js2cpg.preprocessing.TranspilingEnvironment$;
import io.shiftleft.js2cpg.preprocessing.TypescriptTranspiler;
import io.shiftleft.js2cpg.preprocessing.VueTranspiler;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction0;
import scala.util.ChainingOps$;
import scala.util.Try;
import scala.util.Try$;
import scala.util.package;

public class TranspilationRunner {
    private final Path projectPath;
    private final Path tmpTranspileDir;
    private final Config config;
    private final Option<Path> subDir;
    public final Logger io$shiftleft$js2cpg$preprocessing$TranspilationRunner$$logger;
    private final Seq<Transpiler> transpilers;
    private final List<String> DEPS_TO_KEEP;

    public static Option<Path> $lessinit$greater$default$4() {
        return TranspilationRunner$.MODULE$.$lessinit$greater$default$4();
    }

    public TranspilationRunner(Path projectPath, Path tmpTranspileDir, Config config, Option<Path> subDir) {
        this.projectPath = projectPath;
        this.tmpTranspileDir = tmpTranspileDir;
        this.config = config;
        this.subDir = subDir;
        this.io$shiftleft$js2cpg$preprocessing$TranspilationRunner$$logger = LoggerFactory.getLogger(this.getClass());
        this.transpilers = this.createTranspilers();
        this.DEPS_TO_KEEP = (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"@vue", "vue", "nuxt", "eslint", "@typescript-eslint"}));
    }

    private Seq<Transpiler> createTranspilers() {
        TranspilerGroup baseTranspilers = TranspilerGroup$.MODULE$.apply(this.config, this.projectPath, (Seq<Transpiler>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Transpiler[]{new TypescriptTranspiler(this.config, this.projectPath, this.subDir), new BabelTranspiler(this.config, this.projectPath, this.subDir, BabelTranspiler$.MODULE$.$lessinit$greater$default$4())}))));
        if (this.subDir.isEmpty()) {
            Seq otherTranspilers = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Transpiler[]{new VueTranspiler(this.config, this.projectPath), new EjsTranspiler(this.config, this.projectPath), new PugTranspiler(this.config, this.projectPath)}));
            Seq seq = (Seq)baseTranspilers.transpilers().prepended((Object)new NuxtTranspiler(this.config, this.projectPath));
            Config config = baseTranspilers.copy$default$1();
            Path path = baseTranspilers.copy$default$2();
            TranspilerGroup base = baseTranspilers.copy(config, path, (Seq<Transpiler>)seq);
            return (Seq)otherTranspilers.$plus$colon((Object)base);
        }
        return (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TranspilerGroup[]{baseTranspilers}));
    }

    private Seq<String> extractNpmRcModules(File npmrc) {
        if (npmrc.exists(npmrc.exists$default$1())) {
            Seq<String> npmrcContent = FileUtils$.MODULE$.readLinesInFile(npmrc.path());
            return (Seq)npmrcContent.collect((PartialFunction)new Serializable(){

                public final boolean isDefinedAt(String x) {
                    String string = x;
                    String line = string;
                    return line.contains(FileDefaults$.MODULE$.REGISTRY_MARKER());
                }

                public final Object applyOrElse(String x, Function1 function1) {
                    String string = x;
                    String line = string;
                    if (line.contains(FileDefaults$.MODULE$.REGISTRY_MARKER())) {
                        return line.substring(0, line.indexOf(FileDefaults$.MODULE$.REGISTRY_MARKER()));
                    }
                    return function1.apply((Object)x);
                }
            });
        }
        return (Seq)package$.MODULE$.Seq().empty();
    }

    public List<Tuple2<Path, Path>> handlePrivateModules() {
        File project = File$.MODULE$.apply(this.config.srcDir(), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0]));
        File nodeModulesFolder = project.$div(FileDefaults$.MODULE$.NODE_MODULES_DIR_NAME());
        if (!nodeModulesFolder.exists(nodeModulesFolder.exists$default$1())) {
            return package$.MODULE$.List().empty();
        }
        Seq privateModulesToCopy = (Seq)this.config.privateDeps().$plus$plus(this.extractNpmRcModules(project.$div(FileDefaults$.MODULE$.NPMRC_NAME())));
        if (privateModulesToCopy.nonEmpty()) {
            File slPrivateDir = File$.MODULE$.apply(this.projectPath).$div(FileDefaults$.MODULE$.PRIVATE_MODULES_DIR_NAME());
            boolean bl = slPrivateDir.createDirectoryIfNotExists$default$1();
            slPrivateDir.createDirectoryIfNotExists(bl, slPrivateDir.createDirectoryIfNotExists$default$2(bl), slPrivateDir.createDirectoryIfNotExists$default$3(bl));
            Function1 & Serializable intersect = (Function1 & Serializable)_$1 -> _$1.isDirectory(_$1.isDirectory$default$1());
            Set nodeModulesFolderContent = nodeModulesFolder.collectChildren((Function1)intersect, 1, nodeModulesFolder.collectChildren$default$3((Function1)intersect, 1)).toSet();
            Seq foldersToCopy = (Seq)((IterableOps)privateModulesToCopy.collect((PartialFunction)new Serializable(nodeModulesFolder, nodeModulesFolderContent, this){
                private final File nodeModulesFolder$1;
                private final Set nodeModulesFolderContent$1;
                private final /* synthetic */ TranspilationRunner $outer;
                {
                    this.nodeModulesFolder$1 = nodeModulesFolder$2;
                    this.nodeModulesFolderContent$1 = nodeModulesFolderContent$2;
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }

                public final boolean isDefinedAt(String x) {
                    String string = x;
                    String module = string;
                    if (this.nodeModulesFolderContent$1.exists(arg_0 -> TranspilationRunner.io$shiftleft$js2cpg$preprocessing$TranspilationRunner$$anon$2$$_$isDefinedAt$$anonfun$1(module, arg_0))) {
                        return true;
                    }
                    String module2 = string;
                    return true;
                }

                public final Object applyOrElse(String x, Function1 function1) {
                    String string = x;
                    String module = string;
                    if (this.nodeModulesFolderContent$1.exists(arg_0 -> TranspilationRunner.io$shiftleft$js2cpg$preprocessing$TranspilationRunner$$anon$2$$_$applyOrElse$$anonfun$1(module, arg_0))) {
                        return this.nodeModulesFolderContent$1.filter(arg_0 -> TranspilationRunner.io$shiftleft$js2cpg$preprocessing$TranspilationRunner$$anon$2$$_$applyOrElse$$anonfun$2(module, arg_0));
                    }
                    String module2 = string;
                    this.$outer.io$shiftleft$js2cpg$preprocessing$TranspilationRunner$$logger.debug(new StringBuilder(133).append("Could not find '").append(module2).append("' in '").append(this.nodeModulesFolder$1).append("'. ").append("Ensure that npm authentication to your private registry is working ").append("to use private namespace analysis feature").toString());
                    return Predef$.MODULE$.Set().empty();
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{io$shiftleft$js2cpg$preprocessing$TranspilationRunner$$anon$2$$_$isDefinedAt$$anonfun$1(java.lang.String better.files.File ), io$shiftleft$js2cpg$preprocessing$TranspilationRunner$$anon$2$$_$applyOrElse$$anonfun$1(java.lang.String better.files.File ), io$shiftleft$js2cpg$preprocessing$TranspilationRunner$$anon$2$$_$applyOrElse$$anonfun$2(java.lang.String better.files.File )}, serializedLambda);
                }
            })).flatten(Predef$.MODULE$.$conforms());
            foldersToCopy.foreach((Function1 & Serializable)folder -> {
                this.io$shiftleft$js2cpg$preprocessing$TranspilationRunner$$logger.debug(new StringBuilder(32).append("Copying private module '").append(folder.name()).append("' to '").append(slPrivateDir).append("'.").toString());
                Try try_ = (Try)package.chaining$.MODULE$.scalaUtilChainingOps((Object)Try$.MODULE$.apply(() -> TranspilationRunner.handlePrivateModules$$anonfun$1$$anonfun$1(slPrivateDir, folder)));
                return (Try)ChainingOps$.MODULE$.tap$extension((Object)try_, (Function1)(JProcedure1 & Serializable)_$3 -> _$3.failed().foreach((Function1)(JProcedure1 & Serializable)_$4 -> this.io$shiftleft$js2cpg$preprocessing$TranspilationRunner$$logger.debug(new StringBuilder(40).append("Unable to copy private module '").append(folder.name()).append("' to '").append(slPrivateDir).append("': ").toString(), _$4)));
            });
            return FileUtils$.MODULE$.getFileTree(slPrivateDir.path(), this.config, (List<String>)((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{FileDefaults$.MODULE$.JS_SUFFIX(), FileDefaults$.MODULE$.MJS_SUFFIX()}))), FileUtils$.MODULE$.getFileTree$default$4()).map((Function1 & Serializable)f -> Tuple2$.MODULE$.apply(f, (Object)slPrivateDir.path()));
        }
        return package$.MODULE$.List().empty();
    }

    private void withTemporaryPackageJson(Function0<BoxedUnit> workUnit) {
        File packageJson = File$.MODULE$.apply(this.projectPath).$div(PackageJsonParser$.MODULE$.PACKAGE_JSON_FILENAME());
        if (this.config.optimizeDependencies() && packageJson.exists(packageJson.exists$default$1())) {
            PackageJsonParser$.MODULE$.PROJECT_CONFIG_FILES().map((Function1 & Serializable)_$5 -> File$.MODULE$.apply(File$.MODULE$.apply(this.projectPath), _$5, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0]))).filter((Function1 & Serializable)_$6 -> _$6.exists(_$6.exists$default$1())).foreach((Function1 & Serializable)file -> file.renameTo(new StringBuilder(4).append(file.pathAsString()).append(".bak").toString()));
            String originalContent = FileUtils$.MODULE$.readLinesInFile(packageJson.path()).mkString("\n");
            ObjectMapper mapper = new ObjectMapper();
            JsonNode json = mapper.readTree(PackageJsonParser$.MODULE$.removeComments(originalContent));
            ObjectNode jsonObject = (ObjectNode)json;
            PackageJsonParser$.MODULE$.PROJECT_DEPENDENCIES().foreach((Function1)(JProcedure1 & Serializable)dep -> Option$.MODULE$.apply((Object)((ObjectNode)jsonObject.get(dep))).foreach((Function1)(JProcedure1 & Serializable)depNode -> {
                List fieldsToRemove = CollectionConverters$.MODULE$.IteratorHasAsScala(depNode.fieldNames()).asScala().toList().filterNot((Function1 & Serializable)f -> this.DEPS_TO_KEEP.exists((Function1 & Serializable)x$0 -> f.startsWith((String)x$0)));
                fieldsToRemove.foreach((Function1 & Serializable)x$0 -> depNode.remove(x$0));
            }));
            jsonObject.remove("engines");
            jsonObject.remove("scripts");
            String string = mapper.writeValueAsString((Object)json);
            packageJson.writeText(string, packageJson.writeText$default$2(string), packageJson.writeText$default$3(string));
            workUnit.apply$mcV$sp();
            PackageJsonParser$.MODULE$.PROJECT_CONFIG_FILES().map((Function1 & Serializable)_$7 -> File$.MODULE$.apply(File$.MODULE$.apply(this.projectPath), _$7, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0]))).foreach((Function1 & Serializable)_$8 -> _$8.delete(true, _$8.delete$default$2()));
            packageJson.writeText(originalContent, packageJson.writeText$default$2(originalContent), packageJson.writeText$default$3(originalContent));
            PackageJsonParser$.MODULE$.PROJECT_CONFIG_FILES().map((Function1 & Serializable)f -> File$.MODULE$.apply(File$.MODULE$.apply(this.projectPath), new StringBuilder(4).append((String)f).append(".bak").toString(), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0]))).filter((Function1 & Serializable)_$9 -> _$9.exists(_$9.exists$default$1())).foreach((Function1 & Serializable)file -> file.renameTo(StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(file.pathAsString()), ".bak")));
            return;
        }
        workUnit.apply$mcV$sp();
    }

    public void execute() {
        if (this.transpilers.exists((Function1 & Serializable)_$10 -> _$10.shouldRun())) {
            if (!this.transpilers.headOption().exists((Function1 & Serializable)_$11 -> _$11.validEnvironment())) {
                String errorMsg = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(202).append("npm is not available in your environment. Please install npm and node.js.\n            |Also please check if it is set correctly in your systems PATH variable.\n            |Your PATH is: '").append(TranspilingEnvironment$.MODULE$.ENV_PATH_CONTENT()).append("'\n            |").toString()));
                this.io$shiftleft$js2cpg$preprocessing$TranspilationRunner$$logger.error(errorMsg);
                System.exit(1);
            }
            this.withTemporaryPackageJson((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.transpilers.takeWhile((Function1 & Serializable)_$12 -> _$12.run(this.tmpTranspileDir)));
            return;
        }
    }

    public static final /* synthetic */ boolean io$shiftleft$js2cpg$preprocessing$TranspilationRunner$$anon$2$$_$isDefinedAt$$anonfun$1(String module$1, File _$2) {
        return _$2.name().startsWith(module$1);
    }

    public static final /* synthetic */ boolean io$shiftleft$js2cpg$preprocessing$TranspilationRunner$$anon$2$$_$applyOrElse$$anonfun$1(String module$2, File _$2) {
        return _$2.name().startsWith(module$2);
    }

    public static final /* synthetic */ boolean io$shiftleft$js2cpg$preprocessing$TranspilationRunner$$anon$2$$_$applyOrElse$$anonfun$2(String module$3, File f) {
        return f.name().startsWith(module$3);
    }

    private static final File handlePrivateModules$$anonfun$1$$anonfun$1(File slPrivateDir$2, File folder$1) {
        return folder$1.copyToDirectory(slPrivateDir$2, File.LinkOptions$.MODULE$.noFollow(), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StandardCopyOption[]{StandardCopyOption.REPLACE_EXISTING})).$plus$plus((IterableOnce)File.LinkOptions$.MODULE$.noFollow()));
    }
}

