/*
 * Decompiled with CFR 0.152.
 */
package overflowdb;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.LongStream;
import org.h2.mvstore.MVMap;
import overflowdb.Graph;
import overflowdb.NodeRef;
import overflowdb.storage.OdbStorage;

public final class IndexManager {
    private final Graph graph;
    protected Map<String, Map<Object, Set<NodeRef>>> indexes = new ConcurrentHashMap<String, Map<Object, Set<NodeRef>>>();
    protected Map<String, Boolean> dirtyFlags = new ConcurrentHashMap<String, Boolean>();

    public IndexManager(Graph graph) {
        this.graph = graph;
    }

    public final void createNodePropertyIndex(String propertyName) {
        this.checkPropertyName(propertyName);
        if (this.indexes.containsKey(propertyName)) {
            return;
        }
        this.dirtyFlags.put(propertyName, true);
        this.graph.nodes.iterator().forEachRemaining(node -> {
            Object value = node.property(propertyName);
            if (value != null) {
                this.put(propertyName, value, (NodeRef)node);
            }
        });
    }

    public boolean isIndexed(String propertyName) {
        return this.indexes.containsKey(propertyName);
    }

    private void checkPropertyName(String propertyName) {
        if (propertyName == null || propertyName.isEmpty()) {
            throw new IllegalArgumentException("Illegal property name: " + propertyName);
        }
    }

    private final void loadNodePropertyIndex(String propertyName, Map<Object, long[]> valueToNodeIds) {
        this.dirtyFlags.put(propertyName, false);
        valueToNodeIds.entrySet().parallelStream().forEach(entry -> LongStream.of((long[])entry.getValue()).forEach(nodeId -> this.put(propertyName, entry.getKey(), (NodeRef)this.graph.node(nodeId))));
    }

    public void putIfIndexed(String key, Object newValue, NodeRef nodeRef) {
        if (this.indexes.containsKey(key)) {
            this.dirtyFlags.put(key, true);
            this.put(key, newValue, nodeRef);
        }
    }

    private final void put(String key, Object value, NodeRef nodeRef) {
        Set<NodeRef> objects;
        Map<Object, Set<NodeRef>> keyMap = this.indexes.get(key);
        if (null == keyMap) {
            this.indexes.putIfAbsent(key, new ConcurrentHashMap());
            keyMap = this.indexes.get(key);
        }
        if (null == (objects = keyMap.get(value))) {
            keyMap.putIfAbsent(value, ConcurrentHashMap.newKeySet());
            objects = keyMap.get(value);
        }
        objects.add(nodeRef);
    }

    public final void dropNodePropertyIndex(String key) {
        if (this.indexes.containsKey(key)) {
            this.indexes.remove(key).clear();
            this.dirtyFlags.remove(key);
        }
    }

    public final Set<String> getIndexedNodeProperties() {
        return this.indexes.keySet();
    }

    public final int getIndexedNodeCount(String propertyName) {
        Map<Object, Set<NodeRef>> indexMap = this.indexes.get(propertyName);
        return indexMap == null ? 0 : indexMap.values().stream().mapToInt(Set::size).sum();
    }

    public final List<NodeRef> lookup(String key, Object value) {
        Map<Object, Set<NodeRef>> keyMap = this.indexes.get(key);
        if (null == keyMap) {
            return Collections.emptyList();
        }
        Set<NodeRef> set = keyMap.get(value);
        if (null == set) {
            return Collections.emptyList();
        }
        return new ArrayList<NodeRef>(set);
    }

    protected final void remove(String key, Object value, NodeRef nodeRef) {
        Set<NodeRef> objects;
        this.dirtyFlags.put(key, true);
        Map<Object, Set<NodeRef>> keyMap = this.indexes.get(key);
        if (null != keyMap && null != (objects = keyMap.get(value))) {
            objects.remove(nodeRef);
            if (objects.size() == 0) {
                keyMap.remove(key);
            }
        }
    }

    protected final void removeElement(NodeRef nodeRef) {
        for (String string : this.indexes.keySet()) {
            this.dirtyFlags.put(string, true);
        }
        for (Map map : this.indexes.values()) {
            for (Set set : map.values()) {
                set.remove(nodeRef);
            }
        }
    }

    private Map<Object, Set<NodeRef>> getIndexMap(String propertyName) {
        return this.indexes.get(propertyName);
    }

    protected void initializeStoredIndices(OdbStorage storage) {
        storage.getIndexNames().stream().forEach(indexName -> this.loadIndex((String)indexName, storage));
    }

    private void loadIndex(String indexName, OdbStorage storage) {
        MVMap<Object, long[]> indexMVMap = storage.openIndex(indexName);
        this.loadNodePropertyIndex(indexName, (Map<Object, long[]>)indexMVMap);
    }

    protected void storeIndexes(OdbStorage storage) {
        this.getIndexedNodeProperties().stream().forEach(propertyName -> this.saveIndex(storage, (String)propertyName, this.getIndexMap((String)propertyName)));
    }

    private void saveIndex(OdbStorage storage, String propertyName, Map<Object, Set<NodeRef>> indexMap) {
        if (this.dirtyFlags.get(propertyName).booleanValue()) {
            storage.clearIndex(propertyName);
            MVMap<Object, long[]> indexStore = storage.openIndex(propertyName);
            indexMap.entrySet().parallelStream().forEach(entry -> {
                Object propertyValue = entry.getKey();
                Set nodeRefs = (Set)entry.getValue();
                indexStore.put(propertyValue, (Object)nodeRefs.stream().mapToLong(nodeRef -> nodeRef.id).toArray());
            });
            this.dirtyFlags.put(propertyName, false);
        }
    }
}

