/*
 * Decompiled with CFR 0.152.
 */
package overflowdb;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import overflowdb.AdjacentNodes;
import overflowdb.Direction;
import overflowdb.Edge;
import overflowdb.EdgeFactory;
import overflowdb.Graph;
import overflowdb.Node;
import overflowdb.NodeLayoutInformation;
import overflowdb.NodeRef;
import overflowdb.Property;
import overflowdb.PropertyKey;
import overflowdb.util.ArrayOffsetIterator;
import overflowdb.util.DummyEdgeIterator;
import overflowdb.util.MultiIterator;
import overflowdb.util.PropertyHelper;

public abstract class NodeDb
extends Node {
    public final NodeRef ref;
    private volatile AdjacentNodes adjacentNodes;
    private volatile boolean dirty;
    private static final String[] ALL_LABELS = new String[0];

    protected NodeDb(NodeRef ref) {
        this.ref = ref;
        ref.setNode(this);
        if (ref.graph != null) {
            ref.graph.applyBackpressureMaybe();
        }
        this.adjacentNodes = new AdjacentNodes(this.layoutInformation().numberOfDifferentAdjacentTypes());
    }

    public abstract NodeLayoutInformation layoutInformation();

    public AdjacentNodes getAdjacentNodes() {
        return this.adjacentNodes;
    }

    @Override
    public Graph graph() {
        return this.ref.graph;
    }

    @Override
    public long id() {
        return this.ref.id;
    }

    @Override
    public String label() {
        return this.ref.label();
    }

    @Override
    public <A> A property(PropertyKey<A> key) {
        return (A)this.property(key.name);
    }

    @Override
    public <A> Optional<A> propertyOption(PropertyKey<A> key) {
        return Optional.ofNullable(this.property(key));
    }

    @Override
    public Optional<Object> propertyOption(String key) {
        return Optional.ofNullable(this.property(key));
    }

    @Override
    public Map<String, Object> propertiesMap() {
        HashMap<String, Object> results = new HashMap<String, Object>(this.propertyKeys().size());
        for (String propertyKey : this.propertyKeys()) {
            Object value = this.property(propertyKey);
            if (value == null) continue;
            results.put(propertyKey, value);
        }
        return results;
    }

    public Map<String, Object> propertiesMapForStorage() {
        HashMap<String, Object> results = new HashMap<String, Object>(this.propertyKeys().size());
        for (String propertyKey : this.propertyKeys()) {
            Object value = this.property(propertyKey);
            if (value == null || value.equals(this.propertyDefaultValue(propertyKey))) continue;
            results.put(propertyKey, value);
        }
        return results;
    }

    @Override
    public Set<String> propertyKeys() {
        return this.layoutInformation().propertyKeys();
    }

    @Override
    public Object propertyDefaultValue(String propertyKey) {
        return this.ref.propertyDefaultValue(propertyKey);
    }

    @Override
    public void setProperty(String key, Object value) {
        this.updateSpecificProperty(key, value);
        this.ref.graph.indexManager.putIfIndexed(key, value, this.ref);
        this.markAsDirty();
    }

    @Override
    public <A> void setProperty(PropertyKey<A> key, A value) {
        this.setProperty(key.name, value);
    }

    @Override
    public void setProperty(Property<?> property) {
        this.setProperty(property.key.name, property.value);
    }

    @Override
    public void removeProperty(String key) {
        Object oldValue = this.property(key);
        this.removeSpecificProperty(key);
        this.ref.graph.indexManager.remove(key, oldValue, this.ref);
        this.markAsDirty();
    }

    protected abstract void updateSpecificProperty(String var1, Object var2);

    protected abstract void removeSpecificProperty(String var1);

    @Override
    public void remove() {
        ArrayList edges = new ArrayList();
        this.bothE().forEachRemaining(edges::add);
        for (Edge edge : edges) {
            if (edge.isRemoved()) continue;
            edge.remove();
        }
        this.ref.graph.remove(this);
        this.markAsDirty();
    }

    public void markAsDirty() {
        this.dirty = true;
    }

    public void markAsClean() {
        this.dirty = false;
    }

    public <V> Iterator<V> getEdgeProperties(Direction direction, Edge edge, int blockOffset, String ... keys) {
        ArrayList result = new ArrayList();
        if (keys.length != 0) {
            for (String key : keys) {
                result.add(this.edgeProperty(direction, edge, blockOffset, key));
            }
        } else {
            for (String propertyKey : this.layoutInformation().edgePropertyKeys(edge.label())) {
                result.add(this.edgeProperty(direction, edge, blockOffset, propertyKey));
            }
        }
        return result.iterator();
    }

    public Map<String, Object> edgePropertyMap(Direction direction, Edge edge, int blockOffset) {
        Set<String> edgePropertyKeys = this.layoutInformation().edgePropertyKeys(edge.label());
        HashMap<String, Object> results = new HashMap<String, Object>(edgePropertyKeys.size());
        for (String propertyKey : edgePropertyKeys) {
            Object value = this.edgeProperty(direction, edge, blockOffset, propertyKey);
            if (value == null) continue;
            results.put(propertyKey, value);
        }
        return results;
    }

    public <V> Optional<V> edgePropertyOption(Direction direction, Edge edge, int blockOffset, String key) {
        Object value = this.edgeProperty(direction, edge, blockOffset, key);
        return Optional.ofNullable(value);
    }

    public <P> P edgeProperty(Direction direction, Edge edge, int blockOffset, String key) {
        AdjacentNodes adjacentNodesTmp = this.adjacentNodes;
        int propertyPosition = this.getEdgePropertyIndex(adjacentNodesTmp, direction, edge.label(), key, blockOffset);
        if (propertyPosition == -1) {
            return null;
        }
        return (P)adjacentNodesTmp.nodesWithEdgeProperties[propertyPosition];
    }

    public synchronized <V> void setEdgeProperty(Direction direction, String edgeLabel, String key, V value, int blockOffset) {
        AdjacentNodes adjacentNodesTmp = this.adjacentNodes;
        int propertyPosition = this.getEdgePropertyIndex(adjacentNodesTmp, direction, edgeLabel, key, blockOffset);
        if (propertyPosition == -1) {
            throw new RuntimeException("Edge " + edgeLabel + " does not support property `" + key + "`.");
        }
        adjacentNodesTmp.nodesWithEdgeProperties[propertyPosition] = value;
        this.markAsDirty();
    }

    public void removeEdgeProperty(Direction direction, String edgeLabel, String key, int blockOffset) {
        this.setEdgeProperty(direction, edgeLabel, key, null, blockOffset);
    }

    private int calcAdjacentNodeIndex(AdjacentNodes adjacentNodesTmp, Direction direction, String edgeLabel, int blockOffset) {
        int offsetPos = this.getPositionInEdgeOffsets(direction, edgeLabel);
        if (offsetPos == -1) {
            return -1;
        }
        int start = this.startIndex(adjacentNodesTmp, offsetPos);
        return start + blockOffset;
    }

    private int getEdgePropertyIndex(AdjacentNodes adjacentNodesTmp, Direction direction, String label, String key, int blockOffset) {
        int adjacentNodeIndex = this.calcAdjacentNodeIndex(adjacentNodesTmp, direction, label, blockOffset);
        if (adjacentNodeIndex == -1) {
            return -1;
        }
        int propertyOffset = this.layoutInformation().getEdgePropertyOffsetRelativeToAdjacentNodeRef(label, key);
        if (propertyOffset == -1) {
            return -1;
        }
        return adjacentNodeIndex + propertyOffset;
    }

    @Override
    public Edge addEdge(String label, Node inNode, Object ... keyValues) {
        NodeRef inNodeRef = (NodeRef)inNode;
        NodeRef thisNodeRef = this.ref;
        int outBlockOffset = this.storeAdjacentNode(Direction.OUT, label, inNodeRef, keyValues);
        int inBlockOffset = ((NodeDb)inNodeRef.get()).storeAdjacentNode(Direction.IN, label, thisNodeRef, keyValues);
        Edge dummyEdge = this.instantiateDummyEdge(label, thisNodeRef, inNodeRef);
        dummyEdge.setOutBlockOffset(outBlockOffset);
        dummyEdge.setInBlockOffset(inBlockOffset);
        return dummyEdge;
    }

    @Override
    public Edge addEdge(String label, Node inNode, Map<String, Object> keyValues) {
        return this.addEdge(label, inNode, PropertyHelper.toKeyValueArray(keyValues));
    }

    @Override
    public void addEdgeSilent(String label, Node inNode, Object ... keyValues) {
        NodeRef inNodeRef = (NodeRef)inNode;
        NodeRef thisNodeRef = this.ref;
        this.storeAdjacentNode(Direction.OUT, label, inNodeRef, keyValues);
        ((NodeDb)inNodeRef.get()).storeAdjacentNode(Direction.IN, label, thisNodeRef, keyValues);
    }

    @Override
    public void addEdgeSilent(String label, Node inNode, Map<String, Object> keyValues) {
        this.addEdgeSilent(label, inNode, PropertyHelper.toKeyValueArray(keyValues));
    }

    @Override
    public Iterator<Node> out() {
        return this.createAdjacentNodeIterator(Direction.OUT, ALL_LABELS);
    }

    @Override
    public Iterator<Node> out(String ... edgeLabels) {
        return this.createAdjacentNodeIterator(Direction.OUT, edgeLabels);
    }

    @Override
    public Iterator<Node> in() {
        MultiIterator<Node> multiIterator = new MultiIterator<Node>();
        for (String label : this.layoutInformation().allowedInEdgeLabels()) {
            multiIterator.addIterator(this.in(label));
        }
        return multiIterator;
    }

    @Override
    public Iterator<Node> in(String ... edgeLabels) {
        return this.createAdjacentNodeIterator(Direction.IN, edgeLabels);
    }

    @Override
    public Iterator<Node> both() {
        MultiIterator<Node> multiIterator = new MultiIterator<Node>();
        multiIterator.addIterator(this.out());
        multiIterator.addIterator(this.in());
        return multiIterator;
    }

    @Override
    public Iterator<Node> both(String ... edgeLabels) {
        MultiIterator<Node> multiIterator = new MultiIterator<Node>();
        multiIterator.addIterator(this.out(edgeLabels));
        multiIterator.addIterator(this.in(edgeLabels));
        return multiIterator;
    }

    @Override
    public Iterator<Edge> outE() {
        MultiIterator<Edge> multiIterator = new MultiIterator<Edge>();
        for (String label : this.layoutInformation().allowedOutEdgeLabels()) {
            multiIterator.addIterator(this.outE(label));
        }
        return multiIterator;
    }

    @Override
    public Iterator<Edge> outE(String ... edgeLabels) {
        return this.createDummyEdgeIterator(Direction.OUT, edgeLabels);
    }

    @Override
    public Iterator<Edge> inE() {
        MultiIterator<Edge> multiIterator = new MultiIterator<Edge>();
        for (String label : this.layoutInformation().allowedInEdgeLabels()) {
            multiIterator.addIterator(this.inE(label));
        }
        return multiIterator;
    }

    @Override
    public Iterator<Edge> inE(String ... edgeLabels) {
        return this.createDummyEdgeIterator(Direction.IN, edgeLabels);
    }

    @Override
    public Iterator<Edge> bothE() {
        MultiIterator<Edge> multiIterator = new MultiIterator<Edge>();
        multiIterator.addIterator(this.outE());
        multiIterator.addIterator(this.inE());
        return multiIterator;
    }

    @Override
    public Iterator<Edge> bothE(String ... edgeLabels) {
        MultiIterator<Edge> multiIterator = new MultiIterator<Edge>();
        multiIterator.addIterator(this.outE(edgeLabels));
        multiIterator.addIterator(this.inE(edgeLabels));
        return multiIterator;
    }

    protected int outEdgeCount() {
        int count = 0;
        AdjacentNodes adjacentNodesTmp = this.adjacentNodes;
        for (String label : this.layoutInformation().allowedOutEdgeLabels()) {
            int offsetPos = this.getPositionInEdgeOffsets(Direction.OUT, label);
            if (offsetPos == -1) continue;
            int start = this.startIndex(adjacentNodesTmp, offsetPos);
            int length = this.blockLength(adjacentNodesTmp, offsetPos);
            int strideSize = this.getStrideSize(label);
            int exclusiveEnd = start + length;
            for (int i = start; i < adjacentNodesTmp.nodesWithEdgeProperties.length && i < exclusiveEnd; i += strideSize) {
                if (adjacentNodesTmp.nodesWithEdgeProperties[i] == null) continue;
                ++count;
            }
        }
        return count;
    }

    protected final int blockOffsetToOccurrence(Direction direction, String label, NodeRef otherNode, int blockOffset) {
        AdjacentNodes adjacentNodesTmp = this.adjacentNodes;
        int offsetPos = this.getPositionInEdgeOffsets(direction, label);
        int start = this.startIndex(adjacentNodesTmp, offsetPos);
        int strideSize = this.getStrideSize(label);
        Object[] adjacentNodesWithEdgeProperties = adjacentNodesTmp.nodesWithEdgeProperties;
        int occurrenceCount = -1;
        for (int i = start; i <= start + blockOffset; i += strideSize) {
            NodeRef adjacentNodeWithProperty = (NodeRef)adjacentNodesWithEdgeProperties[i];
            if (adjacentNodeWithProperty == null || adjacentNodeWithProperty.id() != otherNode.id()) continue;
            ++occurrenceCount;
        }
        if (occurrenceCount == -1) {
            throw new RuntimeException("unable to calculate occurrenceCount");
        }
        return occurrenceCount;
    }

    protected final int occurrenceToBlockOffset(Direction direction, String label, NodeRef adjacentNode, int occurrence) {
        AdjacentNodes adjacentNodesTmp = this.adjacentNodes;
        int offsetPos = this.getPositionInEdgeOffsets(direction, label);
        int start = this.startIndex(adjacentNodesTmp, offsetPos);
        int length = this.blockLength(adjacentNodesTmp, offsetPos);
        int strideSize = this.getStrideSize(label);
        Object[] adjacentNodesWithEdgeProperties = adjacentNodesTmp.nodesWithEdgeProperties;
        int currentOccurrence = 0;
        int exclusiveEnd = start + length;
        for (int i = start; i < exclusiveEnd; i += strideSize) {
            NodeRef adjacentNodeWithProperty = (NodeRef)adjacentNodesWithEdgeProperties[i];
            if (adjacentNodeWithProperty == null || adjacentNodeWithProperty.id() != adjacentNode.id()) continue;
            if (currentOccurrence == occurrence) {
                int adjacentNodeIndex = i - start;
                return adjacentNodeIndex;
            }
            ++currentOccurrence;
        }
        throw new RuntimeException("Unable to find occurrence " + occurrence + " of " + label + " edge to node " + adjacentNode.id());
    }

    protected final synchronized void removeEdge(Direction direction, String label, int blockOffset) {
        AdjacentNodes adjacentNodesTmp = this.adjacentNodes;
        int offsetPos = this.getPositionInEdgeOffsets(direction, label);
        int start = this.startIndex(adjacentNodesTmp, offsetPos) + blockOffset;
        int strideSize = this.getStrideSize(label);
        Object[] adjacentNodesWithEdgeProperties = adjacentNodesTmp.nodesWithEdgeProperties;
        for (int i = start; i < start + strideSize; ++i) {
            adjacentNodesWithEdgeProperties[i] = null;
        }
        this.markAsDirty();
    }

    private Iterator<Edge> createDummyEdgeIterator(Direction direction, String ... labels) {
        if (labels.length == 1) {
            return this.createDummyEdgeIteratorForSingleLabel(this.adjacentNodes, direction, labels[0]);
        }
        String[] labelsToFollow = labels.length == 0 ? this.allowedLabelsByDirection(direction) : labels;
        MultiIterator<Edge> multiIterator = new MultiIterator<Edge>();
        for (String label : labelsToFollow) {
            multiIterator.addIterator(this.createDummyEdgeIteratorForSingleLabel(this.adjacentNodes, direction, label));
        }
        return multiIterator;
    }

    private Iterator<Edge> createDummyEdgeIteratorForSingleLabel(AdjacentNodes adjacentNodesTmp, Direction direction, String label) {
        int offsetPos = this.getPositionInEdgeOffsets(direction, label);
        if (offsetPos != -1) {
            int start = this.startIndex(adjacentNodesTmp, offsetPos);
            int length = this.blockLength(adjacentNodesTmp, offsetPos);
            int strideSize = this.getStrideSize(label);
            return new DummyEdgeIterator(adjacentNodesTmp.nodesWithEdgeProperties, start, start + length, strideSize, direction, label, this.ref);
        }
        return Collections.emptyIterator();
    }

    private final <A extends Node> Iterator<A> createAdjacentNodeIterator(Direction direction, String ... labels) {
        if (labels.length == 1) {
            return this.createAdjacentNodeIteratorByOffSet(this.getPositionInEdgeOffsets(direction, labels[0]));
        }
        String[] labelsToFollow = labels.length == 0 ? this.allowedLabelsByDirection(direction) : labels;
        MultiIterator<A> multiIterator = new MultiIterator<A>();
        for (String label : labelsToFollow) {
            multiIterator.addIterator(this.createAdjacentNodeIteratorByOffSet(this.getPositionInEdgeOffsets(direction, label)));
        }
        return multiIterator;
    }

    public final <A extends Node> Iterator<A> createAdjacentNodeIteratorByOffSet(int offsetPos) {
        AdjacentNodes adjacentNodesTmp = this.adjacentNodes;
        if (offsetPos != -1) {
            int start = this.startIndex(adjacentNodesTmp, offsetPos);
            int length = this.blockLength(adjacentNodesTmp, offsetPos);
            int strideSize = this.layoutInformation().getEdgePropertyCountByOffsetPos(offsetPos) + 1;
            return new ArrayOffsetIterator(adjacentNodesTmp.nodesWithEdgeProperties, start, start + length, strideSize);
        }
        return Collections.emptyIterator();
    }

    private final String[] allowedLabelsByDirection(Direction direction) {
        if (direction.equals((Object)Direction.OUT)) {
            return this.layoutInformation().allowedOutEdgeLabels();
        }
        if (direction.equals((Object)Direction.IN)) {
            return this.layoutInformation().allowedInEdgeLabels();
        }
        throw new UnsupportedOperationException(direction.toString());
    }

    public synchronized int storeAdjacentNode(Direction direction, String edgeLabel, NodeRef adjacentNode, Object ... edgeKeyValues) {
        int blockOffset = this.storeAdjacentNode(direction, edgeLabel, adjacentNode);
        for (int i = 0; i < edgeKeyValues.length; i += 2) {
            String key = (String)edgeKeyValues[i];
            Object value = edgeKeyValues[i + 1];
            this.setEdgeProperty(direction, edgeLabel, key, value, blockOffset);
        }
        this.markAsDirty();
        return blockOffset;
    }

    private final int storeAdjacentNode(Direction direction, String edgeLabel, NodeRef nodeRef) {
        AdjacentNodes tmp = this.adjacentNodes;
        int offsetPos = this.getPositionInEdgeOffsets(direction, edgeLabel);
        if (offsetPos == -1) {
            throw new RuntimeException(String.format("Edge with type='%s' with direction='%s' not supported by nodeType='%s'", new Object[]{edgeLabel, direction, this.label()}));
        }
        int start = this.startIndex(tmp, offsetPos);
        int length = this.blockLength(tmp, offsetPos);
        int strideSize = this.getStrideSize(edgeLabel);
        Object[] adjacentNodesWithEdgeProperties = tmp.nodesWithEdgeProperties;
        int edgeOffsetLengthB2 = tmp.offsetLengths() >> 1;
        int insertAt = start + length;
        if (adjacentNodesWithEdgeProperties.length <= insertAt || adjacentNodesWithEdgeProperties[insertAt] != null || offsetPos + 1 < edgeOffsetLengthB2 && insertAt >= this.startIndex(tmp, offsetPos + 1)) {
            tmp = this.growAdjacentNodesWithEdgeProperties(tmp, offsetPos, strideSize, insertAt, length);
        }
        tmp.nodesWithEdgeProperties[insertAt] = nodeRef;
        this.adjacentNodes = tmp = tmp.setOffset(2 * offsetPos + 1, length + strideSize);
        int blockOffset = length;
        return blockOffset;
    }

    public int startIndex(AdjacentNodes adjacentNodesTmp, int offsetPosition) {
        return adjacentNodesTmp.getOffset(2 * offsetPosition);
    }

    public final int getStrideSize(String edgeLabel) {
        int sizeForNodeRef = 1;
        Set<String> allowedPropertyKeys = this.layoutInformation().edgePropertyKeys(edgeLabel);
        return sizeForNodeRef + allowedPropertyKeys.size();
    }

    private final int getPositionInEdgeOffsets(Direction direction, String label) {
        Integer positionOrNull = direction == Direction.OUT ? this.layoutInformation().outEdgeToOffsetPosition(label) : this.layoutInformation().inEdgeToOffsetPosition(label);
        if (positionOrNull != null) {
            return positionOrNull;
        }
        return -1;
    }

    public final int blockLength(AdjacentNodes adjacentNodesTmp, int offsetPosition) {
        return adjacentNodesTmp.getOffset(2 * offsetPosition + 1);
    }

    private final AdjacentNodes growAdjacentNodesWithEdgeProperties(AdjacentNodes adjacentNodesOld, int offsetPos, int strideSize, int insertAt, int currentLength) {
        int growthEmptyFactor = 2;
        int additionalEntriesCount = (currentLength + strideSize) * growthEmptyFactor;
        Object[] nodesWithEdgePropertiesOld = adjacentNodesOld.nodesWithEdgeProperties;
        int newSize = nodesWithEdgePropertiesOld.length + additionalEntriesCount;
        Object[] nodesWithEdgePropertiesNew = new Object[newSize];
        System.arraycopy(nodesWithEdgePropertiesOld, 0, nodesWithEdgePropertiesNew, 0, insertAt);
        System.arraycopy(nodesWithEdgePropertiesOld, insertAt, nodesWithEdgePropertiesNew, insertAt + additionalEntriesCount, nodesWithEdgePropertiesOld.length - insertAt);
        AdjacentNodes res = new AdjacentNodes(nodesWithEdgePropertiesNew, adjacentNodesOld.offsets);
        int until = res.offsetLengths();
        int i = offsetPos + 1;
        while (2 * i < until) {
            res = res.setOffset(2 * i, res.getOffset(2 * i) + additionalEntriesCount);
            ++i;
        }
        return res;
    }

    public final Edge instantiateDummyEdge(String label, NodeRef outNode, NodeRef inNode) {
        EdgeFactory edgeFactory = this.ref.graph.edgeFactoryByLabel.get(label);
        if (edgeFactory == null) {
            throw new IllegalArgumentException("specializedEdgeFactory for label=" + label + " not found - please register on startup!");
        }
        return edgeFactory.createEdge(this.ref.graph, outNode, inNode);
    }

    public synchronized long trim() {
        AdjacentNodes adjacentNodesOld = this.adjacentNodes;
        int newSize = 0;
        int until = adjacentNodesOld.offsetLengths();
        int offsetPos = 0;
        while (2 * offsetPos < until) {
            int length = this.blockLength(adjacentNodesOld, offsetPos);
            newSize += length;
            ++offsetPos;
        }
        Object[] nodesWithEdgePropertiesNew = new Object[newSize];
        AdjacentNodes res = new AdjacentNodes(nodesWithEdgePropertiesNew, new byte[until]);
        int off = 0;
        int offsetPos2 = 0;
        while (2 * offsetPos2 < until) {
            int start = this.startIndex(adjacentNodesOld, offsetPos2);
            int length = this.blockLength(adjacentNodesOld, offsetPos2);
            System.arraycopy(adjacentNodesOld.nodesWithEdgeProperties, start, nodesWithEdgePropertiesNew, off, length);
            res = res.setOffset(2 * offsetPos2, off);
            res = res.setOffset(2 * offsetPos2 + 1, length);
            off += length;
            ++offsetPos2;
        }
        int oldSize = adjacentNodesOld.nodesWithEdgeProperties.length;
        this.adjacentNodes = res;
        return (long)newSize + ((long)oldSize << 32);
    }

    public final boolean isDirty() {
        return this.dirty;
    }

    public int hashCode() {
        long tmp = (this.id() ^ this.id() >>> 33 ^ 0xC89F69FAAA76B9B7L) * -6643127405084517747L;
        return (int)tmp ^ (int)(tmp >>> 32);
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof NodeDb && this.id() == ((Node)obj).id();
    }
}

