/*
 * Decompiled with CFR 0.152.
 */
package overflowdb.storage;

import java.io.IOException;
import java.util.Spliterator;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import overflowdb.Node;
import overflowdb.NodeDb;
import overflowdb.NodeRef;
import overflowdb.storage.NodeSerializer;
import overflowdb.storage.OdbStorage;

public class NodesWriter {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final NodeSerializer nodeSerializer;
    private final OdbStorage storage;

    public NodesWriter(NodeSerializer nodeSerializer, OdbStorage storage) {
        this.nodeSerializer = nodeSerializer;
        this.storage = storage;
    }

    public void writeAndClearBatched(Spliterator<? extends Node> nodes, int estimatedTotalCount) {
        if (estimatedTotalCount > 0) {
            this.logger.info(String.format("serializing and persisting %d nodes (this may take a while)", estimatedTotalCount));
        }
        AtomicInteger count = new AtomicInteger(0);
        ((Stream)StreamSupport.stream(nodes, true).map(this::serializeIfDirty).sequential()).forEach(serializedNode -> {
            if (serializedNode != null) {
                this.storage.persist(((SerializedNode)serializedNode).id, ((SerializedNode)serializedNode).data);
                int currCount = count.incrementAndGet();
                if (currCount % 100000 == 0) {
                    float progressPercent = 100.0f * (float)currCount / (float)estimatedTotalCount;
                    this.logger.debug(String.format("progress of writing nodes to storage: %.2f%s", Float.valueOf(Float.min(100.0f, progressPercent)), "%"));
                }
            }
        });
        if (estimatedTotalCount > 0) {
            this.logger.info(String.format("finished serializing and persisting %d nodes", estimatedTotalCount));
        }
    }

    private SerializedNode serializeIfDirty(Node node) {
        NodeDb nodeDb = null;
        NodeRef ref = null;
        if (node instanceof NodeDb) {
            nodeDb = (NodeDb)node;
            ref = nodeDb.ref;
        } else if (node instanceof NodeRef && (ref = (NodeRef)node).isSet()) {
            nodeDb = ref.get();
        }
        if (nodeDb != null && nodeDb.isDirty()) {
            try {
                byte[] data = this.nodeSerializer.serialize(nodeDb);
                NodeRef.clear(ref);
                return new SerializedNode(ref.id(), data);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    private static class SerializedNode {
        private final long id;
        private final byte[] data;

        private SerializedNode(long id, byte[] data) {
            this.id = id;
            this.data = data;
        }
    }
}

