/*
 * Decompiled with CFR 0.152.
 */
package overflowdb.util;

import java.util.Iterator;
import java.util.NoSuchElementException;
import overflowdb.Direction;
import overflowdb.Edge;
import overflowdb.NodeDb;
import overflowdb.NodeRef;

public class DummyEdgeIterator
implements Iterator<Edge> {
    private final Object[] array;
    private int current;
    private final int begin;
    private final int exclusiveEnd;
    private final int strideSize;
    private final Direction direction;
    private final String label;
    private final NodeRef thisRef;
    private Edge nextCached;

    public DummyEdgeIterator(Object[] array, int begin, int exclusiveEnd, int strideSize, Direction direction, String label, NodeRef thisRef) {
        this.array = array;
        this.begin = begin;
        this.current = begin;
        this.exclusiveEnd = exclusiveEnd;
        this.strideSize = strideSize;
        this.direction = direction;
        this.label = label;
        this.thisRef = thisRef;
    }

    @Override
    public final boolean hasNext() {
        return this.peekNext() != null;
    }

    private Edge peekNext() {
        if (this.nextCached != null) {
            return this.nextCached;
        }
        while (this.current < this.exclusiveEnd && this.array[this.current] == null) {
            this.current += this.strideSize;
        }
        if (this.current < this.exclusiveEnd) {
            this.nextCached = this.readNext();
            this.current += this.strideSize;
            return this.peekNext();
        }
        return null;
    }

    private Edge readNext() {
        Edge dummyEdge;
        NodeRef otherRef = (NodeRef)this.array[this.current];
        if (this.direction == Direction.OUT) {
            dummyEdge = ((NodeDb)this.thisRef.get()).instantiateDummyEdge(this.label, this.thisRef, otherRef);
            dummyEdge.setOutBlockOffset(this.current - this.begin);
        } else {
            dummyEdge = ((NodeDb)this.thisRef.get()).instantiateDummyEdge(this.label, otherRef, this.thisRef);
            dummyEdge.setInBlockOffset(this.current - this.begin);
        }
        return dummyEdge;
    }

    @Override
    public Edge next() {
        if (this.hasNext()) {
            Edge ret = this.peekNext();
            this.nextCached = null;
            return ret;
        }
        throw new NoSuchElementException();
    }
}

