/*
 * Decompiled with CFR 0.152.
 */
package overflowdb.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public final class MultiIterator<T>
implements Iterator<T>,
Serializable {
    private final List<Iterator<? extends T>> iterators = new ArrayList<Iterator<? extends T>>();
    private int current = 0;

    public static <A> MultiIterator<A> from(Iterator<A> ... iterators) {
        MultiIterator<A> result = new MultiIterator<A>();
        for (Iterator<A> iter : iterators) {
            result.addIterator(iter);
        }
        return result;
    }

    public void addIterator(Iterator<? extends T> iterator) {
        this.iterators.add(iterator);
    }

    @Override
    public boolean hasNext() {
        if (this.current >= this.iterators.size()) {
            return false;
        }
        Iterator<T> currentIterator = this.iterators.get(this.current);
        while (true) {
            if (currentIterator.hasNext()) {
                return true;
            }
            ++this.current;
            if (this.current >= this.iterators.size()) break;
            currentIterator = this.iterators.get(this.current);
        }
        return false;
    }

    @Override
    public void remove() {
        this.iterators.get(this.current).remove();
    }

    @Override
    public T next() {
        if (this.iterators.isEmpty()) {
            throw new NoSuchElementException();
        }
        Iterator<T> currentIterator = this.iterators.get(this.current);
        while (true) {
            if (currentIterator.hasNext()) {
                return currentIterator.next();
            }
            ++this.current;
            if (this.current >= this.iterators.size()) break;
            currentIterator = this.iterators.get(this.current);
        }
        throw new NoSuchElementException();
    }

    public void clear() {
        this.iterators.clear();
        this.current = 0;
    }
}

