/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.math;

import io.smallrye.mutiny.Multi;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.function.Function;

public class TopOperator<T extends Comparable<T>>
implements Function<Multi<T>, Multi<List<T>>> {
    private final int count;
    private final SortedSet<T> list;

    public TopOperator(int count) {
        this.count = count;
        this.list = new ConcurrentSkipListSet(Comparator.reverseOrder());
    }

    @Override
    public Multi<List<T>> apply(Multi<T> multi) {
        return multi.onTermination().invoke(this.list::clear).onItem().transformToMultiAndConcatenate(item -> {
            if (!this.list.add(item)) {
                return Multi.createFrom().empty();
            }
            if (this.list.size() > this.count) {
                Comparable last = (Comparable)this.list.last();
                this.list.remove(last);
                if (last != item) {
                    return Multi.createFrom().item(new ArrayList<T>(this.list));
                }
                return Multi.createFrom().empty();
            }
            return Multi.createFrom().item(new ArrayList<T>(this.list));
        });
    }
}

