/*
 * Decompiled with CFR 0.152.
 */
package mutiny.zero.internal;

import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import mutiny.zero.internal.AlreadyCompletedSubscription;
import mutiny.zero.internal.Helper;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class CompletionStagePublisher<T>
implements Publisher<T> {
    private final Supplier<CompletionStage<T>> completionStageSupplier;

    public CompletionStagePublisher(Supplier<CompletionStage<T>> completionStageSupplier) {
        this.completionStageSupplier = completionStageSupplier;
    }

    public void subscribe(Subscriber<? super T> subscriber) {
        block7: {
            Objects.requireNonNull(subscriber, "The subscriber cannot be null");
            CompletionStage<T> cs = this.completionStageSupplier.get();
            if (cs == null) {
                subscriber.onSubscribe((Subscription)new AlreadyCompletedSubscription());
                subscriber.onError((Throwable)new NullPointerException("The completion stage is null"));
                return;
            }
            CompletableFuture<T> completableFuture = cs.toCompletableFuture();
            if (completableFuture.isDone()) {
                subscriber.onSubscribe((Subscription)new AlreadyCompletedSubscription());
                try {
                    T value = completableFuture.get();
                    if (value == null) {
                        subscriber.onError((Throwable)new NullPointerException("The CompletionStage produced a null value"));
                        break block7;
                    }
                    subscriber.onNext(value);
                    subscriber.onComplete();
                }
                catch (InterruptedException e) {
                    subscriber.onError((Throwable)e);
                }
                catch (ExecutionException e) {
                    subscriber.onError(e.getCause());
                }
            } else {
                subscriber.onSubscribe((Subscription)new CompletionStageSubscription(subscriber, completableFuture));
            }
        }
    }

    private class CompletionStageSubscription
    implements Subscription {
        private final Subscriber<? super T> subscriber;
        private final CompletableFuture<T> completableFuture;
        private final AtomicBoolean cancelled = new AtomicBoolean();

        private CompletionStageSubscription(Subscriber<? super T> subscriber, CompletableFuture<T> completableFuture) {
            this.subscriber = subscriber;
            this.completableFuture = completableFuture;
        }

        public void request(long n) {
            if (this.cancelled.get()) {
                return;
            }
            if (n <= 0L) {
                this.cancel();
                this.subscriber.onError((Throwable)Helper.negativeRequest(n));
            } else {
                this.completableFuture.whenComplete((value, err) -> {
                    if (this.cancelled.compareAndSet(false, true)) {
                        if (err != null) {
                            this.subscriber.onError(err);
                        } else if (value == null) {
                            this.subscriber.onError((Throwable)new NullPointerException("The CompletionStage produced a null value"));
                        } else {
                            this.subscriber.onNext(value);
                            this.subscriber.onComplete();
                        }
                    }
                });
            }
        }

        public void cancel() {
            this.cancelled.set(false);
            this.completableFuture.toCompletableFuture().cancel(false);
        }
    }
}

