/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.groups;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.groups.MultiIfEmpty;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.operators.MultiSwitchOnCompletion;
import io.smallrye.mutiny.operators.multi.MultiSignalConsumerOp;
import io.smallrye.mutiny.subscription.MultiEmitter;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;

public class MultiOnCompletion<T> {
    private final Multi<T> upstream;

    public MultiOnCompletion(Multi<T> upstream) {
        this.upstream = ParameterValidation.nonNull(upstream, "upstream");
    }

    public Multi<T> invoke(Runnable callback) {
        return Infrastructure.onMultiCreation(new MultiSignalConsumerOp<T>(this.upstream, null, null, null, ParameterValidation.nonNull(callback, "callback"), null, null, null));
    }

    public Multi<T> failWith(Throwable failure) {
        ParameterValidation.nonNull(failure, "failure");
        return this.failWith(() -> failure);
    }

    public Multi<T> failWith(Supplier<Throwable> supplier) {
        ParameterValidation.nonNull(supplier, "supplier");
        return this.switchToEmitter(MultiIfEmpty.createMultiFromFailureSupplier(supplier));
    }

    public Multi<T> fail() {
        return this.failWith(NoSuchElementException::new);
    }

    public Multi<T> switchToEmitter(Consumer<MultiEmitter<? super T>> consumer) {
        ParameterValidation.nonNull(consumer, "consumer");
        return this.switchTo(() -> Multi.createFrom().emitter(consumer));
    }

    public Multi<T> switchTo(Publisher<? extends T> other) {
        return this.switchTo(() -> other);
    }

    public Multi<T> switchTo(Supplier<Publisher<? extends T>> supplier) {
        return Infrastructure.onMultiCreation(new MultiSwitchOnCompletion<T>(this.upstream, ParameterValidation.nonNull(supplier, "supplier")));
    }

    @SafeVarargs
    public final Multi<T> continueWith(T ... items) {
        ParameterValidation.nonNull(items, "items");
        ParameterValidation.doesNotContainNull(items, "items");
        return this.continueWith(() -> Arrays.asList(items));
    }

    public Multi<T> continueWith(Iterable<T> items) {
        ParameterValidation.nonNull(items, "items");
        ParameterValidation.doesNotContainNull(items, "items");
        return this.continueWith(() -> items);
    }

    public Multi<T> continueWith(Supplier<? extends Iterable<? extends T>> supplier) {
        ParameterValidation.nonNull(supplier, "supplier");
        return this.switchTo(() -> MultiIfEmpty.createMultiFromIterableSupplier(supplier));
    }

    public MultiIfEmpty<T> ifEmpty() {
        return new MultiIfEmpty<T>(this.upstream);
    }
}

