/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.multi.processors;

import java.util.ArrayList;
import java.util.List;
import org.reactivestreams.Processor;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class SerializedProcessor<I, O>
implements Processor<I, O> {
    private final Processor<I, O> actual;
    private boolean emitting;
    private List<Object> queue;
    private volatile boolean done;

    public SerializedProcessor(Processor<I, O> actual) {
        this.actual = actual;
    }

    public void subscribe(Subscriber<? super O> downstream) {
        this.actual.subscribe(downstream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSubscribe(Subscription s) {
        boolean cancel;
        if (!this.done) {
            SerializedProcessor serializedProcessor = this;
            synchronized (serializedProcessor) {
                if (this.done) {
                    cancel = true;
                } else {
                    if (this.emitting) {
                        List<Object> q = this.queue;
                        if (q == null) {
                            this.queue = q = new ArrayList<Object>(4);
                        }
                        q.add(new SubscriptionEvent(s));
                        return;
                    }
                    this.emitting = true;
                    cancel = false;
                }
            }
        } else {
            cancel = true;
        }
        if (cancel) {
            s.cancel();
        } else {
            this.actual.onSubscribe(s);
            this.emitLoop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onNext(I item) {
        if (this.done) {
            return;
        }
        SerializedProcessor serializedProcessor = this;
        synchronized (serializedProcessor) {
            if (this.done) {
                return;
            }
            if (this.emitting) {
                List<Object> q = this.queue;
                if (q == null) {
                    this.queue = q = new ArrayList<Object>(4);
                }
                q.add(new ItemEvent(item));
                return;
            }
            this.emitting = true;
        }
        this.actual.onNext(item);
        this.emitLoop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onError(Throwable t) {
        if (this.done) {
            return;
        }
        SerializedProcessor serializedProcessor = this;
        synchronized (serializedProcessor) {
            if (this.done) {
                return;
            }
            this.done = true;
            if (this.emitting) {
                List<Object> q = this.queue;
                if (q == null) {
                    this.queue = q = new ArrayList<Object>(4);
                }
                q.add(0, new FailureEvent(t));
                return;
            }
            this.emitting = true;
        }
        this.actual.onError(t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onComplete() {
        if (this.done) {
            return;
        }
        SerializedProcessor serializedProcessor = this;
        synchronized (serializedProcessor) {
            if (this.done) {
                return;
            }
            this.done = true;
            if (this.emitting) {
                List<Object> q = this.queue;
                if (q == null) {
                    this.queue = q = new ArrayList<Object>(4);
                }
                q.add(new CompletionEvent());
                return;
            }
            this.emitting = true;
        }
        this.actual.onComplete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void emitLoop() {
        while (true) {
            List<Object> q;
            SerializedProcessor serializedProcessor = this;
            synchronized (serializedProcessor) {
                q = this.queue;
                if (q == null) {
                    this.emitting = false;
                    return;
                }
                this.queue = null;
            }
            this.dispatch(q, (Subscriber<I>)this.actual);
        }
    }

    public void dispatch(List<Object> queue, Subscriber<I> subscriber) {
        for (Object event : queue) {
            if (event == null) continue;
            if (event instanceof SubscriptionEvent) {
                subscriber.onSubscribe(((SubscriptionEvent)event).subscription);
            }
            if (event instanceof FailureEvent) {
                subscriber.onError(((FailureEvent)event).failure);
                return;
            }
            if (event instanceof CompletionEvent) {
                subscriber.onComplete();
                return;
            }
            if (!(event instanceof ItemEvent)) continue;
            subscriber.onNext(((ItemEvent)event).item);
        }
    }

    private static class CompletionEvent {
        private CompletionEvent() {
        }
    }

    private static class FailureEvent {
        private final Throwable failure;

        private FailureEvent(Throwable failure) {
            this.failure = failure;
        }
    }

    private static class ItemEvent<T> {
        private final T item;

        private ItemEvent(T item) {
            this.item = item;
        }
    }

    private static class SubscriptionEvent {
        private final Subscription subscription;

        private SubscriptionEvent(Subscription subscription) {
            this.subscription = subscription;
        }
    }
}

