/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.axle.cassandra;

import java.util.Map;
import org.reactivestreams.Publisher;
import java.util.function.Consumer;
import java.util.concurrent.CompletionStage;
import com.datastax.driver.core.Row;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

/**
 * A  for  consumption.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.cassandra.CassandraRowStream original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.axle.Gen(io.vertx.cassandra.CassandraRowStream.class)
public class CassandraRowStream implements io.vertx.axle.core.streams.ReadStream<Row> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    CassandraRowStream that = (CassandraRowStream) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.axle.TypeArg<CassandraRowStream> __TYPE_ARG = new io.vertx.lang.axle.TypeArg<>(    obj -> new CassandraRowStream((io.vertx.cassandra.CassandraRowStream) obj),
    CassandraRowStream::getDelegate
  );

  private final io.vertx.cassandra.CassandraRowStream delegate;
  
  public CassandraRowStream(io.vertx.cassandra.CassandraRowStream delegate) {
    this.delegate = delegate;
  }

  /**
  * Empty constructor used by CDI, do not use this constructor directly.
  **/
  CassandraRowStream() {    this.delegate = null;
  }

  public io.vertx.cassandra.CassandraRowStream getDelegate() {
    return delegate;
  }

  private org.reactivestreams.Publisher<Row> publisher;

  public synchronized org.reactivestreams.Publisher<Row> toPublisher() {
    if (publisher == null) {
      publisher = io.vertx.axle.PublisherHelper.toPublisher(this.getDelegate());
    }
    return publisher;
  }

  public synchronized org.eclipse.microprofile.reactive.streams.operators.PublisherBuilder<Row> toPublisherBuilder() {
    if (publisher == null) {
      publisher = io.vertx.axle.PublisherHelper.toPublisher(this.getDelegate());
    }
    return org.eclipse.microprofile.reactive.streams.operators.ReactiveStreams.fromPublisher(publisher);
  }

  public io.vertx.axle.core.streams.Pipe<Row> pipe() { 
    io.vertx.axle.core.streams.Pipe<Row> ret = io.vertx.axle.core.streams.Pipe.newInstance(delegate.pipe(), io.vertx.lang.axle.TypeArg.unknown());
    return ret;
  }

  private void __pipeTo(io.vertx.axle.core.streams.WriteStream<Row> dst, Handler<AsyncResult<Void>> handler) { 
    delegate.pipeTo(dst.getDelegate(), handler);
  }

  public CompletionStage<Void> pipeTo(io.vertx.axle.core.streams.WriteStream<Row> dst) { 
    return io.vertx.axle.AsyncResultCompletionStage.toCompletionStage(handler -> {
      __pipeTo(dst, handler);
    });
  }

  private io.vertx.axle.cassandra.CassandraRowStream __exceptionHandler(Handler<Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  public io.vertx.axle.cassandra.CassandraRowStream exceptionHandler(Consumer<Throwable> handler) {
    return __exceptionHandler(handler != null ? handler::accept : null);
  }

  public io.vertx.axle.cassandra.CassandraRowStream pause() { 
    delegate.pause();
    return this;
  }

  public io.vertx.axle.cassandra.CassandraRowStream resume() { 
    delegate.resume();
    return this;
  }

  private io.vertx.axle.cassandra.CassandraRowStream __endHandler(Handler<Void> handler) { 
    delegate.endHandler(handler);
    return this;
  }

  public io.vertx.axle.cassandra.CassandraRowStream endHandler(Consumer<Void> handler) {
    return __endHandler(handler != null ? handler::accept : null);
  }

  public io.vertx.axle.cassandra.CassandraRowStream fetch(long l) { 
    delegate.fetch(l);
    return this;
  }

  private io.vertx.axle.cassandra.CassandraRowStream __handler(Handler<Row> handler) { 
    delegate.handler(handler);
    return this;
  }

  public io.vertx.axle.cassandra.CassandraRowStream handler(Consumer<Row> handler) {
    return __handler(handler != null ? handler::accept : null);
  }


  public static  CassandraRowStream newInstance(io.vertx.cassandra.CassandraRowStream arg) {
    return arg != null ? new CassandraRowStream(arg) : null;
  }
}
