/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.axle.cassandra;

import java.util.Map;
import org.reactivestreams.Publisher;
import java.util.function.Consumer;
import java.util.concurrent.CompletionStage;

/**
 * It is like , but adapted for Vert.x.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.cassandra.MappingManager original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.axle.Gen(io.vertx.cassandra.MappingManager.class)
public class MappingManager {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MappingManager that = (MappingManager) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.axle.TypeArg<MappingManager> __TYPE_ARG = new io.vertx.lang.axle.TypeArg<>(    obj -> new MappingManager((io.vertx.cassandra.MappingManager) obj),
    MappingManager::getDelegate
  );

  private final io.vertx.cassandra.MappingManager delegate;
  
  public MappingManager(io.vertx.cassandra.MappingManager delegate) {
    this.delegate = delegate;
  }

  /**
  * Empty constructor used by CDI, do not use this constructor directly.
  **/
  MappingManager() {    this.delegate = null;
  }

  public io.vertx.cassandra.MappingManager getDelegate() {
    return delegate;
  }

  /**
   * Create a {@link io.vertx.axle.cassandra.MappingManager} from the given {@link io.vertx.axle.cassandra.CassandraClient}.
   * @param client a Cassandra client instance
   * @return 
   */
  public static io.vertx.axle.cassandra.MappingManager create(io.vertx.axle.cassandra.CassandraClient client) { 
    io.vertx.axle.cassandra.MappingManager ret = io.vertx.axle.cassandra.MappingManager.newInstance(io.vertx.cassandra.MappingManager.create(client.getDelegate()));
    return ret;
  }

  /**
   * Create a {@link io.vertx.axle.cassandra.Mapper} that allows conversion of domain classes to and from query results.
   * @param mappedClass mapped class
   * @return 
   */
  public <T> io.vertx.axle.cassandra.Mapper<T> mapper(Class<T> mappedClass) { 
    io.vertx.axle.cassandra.Mapper<T> ret = io.vertx.axle.cassandra.Mapper.newInstance(delegate.mapper(io.vertx.lang.axle.Helper.unwrap(mappedClass)), io.vertx.lang.axle.TypeArg.of(mappedClass));
    return ret;
  }


  public static  MappingManager newInstance(io.vertx.cassandra.MappingManager arg) {
    return arg != null ? new MappingManager(arg) : null;
  }
}
