package io.vertx.mutiny.mssqlclient;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Publisher;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import java.util.List;
import io.vertx.mssqlclient.MSSQLConnectOptions;
import io.vertx.core.Handler;
import java.util.function.Function;
import io.vertx.core.Future;
import io.vertx.sqlclient.PoolOptions;

/**
 * A  of {@link io.vertx.mutiny.mssqlclient.MSSQLConnection SQL Server connections}.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.mssqlclient.MSSQLPool original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.mssqlclient.MSSQLPool.class)
public class MSSQLPool extends io.vertx.mutiny.sqlclient.Pool {

  public static final io.smallrye.mutiny.vertx.TypeArg<MSSQLPool> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new MSSQLPool((io.vertx.mssqlclient.MSSQLPool) obj),
    MSSQLPool::getDelegate
  );

  private final io.vertx.mssqlclient.MSSQLPool delegate;
  
  public MSSQLPool(io.vertx.mssqlclient.MSSQLPool delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public MSSQLPool(Object delegate) {
    super((io.vertx.mssqlclient.MSSQLPool)delegate);
    this.delegate = (io.vertx.mssqlclient.MSSQLPool)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  MSSQLPool() {
    super(null);
    this.delegate = null;
  }

  public io.vertx.mssqlclient.MSSQLPool getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MSSQLPool that = (MSSQLPool) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @param connectionUri 
   * @return 
   */
  public static io.vertx.mutiny.mssqlclient.MSSQLPool pool(String connectionUri) { 
    io.vertx.mutiny.mssqlclient.MSSQLPool ret = io.vertx.mutiny.mssqlclient.MSSQLPool.newInstance((io.vertx.mssqlclient.MSSQLPool)io.vertx.mssqlclient.MSSQLPool.pool(connectionUri));
    return ret;
  }

  /**
   * @param connectionUri 
   * @param options 
   * @return 
   */
  public static io.vertx.mutiny.mssqlclient.MSSQLPool pool(String connectionUri, io.vertx.sqlclient.PoolOptions options) { 
    io.vertx.mutiny.mssqlclient.MSSQLPool ret = io.vertx.mutiny.mssqlclient.MSSQLPool.newInstance((io.vertx.mssqlclient.MSSQLPool)io.vertx.mssqlclient.MSSQLPool.pool(connectionUri, options));
    return ret;
  }

  /**
   * @param vertx 
   * @param connectionUri 
   * @return 
   */
  public static io.vertx.mutiny.mssqlclient.MSSQLPool pool(io.vertx.mutiny.core.Vertx vertx, String connectionUri) { 
    io.vertx.mutiny.mssqlclient.MSSQLPool ret = io.vertx.mutiny.mssqlclient.MSSQLPool.newInstance((io.vertx.mssqlclient.MSSQLPool)io.vertx.mssqlclient.MSSQLPool.pool(vertx.getDelegate(), connectionUri));
    return ret;
  }

  /**
   * @param vertx 
   * @param connectionUri 
   * @param options 
   * @return 
   */
  public static io.vertx.mutiny.mssqlclient.MSSQLPool pool(io.vertx.mutiny.core.Vertx vertx, String connectionUri, io.vertx.sqlclient.PoolOptions options) { 
    io.vertx.mutiny.mssqlclient.MSSQLPool ret = io.vertx.mutiny.mssqlclient.MSSQLPool.newInstance((io.vertx.mssqlclient.MSSQLPool)io.vertx.mssqlclient.MSSQLPool.pool(vertx.getDelegate(), connectionUri, options));
    return ret;
  }

  /**
   * @param database the options for the connection
   * @param options the options for creating the pool
   * @return the connection pool
   */
  public static io.vertx.mutiny.mssqlclient.MSSQLPool pool(io.vertx.mssqlclient.MSSQLConnectOptions database, io.vertx.sqlclient.PoolOptions options) { 
    io.vertx.mutiny.mssqlclient.MSSQLPool ret = io.vertx.mutiny.mssqlclient.MSSQLPool.newInstance((io.vertx.mssqlclient.MSSQLPool)io.vertx.mssqlclient.MSSQLPool.pool(database, options));
    return ret;
  }

  /**
   * @param vertx 
   * @param database 
   * @param options 
   * @return 
   */
  public static io.vertx.mutiny.mssqlclient.MSSQLPool pool(io.vertx.mutiny.core.Vertx vertx, io.vertx.mssqlclient.MSSQLConnectOptions database, io.vertx.sqlclient.PoolOptions options) { 
    io.vertx.mutiny.mssqlclient.MSSQLPool ret = io.vertx.mutiny.mssqlclient.MSSQLPool.newInstance((io.vertx.mssqlclient.MSSQLPool)io.vertx.mssqlclient.MSSQLPool.pool(vertx.getDelegate(), database, options));
    return ret;
  }

  /**
   * @param databases the list of databases
   * @param options the options for creating the pool
   * @return the connection pool
   */
  public static io.vertx.mutiny.mssqlclient.MSSQLPool pool(List<io.vertx.mssqlclient.MSSQLConnectOptions> databases, io.vertx.sqlclient.PoolOptions options) { 
    io.vertx.mutiny.mssqlclient.MSSQLPool ret = io.vertx.mutiny.mssqlclient.MSSQLPool.newInstance((io.vertx.mssqlclient.MSSQLPool)io.vertx.mssqlclient.MSSQLPool.pool(databases, options));
    return ret;
  }

  /**
   * @param vertx 
   * @param databases 
   * @param options 
   * @return 
   */
  public static io.vertx.mutiny.mssqlclient.MSSQLPool pool(io.vertx.mutiny.core.Vertx vertx, List<io.vertx.mssqlclient.MSSQLConnectOptions> databases, io.vertx.sqlclient.PoolOptions options) { 
    io.vertx.mutiny.mssqlclient.MSSQLPool ret = io.vertx.mutiny.mssqlclient.MSSQLPool.newInstance((io.vertx.mssqlclient.MSSQLPool)io.vertx.mssqlclient.MSSQLPool.pool(vertx.getDelegate(), databases, options));
    return ret;
  }

  @Fluent
  private io.vertx.mutiny.mssqlclient.MSSQLPool __connectHandler(Handler<io.vertx.mutiny.sqlclient.SqlConnection> handler) { 
    delegate.connectHandler(new Handler<io.vertx.sqlclient.SqlConnection>() {
      public void handle(io.vertx.sqlclient.SqlConnection event) {
        handler.handle(io.vertx.mutiny.sqlclient.SqlConnection.newInstance((io.vertx.sqlclient.SqlConnection)event));
      }
    });
    return this;
  }

  public io.vertx.mutiny.mssqlclient.MSSQLPool connectHandler(java.util.function.Consumer<io.vertx.mutiny.sqlclient.SqlConnection> handler) {
    return __connectHandler(handler != null ? handler::accept : null);
  }

  @Fluent
  public io.vertx.mutiny.mssqlclient.MSSQLPool connectionProvider(Function<io.vertx.mutiny.core.Context, io.smallrye.mutiny.Uni<io.vertx.mutiny.sqlclient.SqlConnection>> provider) { 
    delegate.connectionProvider(new java.util.function.Function<io.vertx.core.Context,io.vertx.core.Future<io.vertx.sqlclient.SqlConnection>>() {
      public io.vertx.core.Future<io.vertx.sqlclient.SqlConnection> apply(io.vertx.core.Context arg) {
            return io.smallrye.mutiny.vertx.UniHelper.toFuture(
                 provider.apply(io.vertx.mutiny.core.Context.newInstance((io.vertx.core.Context)arg)).map(x -> x.getDelegate())
            );
         }
     });
    return this;
  }

  public static  MSSQLPool newInstance(io.vertx.mssqlclient.MSSQLPool arg) {
    return arg != null ? new MSSQLPool(arg) : null;
  }

}
