package io.vertx.mutiny.redis.client;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Publisher;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import java.util.List;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Future;

/**
 * <b>Auto generated</b> Redis API client wrapper.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.redis.client.RedisAPI original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.redis.client.RedisAPI.class)
public class RedisAPI {

  public static final io.smallrye.mutiny.vertx.TypeArg<RedisAPI> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new RedisAPI((io.vertx.redis.client.RedisAPI) obj),
    RedisAPI::getDelegate
  );

  private final io.vertx.redis.client.RedisAPI delegate;
  
  public RedisAPI(io.vertx.redis.client.RedisAPI delegate) {
    this.delegate = delegate;
  }

  public RedisAPI(Object delegate) {
    this.delegate = (io.vertx.redis.client.RedisAPI)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  RedisAPI() {
    this.delegate = null;
  }

  public io.vertx.redis.client.RedisAPI getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    RedisAPI that = (RedisAPI) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public void close() { 
    delegate.close();
  }

  /**
   * Redis command <a href="https://redis.io/commands/acl">acl</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> acl(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.acl(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#acl(List<String>)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response aclAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) acl(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#acl(List<String>)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#acl(List<String>)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#acl(List<String>)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI aclAndForget(List<String> args) { 
    acl(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/append">append</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param arg0 
   * @param arg1 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> append(String arg0, String arg1) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.append(arg0, arg1, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#append(String,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param arg0 
   * @param arg1 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response appendAndAwait(String arg0, String arg1) { 
    return (io.vertx.mutiny.redis.client.Response) append(arg0, arg1).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#append(String,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#append(String,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#append(String,String)} but you don't need to compose it with other operations.
   * @param arg0 
   * @param arg1 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI appendAndForget(String arg0, String arg1) { 
    append(arg0, arg1).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/asking">asking</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> asking() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.asking(new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#asking}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response askingAndAwait() { 
    return (io.vertx.mutiny.redis.client.Response) asking().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#asking} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#asking}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#asking} but you don't need to compose it with other operations.
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI askingAndForget() { 
    asking().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/auth">auth</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> auth(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.auth(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#auth(List<String>)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response authAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) auth(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#auth(List<String>)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#auth(List<String>)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#auth(List<String>)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI authAndForget(List<String> args) { 
    auth(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/bgrewriteaof">bgrewriteaof</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> bgrewriteaof() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.bgrewriteaof(new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#bgrewriteaof}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response bgrewriteaofAndAwait() { 
    return (io.vertx.mutiny.redis.client.Response) bgrewriteaof().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#bgrewriteaof} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#bgrewriteaof}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#bgrewriteaof} but you don't need to compose it with other operations.
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI bgrewriteaofAndForget() { 
    bgrewriteaof().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/bgsave">bgsave</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> bgsave(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.bgsave(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#bgsave(List<String>)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response bgsaveAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) bgsave(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#bgsave(List<String>)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#bgsave(List<String>)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#bgsave(List<String>)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI bgsaveAndForget(List<String> args) { 
    bgsave(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/bitcount">bitcount</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> bitcount(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.bitcount(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#bitcount(List<String>)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response bitcountAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) bitcount(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#bitcount(List<String>)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#bitcount(List<String>)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#bitcount(List<String>)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI bitcountAndForget(List<String> args) { 
    bitcount(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/bitfield">bitfield</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> bitfield(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.bitfield(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#bitfield(List<String>)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response bitfieldAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) bitfield(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#bitfield(List<String>)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#bitfield(List<String>)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#bitfield(List<String>)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI bitfieldAndForget(List<String> args) { 
    bitfield(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/bitfield_ro">bitfieldRo</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> bitfieldRo(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.bitfieldRo(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#bitfieldRo(List<String>)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response bitfieldRoAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) bitfieldRo(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#bitfieldRo(List<String>)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#bitfieldRo(List<String>)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#bitfieldRo(List<String>)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI bitfieldRoAndForget(List<String> args) { 
    bitfieldRo(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/bitop">bitop</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> bitop(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.bitop(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#bitop(List<String>)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response bitopAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) bitop(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#bitop(List<String>)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#bitop(List<String>)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#bitop(List<String>)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI bitopAndForget(List<String> args) { 
    bitop(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/bitpos">bitpos</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> bitpos(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.bitpos(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#bitpos(List<String>)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response bitposAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) bitpos(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#bitpos(List<String>)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#bitpos(List<String>)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#bitpos(List<String>)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI bitposAndForget(List<String> args) { 
    bitpos(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/blmove">blmove</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param arg3 
   * @param arg4 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> blmove(String arg0, String arg1, String arg2, String arg3, String arg4) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.blmove(arg0, arg1, arg2, arg3, arg4, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#blmove(String,String,String,String,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param arg3 
   * @param arg4 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response blmoveAndAwait(String arg0, String arg1, String arg2, String arg3, String arg4) { 
    return (io.vertx.mutiny.redis.client.Response) blmove(arg0, arg1, arg2, arg3, arg4).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#blmove(String,String,String,String,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#blmove(String,String,String,String,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#blmove(String,String,String,String,String)} but you don't need to compose it with other operations.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param arg3 
   * @param arg4 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI blmoveAndForget(String arg0, String arg1, String arg2, String arg3, String arg4) { 
    blmove(arg0, arg1, arg2, arg3, arg4).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/blpop">blpop</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> blpop(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.blpop(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#blpop(List<String>)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response blpopAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) blpop(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#blpop(List<String>)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#blpop(List<String>)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#blpop(List<String>)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI blpopAndForget(List<String> args) { 
    blpop(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/brpop">brpop</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> brpop(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.brpop(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#brpop(List<String>)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response brpopAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) brpop(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#brpop(List<String>)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#brpop(List<String>)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#brpop(List<String>)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI brpopAndForget(List<String> args) { 
    brpop(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/brpoplpush">brpoplpush</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> brpoplpush(String arg0, String arg1, String arg2) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.brpoplpush(arg0, arg1, arg2, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#brpoplpush(String,String,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response brpoplpushAndAwait(String arg0, String arg1, String arg2) { 
    return (io.vertx.mutiny.redis.client.Response) brpoplpush(arg0, arg1, arg2).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#brpoplpush(String,String,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#brpoplpush(String,String,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#brpoplpush(String,String,String)} but you don't need to compose it with other operations.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI brpoplpushAndForget(String arg0, String arg1, String arg2) { 
    brpoplpush(arg0, arg1, arg2).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/bzpopmax">bzpopmax</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> bzpopmax(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.bzpopmax(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#bzpopmax(List<String>)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response bzpopmaxAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) bzpopmax(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#bzpopmax(List<String>)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#bzpopmax(List<String>)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#bzpopmax(List<String>)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI bzpopmaxAndForget(List<String> args) { 
    bzpopmax(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/bzpopmin">bzpopmin</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> bzpopmin(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.bzpopmin(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#bzpopmin(List<String>)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response bzpopminAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) bzpopmin(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#bzpopmin(List<String>)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#bzpopmin(List<String>)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#bzpopmin(List<String>)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI bzpopminAndForget(List<String> args) { 
    bzpopmin(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/client">client</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> client(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.client(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#client(List<String>)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response clientAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) client(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#client(List<String>)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#client(List<String>)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#client(List<String>)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI clientAndForget(List<String> args) { 
    client(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/cluster">cluster</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> cluster(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.cluster(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#cluster(List<String>)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response clusterAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) cluster(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#cluster(List<String>)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#cluster(List<String>)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#cluster(List<String>)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI clusterAndForget(List<String> args) { 
    cluster(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/command">command</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> command(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.command(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#command(List<String>)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response commandAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) command(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#command(List<String>)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#command(List<String>)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#command(List<String>)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI commandAndForget(List<String> args) { 
    command(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/config">config</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> config(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.config(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#config(List<String>)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response configAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) config(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#config(List<String>)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#config(List<String>)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#config(List<String>)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI configAndForget(List<String> args) { 
    config(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/copy">copy</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> copy(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.copy(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#copy(List<String>)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response copyAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) copy(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#copy(List<String>)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#copy(List<String>)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#copy(List<String>)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI copyAndForget(List<String> args) { 
    copy(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/dbsize">dbsize</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> dbsize() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.dbsize(new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#dbsize}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response dbsizeAndAwait() { 
    return (io.vertx.mutiny.redis.client.Response) dbsize().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#dbsize} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#dbsize}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#dbsize} but you don't need to compose it with other operations.
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI dbsizeAndForget() { 
    dbsize().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/debug">debug</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> debug(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.debug(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#debug(List<String>)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response debugAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) debug(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#debug(List<String>)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#debug(List<String>)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#debug(List<String>)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI debugAndForget(List<String> args) { 
    debug(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/decr">decr</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param arg0 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> decr(String arg0) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.decr(arg0, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#decr(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param arg0 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response decrAndAwait(String arg0) { 
    return (io.vertx.mutiny.redis.client.Response) decr(arg0).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#decr(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#decr(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#decr(String)} but you don't need to compose it with other operations.
   * @param arg0 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI decrAndForget(String arg0) { 
    decr(arg0).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/decrby">decrby</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param arg0 
   * @param arg1 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> decrby(String arg0, String arg1) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.decrby(arg0, arg1, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#decrby(String,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param arg0 
   * @param arg1 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response decrbyAndAwait(String arg0, String arg1) { 
    return (io.vertx.mutiny.redis.client.Response) decrby(arg0, arg1).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#decrby(String,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#decrby(String,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#decrby(String,String)} but you don't need to compose it with other operations.
   * @param arg0 
   * @param arg1 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI decrbyAndForget(String arg0, String arg1) { 
    decrby(arg0, arg1).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/del">del</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> del(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.del(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#del(List<String>)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response delAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) del(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#del(List<String>)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#del(List<String>)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#del(List<String>)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI delAndForget(List<String> args) { 
    del(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/discard">discard</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> discard() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.discard(new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#discard}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response discardAndAwait() { 
    return (io.vertx.mutiny.redis.client.Response) discard().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#discard} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#discard}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#discard} but you don't need to compose it with other operations.
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI discardAndForget() { 
    discard().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/dump">dump</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param arg0 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> dump(String arg0) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.dump(arg0, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#dump(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param arg0 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response dumpAndAwait(String arg0) { 
    return (io.vertx.mutiny.redis.client.Response) dump(arg0).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#dump(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#dump(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#dump(String)} but you don't need to compose it with other operations.
   * @param arg0 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI dumpAndForget(String arg0) { 
    dump(arg0).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/echo">echo</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param arg0 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> echo(String arg0) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.echo(arg0, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#echo(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param arg0 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response echoAndAwait(String arg0) { 
    return (io.vertx.mutiny.redis.client.Response) echo(arg0).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#echo(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#echo(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#echo(String)} but you don't need to compose it with other operations.
   * @param arg0 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI echoAndForget(String arg0) { 
    echo(arg0).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/eval">eval</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> eval(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.eval(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#eval(List<String>)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response evalAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) eval(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#eval(List<String>)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#eval(List<String>)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#eval(List<String>)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI evalAndForget(List<String> args) { 
    eval(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/evalsha">evalsha</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> evalsha(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.evalsha(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#evalsha(List<String>)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response evalshaAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) evalsha(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#evalsha(List<String>)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#evalsha(List<String>)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#evalsha(List<String>)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI evalshaAndForget(List<String> args) { 
    evalsha(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/exec">exec</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> exec() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.exec(new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#exec}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response execAndAwait() { 
    return (io.vertx.mutiny.redis.client.Response) exec().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#exec} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#exec}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#exec} but you don't need to compose it with other operations.
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI execAndForget() { 
    exec().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/exists">exists</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> exists(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.exists(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#exists(List<String>)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response existsAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) exists(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#exists(List<String>)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#exists(List<String>)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#exists(List<String>)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI existsAndForget(List<String> args) { 
    exists(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/expire">expire</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param arg0 
   * @param arg1 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> expire(String arg0, String arg1) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.expire(arg0, arg1, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#expire(String,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param arg0 
   * @param arg1 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response expireAndAwait(String arg0, String arg1) { 
    return (io.vertx.mutiny.redis.client.Response) expire(arg0, arg1).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#expire(String,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#expire(String,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#expire(String,String)} but you don't need to compose it with other operations.
   * @param arg0 
   * @param arg1 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI expireAndForget(String arg0, String arg1) { 
    expire(arg0, arg1).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/expireat">expireat</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param arg0 
   * @param arg1 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> expireat(String arg0, String arg1) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.expireat(arg0, arg1, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#expireat(String,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param arg0 
   * @param arg1 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response expireatAndAwait(String arg0, String arg1) { 
    return (io.vertx.mutiny.redis.client.Response) expireat(arg0, arg1).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#expireat(String,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#expireat(String,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#expireat(String,String)} but you don't need to compose it with other operations.
   * @param arg0 
   * @param arg1 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI expireatAndForget(String arg0, String arg1) { 
    expireat(arg0, arg1).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/failover">failover</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> failover(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.failover(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#failover(List<String>)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response failoverAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) failover(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#failover(List<String>)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#failover(List<String>)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#failover(List<String>)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI failoverAndForget(List<String> args) { 
    failover(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/flushall">flushall</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> flushall(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.flushall(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#flushall(List<String>)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response flushallAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) flushall(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#flushall(List<String>)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#flushall(List<String>)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#flushall(List<String>)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI flushallAndForget(List<String> args) { 
    flushall(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/flushdb">flushdb</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> flushdb(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.flushdb(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#flushdb(List<String>)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response flushdbAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) flushdb(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#flushdb(List<String>)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#flushdb(List<String>)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#flushdb(List<String>)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI flushdbAndForget(List<String> args) { 
    flushdb(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/geoadd">geoadd</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> geoadd(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.geoadd(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#geoadd(List<String>)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response geoaddAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) geoadd(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#geoadd(List<String>)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#geoadd(List<String>)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#geoadd(List<String>)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI geoaddAndForget(List<String> args) { 
    geoadd(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/geodist">geodist</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> geodist(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.geodist(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#geodist(List<String>)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response geodistAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) geodist(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#geodist(List<String>)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#geodist(List<String>)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#geodist(List<String>)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI geodistAndForget(List<String> args) { 
    geodist(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/geohash">geohash</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> geohash(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.geohash(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#geohash(List<String>)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response geohashAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) geohash(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#geohash(List<String>)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#geohash(List<String>)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#geohash(List<String>)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI geohashAndForget(List<String> args) { 
    geohash(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/geopos">geopos</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> geopos(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.geopos(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#geopos(List<String>)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response geoposAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) geopos(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#geopos(List<String>)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#geopos(List<String>)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#geopos(List<String>)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI geoposAndForget(List<String> args) { 
    geopos(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/georadius">georadius</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> georadius(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.georadius(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#georadius(List<String>)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response georadiusAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) georadius(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#georadius(List<String>)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#georadius(List<String>)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#georadius(List<String>)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI georadiusAndForget(List<String> args) { 
    georadius(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/georadius_ro">georadiusRo</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> georadiusRo(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.georadiusRo(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#georadiusRo(List<String>)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response georadiusRoAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) georadiusRo(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#georadiusRo(List<String>)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#georadiusRo(List<String>)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#georadiusRo(List<String>)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI georadiusRoAndForget(List<String> args) { 
    georadiusRo(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/georadiusbymember">georadiusbymember</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> georadiusbymember(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.georadiusbymember(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#georadiusbymember(List<String>)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response georadiusbymemberAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) georadiusbymember(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#georadiusbymember(List<String>)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#georadiusbymember(List<String>)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#georadiusbymember(List<String>)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI georadiusbymemberAndForget(List<String> args) { 
    georadiusbymember(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/georadiusbymember_ro">georadiusbymemberRo</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> georadiusbymemberRo(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.georadiusbymemberRo(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#georadiusbymemberRo(List<String>)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response georadiusbymemberRoAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) georadiusbymemberRo(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#georadiusbymemberRo(List<String>)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#georadiusbymemberRo(List<String>)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#georadiusbymemberRo(List<String>)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI georadiusbymemberRoAndForget(List<String> args) { 
    georadiusbymemberRo(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/geosearch">geosearch</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> geosearch(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.geosearch(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#geosearch(List<String>)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response geosearchAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) geosearch(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#geosearch(List<String>)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#geosearch(List<String>)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#geosearch(List<String>)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI geosearchAndForget(List<String> args) { 
    geosearch(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/geosearchstore">geosearchstore</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> geosearchstore(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.geosearchstore(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#geosearchstore(List<String>)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response geosearchstoreAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) geosearchstore(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#geosearchstore(List<String>)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#geosearchstore(List<String>)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#geosearchstore(List<String>)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI geosearchstoreAndForget(List<String> args) { 
    geosearchstore(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/get">get</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param arg0 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> get(String arg0) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.get(arg0, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#get(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param arg0 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response getAndAwait(String arg0) { 
    return (io.vertx.mutiny.redis.client.Response) get(arg0).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#get(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#get(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#get(String)} but you don't need to compose it with other operations.
   * @param arg0 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI getAndForget(String arg0) { 
    get(arg0).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/getbit">getbit</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param arg0 
   * @param arg1 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> getbit(String arg0, String arg1) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.getbit(arg0, arg1, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#getbit(String,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param arg0 
   * @param arg1 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response getbitAndAwait(String arg0, String arg1) { 
    return (io.vertx.mutiny.redis.client.Response) getbit(arg0, arg1).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#getbit(String,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#getbit(String,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#getbit(String,String)} but you don't need to compose it with other operations.
   * @param arg0 
   * @param arg1 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI getbitAndForget(String arg0, String arg1) { 
    getbit(arg0, arg1).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/getdel">getdel</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param arg0 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> getdel(String arg0) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.getdel(arg0, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#getdel(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param arg0 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response getdelAndAwait(String arg0) { 
    return (io.vertx.mutiny.redis.client.Response) getdel(arg0).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#getdel(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#getdel(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#getdel(String)} but you don't need to compose it with other operations.
   * @param arg0 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI getdelAndForget(String arg0) { 
    getdel(arg0).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/getex">getex</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> getex(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.getex(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#getex(List<String>)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response getexAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) getex(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#getex(List<String>)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#getex(List<String>)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#getex(List<String>)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI getexAndForget(List<String> args) { 
    getex(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/getrange">getrange</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> getrange(String arg0, String arg1, String arg2) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.getrange(arg0, arg1, arg2, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#getrange(String,String,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response getrangeAndAwait(String arg0, String arg1, String arg2) { 
    return (io.vertx.mutiny.redis.client.Response) getrange(arg0, arg1, arg2).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#getrange(String,String,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#getrange(String,String,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#getrange(String,String,String)} but you don't need to compose it with other operations.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI getrangeAndForget(String arg0, String arg1, String arg2) { 
    getrange(arg0, arg1, arg2).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/getset">getset</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param arg0 
   * @param arg1 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> getset(String arg0, String arg1) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.getset(arg0, arg1, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#getset(String,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param arg0 
   * @param arg1 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response getsetAndAwait(String arg0, String arg1) { 
    return (io.vertx.mutiny.redis.client.Response) getset(arg0, arg1).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#getset(String,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#getset(String,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#getset(String,String)} but you don't need to compose it with other operations.
   * @param arg0 
   * @param arg1 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI getsetAndForget(String arg0, String arg1) { 
    getset(arg0, arg1).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/hdel">hdel</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> hdel(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.hdel(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#hdel(List<String>)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response hdelAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) hdel(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#hdel(List<String>)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#hdel(List<String>)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#hdel(List<String>)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI hdelAndForget(List<String> args) { 
    hdel(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/hello">hello</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> hello(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.hello(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#hello(List<String>)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response helloAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) hello(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#hello(List<String>)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#hello(List<String>)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#hello(List<String>)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI helloAndForget(List<String> args) { 
    hello(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/hexists">hexists</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param arg0 
   * @param arg1 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> hexists(String arg0, String arg1) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.hexists(arg0, arg1, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#hexists(String,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param arg0 
   * @param arg1 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response hexistsAndAwait(String arg0, String arg1) { 
    return (io.vertx.mutiny.redis.client.Response) hexists(arg0, arg1).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#hexists(String,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#hexists(String,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#hexists(String,String)} but you don't need to compose it with other operations.
   * @param arg0 
   * @param arg1 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI hexistsAndForget(String arg0, String arg1) { 
    hexists(arg0, arg1).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/hget">hget</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param arg0 
   * @param arg1 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> hget(String arg0, String arg1) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.hget(arg0, arg1, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#hget(String,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param arg0 
   * @param arg1 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response hgetAndAwait(String arg0, String arg1) { 
    return (io.vertx.mutiny.redis.client.Response) hget(arg0, arg1).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#hget(String,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#hget(String,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#hget(String,String)} but you don't need to compose it with other operations.
   * @param arg0 
   * @param arg1 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI hgetAndForget(String arg0, String arg1) { 
    hget(arg0, arg1).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/hgetall">hgetall</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param arg0 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> hgetall(String arg0) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.hgetall(arg0, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#hgetall(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param arg0 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response hgetallAndAwait(String arg0) { 
    return (io.vertx.mutiny.redis.client.Response) hgetall(arg0).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#hgetall(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#hgetall(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#hgetall(String)} but you don't need to compose it with other operations.
   * @param arg0 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI hgetallAndForget(String arg0) { 
    hgetall(arg0).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/hincrby">hincrby</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> hincrby(String arg0, String arg1, String arg2) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.hincrby(arg0, arg1, arg2, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#hincrby(String,String,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response hincrbyAndAwait(String arg0, String arg1, String arg2) { 
    return (io.vertx.mutiny.redis.client.Response) hincrby(arg0, arg1, arg2).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#hincrby(String,String,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#hincrby(String,String,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#hincrby(String,String,String)} but you don't need to compose it with other operations.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI hincrbyAndForget(String arg0, String arg1, String arg2) { 
    hincrby(arg0, arg1, arg2).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/hincrbyfloat">hincrbyfloat</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> hincrbyfloat(String arg0, String arg1, String arg2) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.hincrbyfloat(arg0, arg1, arg2, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#hincrbyfloat(String,String,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response hincrbyfloatAndAwait(String arg0, String arg1, String arg2) { 
    return (io.vertx.mutiny.redis.client.Response) hincrbyfloat(arg0, arg1, arg2).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#hincrbyfloat(String,String,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#hincrbyfloat(String,String,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#hincrbyfloat(String,String,String)} but you don't need to compose it with other operations.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI hincrbyfloatAndForget(String arg0, String arg1, String arg2) { 
    hincrbyfloat(arg0, arg1, arg2).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/hkeys">hkeys</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param arg0 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> hkeys(String arg0) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.hkeys(arg0, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#hkeys(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param arg0 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response hkeysAndAwait(String arg0) { 
    return (io.vertx.mutiny.redis.client.Response) hkeys(arg0).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#hkeys(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#hkeys(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#hkeys(String)} but you don't need to compose it with other operations.
   * @param arg0 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI hkeysAndForget(String arg0) { 
    hkeys(arg0).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/hlen">hlen</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param arg0 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> hlen(String arg0) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.hlen(arg0, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#hlen(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param arg0 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response hlenAndAwait(String arg0) { 
    return (io.vertx.mutiny.redis.client.Response) hlen(arg0).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#hlen(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#hlen(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#hlen(String)} but you don't need to compose it with other operations.
   * @param arg0 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI hlenAndForget(String arg0) { 
    hlen(arg0).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/hmget">hmget</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> hmget(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.hmget(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#hmget(List<String>)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response hmgetAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) hmget(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#hmget(List<String>)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#hmget(List<String>)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#hmget(List<String>)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI hmgetAndForget(List<String> args) { 
    hmget(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/hmset">hmset</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> hmset(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.hmset(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#hmset(List<String>)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response hmsetAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) hmset(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#hmset(List<String>)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#hmset(List<String>)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#hmset(List<String>)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI hmsetAndForget(List<String> args) { 
    hmset(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/host:">host</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> host(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.host(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#host(List<String>)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response hostAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) host(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#host(List<String>)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#host(List<String>)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#host(List<String>)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI hostAndForget(List<String> args) { 
    host(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/hrandfield">hrandfield</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> hrandfield(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.hrandfield(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#hrandfield(List<String>)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response hrandfieldAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) hrandfield(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#hrandfield(List<String>)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#hrandfield(List<String>)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#hrandfield(List<String>)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI hrandfieldAndForget(List<String> args) { 
    hrandfield(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/hscan">hscan</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> hscan(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.hscan(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#hscan(List<String>)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response hscanAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) hscan(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#hscan(List<String>)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#hscan(List<String>)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#hscan(List<String>)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI hscanAndForget(List<String> args) { 
    hscan(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/hset">hset</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> hset(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.hset(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#hset(List<String>)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response hsetAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) hset(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#hset(List<String>)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#hset(List<String>)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#hset(List<String>)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI hsetAndForget(List<String> args) { 
    hset(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/hsetnx">hsetnx</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> hsetnx(String arg0, String arg1, String arg2) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.hsetnx(arg0, arg1, arg2, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#hsetnx(String,String,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response hsetnxAndAwait(String arg0, String arg1, String arg2) { 
    return (io.vertx.mutiny.redis.client.Response) hsetnx(arg0, arg1, arg2).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#hsetnx(String,String,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#hsetnx(String,String,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#hsetnx(String,String,String)} but you don't need to compose it with other operations.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI hsetnxAndForget(String arg0, String arg1, String arg2) { 
    hsetnx(arg0, arg1, arg2).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/hstrlen">hstrlen</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param arg0 
   * @param arg1 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> hstrlen(String arg0, String arg1) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.hstrlen(arg0, arg1, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#hstrlen(String,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param arg0 
   * @param arg1 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response hstrlenAndAwait(String arg0, String arg1) { 
    return (io.vertx.mutiny.redis.client.Response) hstrlen(arg0, arg1).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#hstrlen(String,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#hstrlen(String,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#hstrlen(String,String)} but you don't need to compose it with other operations.
   * @param arg0 
   * @param arg1 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI hstrlenAndForget(String arg0, String arg1) { 
    hstrlen(arg0, arg1).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/hvals">hvals</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param arg0 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> hvals(String arg0) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.hvals(arg0, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#hvals(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param arg0 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response hvalsAndAwait(String arg0) { 
    return (io.vertx.mutiny.redis.client.Response) hvals(arg0).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#hvals(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#hvals(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#hvals(String)} but you don't need to compose it with other operations.
   * @param arg0 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI hvalsAndForget(String arg0) { 
    hvals(arg0).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/incr">incr</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param arg0 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> incr(String arg0) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.incr(arg0, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#incr(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param arg0 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response incrAndAwait(String arg0) { 
    return (io.vertx.mutiny.redis.client.Response) incr(arg0).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#incr(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#incr(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#incr(String)} but you don't need to compose it with other operations.
   * @param arg0 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI incrAndForget(String arg0) { 
    incr(arg0).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/incrby">incrby</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param arg0 
   * @param arg1 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> incrby(String arg0, String arg1) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.incrby(arg0, arg1, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#incrby(String,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param arg0 
   * @param arg1 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response incrbyAndAwait(String arg0, String arg1) { 
    return (io.vertx.mutiny.redis.client.Response) incrby(arg0, arg1).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#incrby(String,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#incrby(String,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#incrby(String,String)} but you don't need to compose it with other operations.
   * @param arg0 
   * @param arg1 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI incrbyAndForget(String arg0, String arg1) { 
    incrby(arg0, arg1).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/incrbyfloat">incrbyfloat</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param arg0 
   * @param arg1 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> incrbyfloat(String arg0, String arg1) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.incrbyfloat(arg0, arg1, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#incrbyfloat(String,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param arg0 
   * @param arg1 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response incrbyfloatAndAwait(String arg0, String arg1) { 
    return (io.vertx.mutiny.redis.client.Response) incrbyfloat(arg0, arg1).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#incrbyfloat(String,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#incrbyfloat(String,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#incrbyfloat(String,String)} but you don't need to compose it with other operations.
   * @param arg0 
   * @param arg1 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI incrbyfloatAndForget(String arg0, String arg1) { 
    incrbyfloat(arg0, arg1).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/info">info</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> info(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.info(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#info(List<String>)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response infoAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) info(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#info(List<String>)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#info(List<String>)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#info(List<String>)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI infoAndForget(List<String> args) { 
    info(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/keys">keys</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param arg0 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> keys(String arg0) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.keys(arg0, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#keys(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param arg0 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response keysAndAwait(String arg0) { 
    return (io.vertx.mutiny.redis.client.Response) keys(arg0).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#keys(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#keys(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#keys(String)} but you don't need to compose it with other operations.
   * @param arg0 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI keysAndForget(String arg0) { 
    keys(arg0).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/lastsave">lastsave</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> lastsave() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.lastsave(new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#lastsave}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response lastsaveAndAwait() { 
    return (io.vertx.mutiny.redis.client.Response) lastsave().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#lastsave} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#lastsave}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#lastsave} but you don't need to compose it with other operations.
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI lastsaveAndForget() { 
    lastsave().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/latency">latency</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> latency(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.latency(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#latency(List<String>)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response latencyAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) latency(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#latency(List<String>)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#latency(List<String>)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#latency(List<String>)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI latencyAndForget(List<String> args) { 
    latency(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/lindex">lindex</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param arg0 
   * @param arg1 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> lindex(String arg0, String arg1) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.lindex(arg0, arg1, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#lindex(String,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param arg0 
   * @param arg1 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response lindexAndAwait(String arg0, String arg1) { 
    return (io.vertx.mutiny.redis.client.Response) lindex(arg0, arg1).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#lindex(String,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#lindex(String,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#lindex(String,String)} but you don't need to compose it with other operations.
   * @param arg0 
   * @param arg1 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI lindexAndForget(String arg0, String arg1) { 
    lindex(arg0, arg1).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/linsert">linsert</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param arg3 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> linsert(String arg0, String arg1, String arg2, String arg3) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.linsert(arg0, arg1, arg2, arg3, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#linsert(String,String,String,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param arg3 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response linsertAndAwait(String arg0, String arg1, String arg2, String arg3) { 
    return (io.vertx.mutiny.redis.client.Response) linsert(arg0, arg1, arg2, arg3).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#linsert(String,String,String,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#linsert(String,String,String,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#linsert(String,String,String,String)} but you don't need to compose it with other operations.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param arg3 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI linsertAndForget(String arg0, String arg1, String arg2, String arg3) { 
    linsert(arg0, arg1, arg2, arg3).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/llen">llen</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param arg0 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> llen(String arg0) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.llen(arg0, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#llen(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param arg0 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response llenAndAwait(String arg0) { 
    return (io.vertx.mutiny.redis.client.Response) llen(arg0).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#llen(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#llen(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#llen(String)} but you don't need to compose it with other operations.
   * @param arg0 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI llenAndForget(String arg0) { 
    llen(arg0).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/lmove">lmove</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param arg3 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> lmove(String arg0, String arg1, String arg2, String arg3) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.lmove(arg0, arg1, arg2, arg3, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#lmove(String,String,String,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param arg3 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response lmoveAndAwait(String arg0, String arg1, String arg2, String arg3) { 
    return (io.vertx.mutiny.redis.client.Response) lmove(arg0, arg1, arg2, arg3).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#lmove(String,String,String,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#lmove(String,String,String,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#lmove(String,String,String,String)} but you don't need to compose it with other operations.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param arg3 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI lmoveAndForget(String arg0, String arg1, String arg2, String arg3) { 
    lmove(arg0, arg1, arg2, arg3).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/lolwut">lolwut</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> lolwut(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.lolwut(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#lolwut(List<String>)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response lolwutAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) lolwut(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#lolwut(List<String>)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#lolwut(List<String>)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#lolwut(List<String>)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI lolwutAndForget(List<String> args) { 
    lolwut(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/lpop">lpop</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> lpop(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.lpop(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#lpop(List<String>)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response lpopAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) lpop(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#lpop(List<String>)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#lpop(List<String>)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#lpop(List<String>)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI lpopAndForget(List<String> args) { 
    lpop(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/lpos">lpos</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> lpos(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.lpos(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#lpos(List<String>)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response lposAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) lpos(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#lpos(List<String>)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#lpos(List<String>)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#lpos(List<String>)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI lposAndForget(List<String> args) { 
    lpos(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/lpush">lpush</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> lpush(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.lpush(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#lpush(List<String>)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response lpushAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) lpush(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#lpush(List<String>)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#lpush(List<String>)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#lpush(List<String>)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI lpushAndForget(List<String> args) { 
    lpush(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/lpushx">lpushx</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> lpushx(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.lpushx(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#lpushx(List<String>)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response lpushxAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) lpushx(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#lpushx(List<String>)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#lpushx(List<String>)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#lpushx(List<String>)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI lpushxAndForget(List<String> args) { 
    lpushx(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/lrange">lrange</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> lrange(String arg0, String arg1, String arg2) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.lrange(arg0, arg1, arg2, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#lrange(String,String,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response lrangeAndAwait(String arg0, String arg1, String arg2) { 
    return (io.vertx.mutiny.redis.client.Response) lrange(arg0, arg1, arg2).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#lrange(String,String,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#lrange(String,String,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#lrange(String,String,String)} but you don't need to compose it with other operations.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI lrangeAndForget(String arg0, String arg1, String arg2) { 
    lrange(arg0, arg1, arg2).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/lrem">lrem</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> lrem(String arg0, String arg1, String arg2) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.lrem(arg0, arg1, arg2, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#lrem(String,String,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response lremAndAwait(String arg0, String arg1, String arg2) { 
    return (io.vertx.mutiny.redis.client.Response) lrem(arg0, arg1, arg2).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#lrem(String,String,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#lrem(String,String,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#lrem(String,String,String)} but you don't need to compose it with other operations.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI lremAndForget(String arg0, String arg1, String arg2) { 
    lrem(arg0, arg1, arg2).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/lset">lset</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> lset(String arg0, String arg1, String arg2) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.lset(arg0, arg1, arg2, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#lset(String,String,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response lsetAndAwait(String arg0, String arg1, String arg2) { 
    return (io.vertx.mutiny.redis.client.Response) lset(arg0, arg1, arg2).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#lset(String,String,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#lset(String,String,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#lset(String,String,String)} but you don't need to compose it with other operations.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI lsetAndForget(String arg0, String arg1, String arg2) { 
    lset(arg0, arg1, arg2).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ltrim">ltrim</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> ltrim(String arg0, String arg1, String arg2) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.ltrim(arg0, arg1, arg2, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#ltrim(String,String,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response ltrimAndAwait(String arg0, String arg1, String arg2) { 
    return (io.vertx.mutiny.redis.client.Response) ltrim(arg0, arg1, arg2).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#ltrim(String,String,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#ltrim(String,String,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#ltrim(String,String,String)} but you don't need to compose it with other operations.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI ltrimAndForget(String arg0, String arg1, String arg2) { 
    ltrim(arg0, arg1, arg2).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/memory">memory</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> memory(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.memory(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#memory(List<String>)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response memoryAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) memory(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#memory(List<String>)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#memory(List<String>)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#memory(List<String>)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI memoryAndForget(List<String> args) { 
    memory(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/mget">mget</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> mget(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.mget(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#mget(List<String>)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response mgetAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) mget(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#mget(List<String>)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#mget(List<String>)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#mget(List<String>)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI mgetAndForget(List<String> args) { 
    mget(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/migrate">migrate</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> migrate(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.migrate(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#migrate(List<String>)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response migrateAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) migrate(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#migrate(List<String>)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#migrate(List<String>)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#migrate(List<String>)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI migrateAndForget(List<String> args) { 
    migrate(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/module">module</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> module(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.module(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#module(List<String>)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response moduleAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) module(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#module(List<String>)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#module(List<String>)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#module(List<String>)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI moduleAndForget(List<String> args) { 
    module(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/monitor">monitor</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> monitor() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.monitor(new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#monitor}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response monitorAndAwait() { 
    return (io.vertx.mutiny.redis.client.Response) monitor().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#monitor} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#monitor}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#monitor} but you don't need to compose it with other operations.
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI monitorAndForget() { 
    monitor().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/move">move</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param arg0 
   * @param arg1 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> move(String arg0, String arg1) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.move(arg0, arg1, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#move(String,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param arg0 
   * @param arg1 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response moveAndAwait(String arg0, String arg1) { 
    return (io.vertx.mutiny.redis.client.Response) move(arg0, arg1).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#move(String,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#move(String,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#move(String,String)} but you don't need to compose it with other operations.
   * @param arg0 
   * @param arg1 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI moveAndForget(String arg0, String arg1) { 
    move(arg0, arg1).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/mset">mset</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> mset(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.mset(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#mset(List<String>)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response msetAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) mset(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#mset(List<String>)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#mset(List<String>)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#mset(List<String>)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI msetAndForget(List<String> args) { 
    mset(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/msetnx">msetnx</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> msetnx(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.msetnx(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#msetnx(List<String>)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response msetnxAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) msetnx(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#msetnx(List<String>)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#msetnx(List<String>)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#msetnx(List<String>)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI msetnxAndForget(List<String> args) { 
    msetnx(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/multi">multi</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> multi() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.multi(new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#multi}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response multiAndAwait() { 
    return (io.vertx.mutiny.redis.client.Response) multi().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#multi} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#multi}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#multi} but you don't need to compose it with other operations.
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI multiAndForget() { 
    multi().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/object">object</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> object(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.object(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#object(List<String>)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response objectAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) object(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#object(List<String>)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#object(List<String>)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#object(List<String>)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI objectAndForget(List<String> args) { 
    object(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/persist">persist</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param arg0 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> persist(String arg0) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.persist(arg0, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#persist(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param arg0 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response persistAndAwait(String arg0) { 
    return (io.vertx.mutiny.redis.client.Response) persist(arg0).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#persist(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#persist(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#persist(String)} but you don't need to compose it with other operations.
   * @param arg0 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI persistAndForget(String arg0) { 
    persist(arg0).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/pexpire">pexpire</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param arg0 
   * @param arg1 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> pexpire(String arg0, String arg1) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.pexpire(arg0, arg1, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#pexpire(String,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param arg0 
   * @param arg1 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response pexpireAndAwait(String arg0, String arg1) { 
    return (io.vertx.mutiny.redis.client.Response) pexpire(arg0, arg1).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#pexpire(String,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#pexpire(String,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#pexpire(String,String)} but you don't need to compose it with other operations.
   * @param arg0 
   * @param arg1 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI pexpireAndForget(String arg0, String arg1) { 
    pexpire(arg0, arg1).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/pexpireat">pexpireat</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param arg0 
   * @param arg1 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> pexpireat(String arg0, String arg1) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.pexpireat(arg0, arg1, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#pexpireat(String,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param arg0 
   * @param arg1 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response pexpireatAndAwait(String arg0, String arg1) { 
    return (io.vertx.mutiny.redis.client.Response) pexpireat(arg0, arg1).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#pexpireat(String,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#pexpireat(String,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#pexpireat(String,String)} but you don't need to compose it with other operations.
   * @param arg0 
   * @param arg1 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI pexpireatAndForget(String arg0, String arg1) { 
    pexpireat(arg0, arg1).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/pfadd">pfadd</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> pfadd(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.pfadd(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#pfadd(List<String>)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response pfaddAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) pfadd(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#pfadd(List<String>)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#pfadd(List<String>)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#pfadd(List<String>)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI pfaddAndForget(List<String> args) { 
    pfadd(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/pfcount">pfcount</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> pfcount(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.pfcount(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#pfcount(List<String>)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response pfcountAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) pfcount(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#pfcount(List<String>)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#pfcount(List<String>)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#pfcount(List<String>)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI pfcountAndForget(List<String> args) { 
    pfcount(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/pfdebug">pfdebug</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> pfdebug(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.pfdebug(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#pfdebug(List<String>)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response pfdebugAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) pfdebug(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#pfdebug(List<String>)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#pfdebug(List<String>)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#pfdebug(List<String>)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI pfdebugAndForget(List<String> args) { 
    pfdebug(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/pfmerge">pfmerge</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> pfmerge(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.pfmerge(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#pfmerge(List<String>)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response pfmergeAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) pfmerge(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#pfmerge(List<String>)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#pfmerge(List<String>)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#pfmerge(List<String>)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI pfmergeAndForget(List<String> args) { 
    pfmerge(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/pfselftest">pfselftest</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> pfselftest() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.pfselftest(new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#pfselftest}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response pfselftestAndAwait() { 
    return (io.vertx.mutiny.redis.client.Response) pfselftest().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#pfselftest} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#pfselftest}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#pfselftest} but you don't need to compose it with other operations.
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI pfselftestAndForget() { 
    pfselftest().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ping">ping</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> ping(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.ping(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#ping(List<String>)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response pingAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) ping(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#ping(List<String>)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#ping(List<String>)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#ping(List<String>)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI pingAndForget(List<String> args) { 
    ping(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/post">post</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> post(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.post(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#post(List<String>)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response postAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) post(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#post(List<String>)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#post(List<String>)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#post(List<String>)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI postAndForget(List<String> args) { 
    post(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/psetex">psetex</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> psetex(String arg0, String arg1, String arg2) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.psetex(arg0, arg1, arg2, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#psetex(String,String,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response psetexAndAwait(String arg0, String arg1, String arg2) { 
    return (io.vertx.mutiny.redis.client.Response) psetex(arg0, arg1, arg2).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#psetex(String,String,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#psetex(String,String,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#psetex(String,String,String)} but you don't need to compose it with other operations.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI psetexAndForget(String arg0, String arg1, String arg2) { 
    psetex(arg0, arg1, arg2).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/psubscribe">psubscribe</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> psubscribe(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.psubscribe(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#psubscribe(List<String>)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response psubscribeAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) psubscribe(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#psubscribe(List<String>)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#psubscribe(List<String>)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#psubscribe(List<String>)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI psubscribeAndForget(List<String> args) { 
    psubscribe(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/psync">psync</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> psync(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.psync(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#psync(List<String>)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response psyncAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) psync(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#psync(List<String>)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#psync(List<String>)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#psync(List<String>)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI psyncAndForget(List<String> args) { 
    psync(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/pttl">pttl</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param arg0 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> pttl(String arg0) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.pttl(arg0, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#pttl(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param arg0 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response pttlAndAwait(String arg0) { 
    return (io.vertx.mutiny.redis.client.Response) pttl(arg0).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#pttl(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#pttl(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#pttl(String)} but you don't need to compose it with other operations.
   * @param arg0 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI pttlAndForget(String arg0) { 
    pttl(arg0).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/publish">publish</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param arg0 
   * @param arg1 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> publish(String arg0, String arg1) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.publish(arg0, arg1, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#publish(String,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param arg0 
   * @param arg1 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response publishAndAwait(String arg0, String arg1) { 
    return (io.vertx.mutiny.redis.client.Response) publish(arg0, arg1).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#publish(String,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#publish(String,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#publish(String,String)} but you don't need to compose it with other operations.
   * @param arg0 
   * @param arg1 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI publishAndForget(String arg0, String arg1) { 
    publish(arg0, arg1).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/pubsub">pubsub</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> pubsub(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.pubsub(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#pubsub(List<String>)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response pubsubAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) pubsub(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#pubsub(List<String>)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#pubsub(List<String>)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#pubsub(List<String>)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI pubsubAndForget(List<String> args) { 
    pubsub(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/punsubscribe">punsubscribe</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> punsubscribe(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.punsubscribe(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#punsubscribe(List<String>)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response punsubscribeAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) punsubscribe(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#punsubscribe(List<String>)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#punsubscribe(List<String>)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#punsubscribe(List<String>)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI punsubscribeAndForget(List<String> args) { 
    punsubscribe(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/randomkey">randomkey</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> randomkey() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.randomkey(new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#randomkey}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response randomkeyAndAwait() { 
    return (io.vertx.mutiny.redis.client.Response) randomkey().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#randomkey} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#randomkey}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#randomkey} but you don't need to compose it with other operations.
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI randomkeyAndForget() { 
    randomkey().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/readonly">readonly</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> readonly() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.readonly(new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#readonly}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response readonlyAndAwait() { 
    return (io.vertx.mutiny.redis.client.Response) readonly().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#readonly} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#readonly}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#readonly} but you don't need to compose it with other operations.
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI readonlyAndForget() { 
    readonly().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/readwrite">readwrite</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> readwrite() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.readwrite(new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#readwrite}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response readwriteAndAwait() { 
    return (io.vertx.mutiny.redis.client.Response) readwrite().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#readwrite} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#readwrite}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#readwrite} but you don't need to compose it with other operations.
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI readwriteAndForget() { 
    readwrite().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/rename">rename</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param arg0 
   * @param arg1 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> rename(String arg0, String arg1) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.rename(arg0, arg1, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#rename(String,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param arg0 
   * @param arg1 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response renameAndAwait(String arg0, String arg1) { 
    return (io.vertx.mutiny.redis.client.Response) rename(arg0, arg1).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#rename(String,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#rename(String,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#rename(String,String)} but you don't need to compose it with other operations.
   * @param arg0 
   * @param arg1 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI renameAndForget(String arg0, String arg1) { 
    rename(arg0, arg1).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/renamenx">renamenx</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param arg0 
   * @param arg1 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> renamenx(String arg0, String arg1) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.renamenx(arg0, arg1, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#renamenx(String,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param arg0 
   * @param arg1 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response renamenxAndAwait(String arg0, String arg1) { 
    return (io.vertx.mutiny.redis.client.Response) renamenx(arg0, arg1).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#renamenx(String,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#renamenx(String,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#renamenx(String,String)} but you don't need to compose it with other operations.
   * @param arg0 
   * @param arg1 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI renamenxAndForget(String arg0, String arg1) { 
    renamenx(arg0, arg1).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/replconf">replconf</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> replconf(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.replconf(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#replconf(List<String>)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response replconfAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) replconf(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#replconf(List<String>)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#replconf(List<String>)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#replconf(List<String>)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI replconfAndForget(List<String> args) { 
    replconf(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/replicaof">replicaof</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param arg0 
   * @param arg1 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> replicaof(String arg0, String arg1) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.replicaof(arg0, arg1, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#replicaof(String,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param arg0 
   * @param arg1 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response replicaofAndAwait(String arg0, String arg1) { 
    return (io.vertx.mutiny.redis.client.Response) replicaof(arg0, arg1).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#replicaof(String,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#replicaof(String,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#replicaof(String,String)} but you don't need to compose it with other operations.
   * @param arg0 
   * @param arg1 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI replicaofAndForget(String arg0, String arg1) { 
    replicaof(arg0, arg1).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/reset">reset</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> reset() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.reset(new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#reset}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response resetAndAwait() { 
    return (io.vertx.mutiny.redis.client.Response) reset().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#reset} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#reset}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#reset} but you don't need to compose it with other operations.
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI resetAndForget() { 
    reset().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/restore">restore</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> restore(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.restore(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#restore(List<String>)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response restoreAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) restore(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#restore(List<String>)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#restore(List<String>)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#restore(List<String>)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI restoreAndForget(List<String> args) { 
    restore(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/restore-asking">restoreAsking</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> restoreAsking(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.restoreAsking(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#restoreAsking(List<String>)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response restoreAskingAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) restoreAsking(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#restoreAsking(List<String>)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#restoreAsking(List<String>)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#restoreAsking(List<String>)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI restoreAskingAndForget(List<String> args) { 
    restoreAsking(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/role">role</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> role() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.role(new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#role}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response roleAndAwait() { 
    return (io.vertx.mutiny.redis.client.Response) role().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#role} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#role}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#role} but you don't need to compose it with other operations.
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI roleAndForget() { 
    role().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/rpop">rpop</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> rpop(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.rpop(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#rpop(List<String>)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response rpopAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) rpop(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#rpop(List<String>)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#rpop(List<String>)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#rpop(List<String>)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI rpopAndForget(List<String> args) { 
    rpop(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/rpoplpush">rpoplpush</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param arg0 
   * @param arg1 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> rpoplpush(String arg0, String arg1) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.rpoplpush(arg0, arg1, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#rpoplpush(String,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param arg0 
   * @param arg1 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response rpoplpushAndAwait(String arg0, String arg1) { 
    return (io.vertx.mutiny.redis.client.Response) rpoplpush(arg0, arg1).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#rpoplpush(String,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#rpoplpush(String,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#rpoplpush(String,String)} but you don't need to compose it with other operations.
   * @param arg0 
   * @param arg1 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI rpoplpushAndForget(String arg0, String arg1) { 
    rpoplpush(arg0, arg1).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/rpush">rpush</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> rpush(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.rpush(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#rpush(List<String>)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response rpushAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) rpush(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#rpush(List<String>)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#rpush(List<String>)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#rpush(List<String>)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI rpushAndForget(List<String> args) { 
    rpush(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/rpushx">rpushx</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> rpushx(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.rpushx(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#rpushx(List<String>)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response rpushxAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) rpushx(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#rpushx(List<String>)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#rpushx(List<String>)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#rpushx(List<String>)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI rpushxAndForget(List<String> args) { 
    rpushx(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/sadd">sadd</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> sadd(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.sadd(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#sadd(List<String>)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response saddAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) sadd(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#sadd(List<String>)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#sadd(List<String>)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#sadd(List<String>)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI saddAndForget(List<String> args) { 
    sadd(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/save">save</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> save() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.save(new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#save}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response saveAndAwait() { 
    return (io.vertx.mutiny.redis.client.Response) save().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#save} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#save}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#save} but you don't need to compose it with other operations.
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI saveAndForget() { 
    save().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/scan">scan</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> scan(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.scan(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#scan(List<String>)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response scanAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) scan(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#scan(List<String>)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#scan(List<String>)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#scan(List<String>)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI scanAndForget(List<String> args) { 
    scan(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/scard">scard</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param arg0 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> scard(String arg0) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.scard(arg0, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#scard(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param arg0 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response scardAndAwait(String arg0) { 
    return (io.vertx.mutiny.redis.client.Response) scard(arg0).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#scard(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#scard(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#scard(String)} but you don't need to compose it with other operations.
   * @param arg0 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI scardAndForget(String arg0) { 
    scard(arg0).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/script">script</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> script(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.script(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#script(List<String>)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response scriptAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) script(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#script(List<String>)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#script(List<String>)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#script(List<String>)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI scriptAndForget(List<String> args) { 
    script(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/sdiff">sdiff</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> sdiff(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.sdiff(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#sdiff(List<String>)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response sdiffAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) sdiff(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#sdiff(List<String>)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#sdiff(List<String>)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#sdiff(List<String>)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI sdiffAndForget(List<String> args) { 
    sdiff(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/sdiffstore">sdiffstore</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> sdiffstore(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.sdiffstore(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#sdiffstore(List<String>)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response sdiffstoreAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) sdiffstore(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#sdiffstore(List<String>)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#sdiffstore(List<String>)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#sdiffstore(List<String>)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI sdiffstoreAndForget(List<String> args) { 
    sdiffstore(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/select">select</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param arg0 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> select(String arg0) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.select(arg0, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#select(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param arg0 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response selectAndAwait(String arg0) { 
    return (io.vertx.mutiny.redis.client.Response) select(arg0).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#select(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#select(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#select(String)} but you don't need to compose it with other operations.
   * @param arg0 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI selectAndForget(String arg0) { 
    select(arg0).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/set">set</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> set(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.set(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#set(List<String>)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response setAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) set(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#set(List<String>)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#set(List<String>)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#set(List<String>)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI setAndForget(List<String> args) { 
    set(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/setbit">setbit</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> setbit(String arg0, String arg1, String arg2) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.setbit(arg0, arg1, arg2, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#setbit(String,String,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response setbitAndAwait(String arg0, String arg1, String arg2) { 
    return (io.vertx.mutiny.redis.client.Response) setbit(arg0, arg1, arg2).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#setbit(String,String,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#setbit(String,String,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#setbit(String,String,String)} but you don't need to compose it with other operations.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI setbitAndForget(String arg0, String arg1, String arg2) { 
    setbit(arg0, arg1, arg2).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/setex">setex</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> setex(String arg0, String arg1, String arg2) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.setex(arg0, arg1, arg2, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#setex(String,String,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response setexAndAwait(String arg0, String arg1, String arg2) { 
    return (io.vertx.mutiny.redis.client.Response) setex(arg0, arg1, arg2).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#setex(String,String,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#setex(String,String,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#setex(String,String,String)} but you don't need to compose it with other operations.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI setexAndForget(String arg0, String arg1, String arg2) { 
    setex(arg0, arg1, arg2).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/setnx">setnx</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param arg0 
   * @param arg1 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> setnx(String arg0, String arg1) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.setnx(arg0, arg1, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#setnx(String,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param arg0 
   * @param arg1 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response setnxAndAwait(String arg0, String arg1) { 
    return (io.vertx.mutiny.redis.client.Response) setnx(arg0, arg1).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#setnx(String,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#setnx(String,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#setnx(String,String)} but you don't need to compose it with other operations.
   * @param arg0 
   * @param arg1 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI setnxAndForget(String arg0, String arg1) { 
    setnx(arg0, arg1).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/setrange">setrange</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> setrange(String arg0, String arg1, String arg2) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.setrange(arg0, arg1, arg2, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#setrange(String,String,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response setrangeAndAwait(String arg0, String arg1, String arg2) { 
    return (io.vertx.mutiny.redis.client.Response) setrange(arg0, arg1, arg2).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#setrange(String,String,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#setrange(String,String,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#setrange(String,String,String)} but you don't need to compose it with other operations.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI setrangeAndForget(String arg0, String arg1, String arg2) { 
    setrange(arg0, arg1, arg2).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/shutdown">shutdown</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> shutdown(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.shutdown(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#shutdown(List<String>)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response shutdownAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) shutdown(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#shutdown(List<String>)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#shutdown(List<String>)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#shutdown(List<String>)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI shutdownAndForget(List<String> args) { 
    shutdown(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/sinter">sinter</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> sinter(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.sinter(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#sinter(List<String>)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response sinterAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) sinter(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#sinter(List<String>)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#sinter(List<String>)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#sinter(List<String>)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI sinterAndForget(List<String> args) { 
    sinter(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/sinterstore">sinterstore</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> sinterstore(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.sinterstore(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#sinterstore(List<String>)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response sinterstoreAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) sinterstore(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#sinterstore(List<String>)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#sinterstore(List<String>)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#sinterstore(List<String>)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI sinterstoreAndForget(List<String> args) { 
    sinterstore(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/sismember">sismember</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param arg0 
   * @param arg1 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> sismember(String arg0, String arg1) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.sismember(arg0, arg1, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#sismember(String,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param arg0 
   * @param arg1 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response sismemberAndAwait(String arg0, String arg1) { 
    return (io.vertx.mutiny.redis.client.Response) sismember(arg0, arg1).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#sismember(String,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#sismember(String,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#sismember(String,String)} but you don't need to compose it with other operations.
   * @param arg0 
   * @param arg1 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI sismemberAndForget(String arg0, String arg1) { 
    sismember(arg0, arg1).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/slaveof">slaveof</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param arg0 
   * @param arg1 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> slaveof(String arg0, String arg1) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.slaveof(arg0, arg1, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#slaveof(String,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param arg0 
   * @param arg1 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response slaveofAndAwait(String arg0, String arg1) { 
    return (io.vertx.mutiny.redis.client.Response) slaveof(arg0, arg1).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#slaveof(String,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#slaveof(String,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#slaveof(String,String)} but you don't need to compose it with other operations.
   * @param arg0 
   * @param arg1 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI slaveofAndForget(String arg0, String arg1) { 
    slaveof(arg0, arg1).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/slowlog">slowlog</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> slowlog(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.slowlog(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#slowlog(List<String>)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response slowlogAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) slowlog(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#slowlog(List<String>)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#slowlog(List<String>)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#slowlog(List<String>)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI slowlogAndForget(List<String> args) { 
    slowlog(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/smembers">smembers</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param arg0 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> smembers(String arg0) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.smembers(arg0, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#smembers(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param arg0 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response smembersAndAwait(String arg0) { 
    return (io.vertx.mutiny.redis.client.Response) smembers(arg0).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#smembers(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#smembers(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#smembers(String)} but you don't need to compose it with other operations.
   * @param arg0 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI smembersAndForget(String arg0) { 
    smembers(arg0).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/smismember">smismember</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> smismember(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.smismember(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#smismember(List<String>)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response smismemberAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) smismember(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#smismember(List<String>)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#smismember(List<String>)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#smismember(List<String>)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI smismemberAndForget(List<String> args) { 
    smismember(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/smove">smove</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> smove(String arg0, String arg1, String arg2) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.smove(arg0, arg1, arg2, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#smove(String,String,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response smoveAndAwait(String arg0, String arg1, String arg2) { 
    return (io.vertx.mutiny.redis.client.Response) smove(arg0, arg1, arg2).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#smove(String,String,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#smove(String,String,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#smove(String,String,String)} but you don't need to compose it with other operations.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI smoveAndForget(String arg0, String arg1, String arg2) { 
    smove(arg0, arg1, arg2).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/sort">sort</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> sort(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.sort(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#sort(List<String>)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response sortAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) sort(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#sort(List<String>)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#sort(List<String>)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#sort(List<String>)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI sortAndForget(List<String> args) { 
    sort(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/spop">spop</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> spop(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.spop(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#spop(List<String>)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response spopAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) spop(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#spop(List<String>)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#spop(List<String>)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#spop(List<String>)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI spopAndForget(List<String> args) { 
    spop(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/srandmember">srandmember</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> srandmember(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.srandmember(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#srandmember(List<String>)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response srandmemberAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) srandmember(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#srandmember(List<String>)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#srandmember(List<String>)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#srandmember(List<String>)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI srandmemberAndForget(List<String> args) { 
    srandmember(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/srem">srem</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> srem(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.srem(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#srem(List<String>)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response sremAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) srem(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#srem(List<String>)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#srem(List<String>)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#srem(List<String>)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI sremAndForget(List<String> args) { 
    srem(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/sscan">sscan</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> sscan(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.sscan(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#sscan(List<String>)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response sscanAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) sscan(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#sscan(List<String>)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#sscan(List<String>)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#sscan(List<String>)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI sscanAndForget(List<String> args) { 
    sscan(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/stralgo">stralgo</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> stralgo(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.stralgo(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#stralgo(List<String>)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response stralgoAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) stralgo(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#stralgo(List<String>)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#stralgo(List<String>)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#stralgo(List<String>)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI stralgoAndForget(List<String> args) { 
    stralgo(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/strlen">strlen</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param arg0 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> strlen(String arg0) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.strlen(arg0, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#strlen(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param arg0 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response strlenAndAwait(String arg0) { 
    return (io.vertx.mutiny.redis.client.Response) strlen(arg0).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#strlen(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#strlen(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#strlen(String)} but you don't need to compose it with other operations.
   * @param arg0 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI strlenAndForget(String arg0) { 
    strlen(arg0).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/subscribe">subscribe</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> subscribe(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.subscribe(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#subscribe(List<String>)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response subscribeAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) subscribe(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#subscribe(List<String>)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#subscribe(List<String>)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#subscribe(List<String>)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI subscribeAndForget(List<String> args) { 
    subscribe(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/substr">substr</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> substr(String arg0, String arg1, String arg2) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.substr(arg0, arg1, arg2, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#substr(String,String,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response substrAndAwait(String arg0, String arg1, String arg2) { 
    return (io.vertx.mutiny.redis.client.Response) substr(arg0, arg1, arg2).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#substr(String,String,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#substr(String,String,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#substr(String,String,String)} but you don't need to compose it with other operations.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI substrAndForget(String arg0, String arg1, String arg2) { 
    substr(arg0, arg1, arg2).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/sunion">sunion</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> sunion(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.sunion(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#sunion(List<String>)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response sunionAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) sunion(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#sunion(List<String>)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#sunion(List<String>)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#sunion(List<String>)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI sunionAndForget(List<String> args) { 
    sunion(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/sunionstore">sunionstore</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> sunionstore(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.sunionstore(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#sunionstore(List<String>)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response sunionstoreAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) sunionstore(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#sunionstore(List<String>)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#sunionstore(List<String>)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#sunionstore(List<String>)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI sunionstoreAndForget(List<String> args) { 
    sunionstore(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/swapdb">swapdb</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param arg0 
   * @param arg1 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> swapdb(String arg0, String arg1) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.swapdb(arg0, arg1, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#swapdb(String,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param arg0 
   * @param arg1 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response swapdbAndAwait(String arg0, String arg1) { 
    return (io.vertx.mutiny.redis.client.Response) swapdb(arg0, arg1).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#swapdb(String,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#swapdb(String,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#swapdb(String,String)} but you don't need to compose it with other operations.
   * @param arg0 
   * @param arg1 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI swapdbAndForget(String arg0, String arg1) { 
    swapdb(arg0, arg1).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/sync">sync</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> sync() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.sync(new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#sync}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response syncAndAwait() { 
    return (io.vertx.mutiny.redis.client.Response) sync().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#sync} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#sync}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#sync} but you don't need to compose it with other operations.
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI syncAndForget() { 
    sync().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/time">time</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> time() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.time(new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#time}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response timeAndAwait() { 
    return (io.vertx.mutiny.redis.client.Response) time().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#time} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#time}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#time} but you don't need to compose it with other operations.
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI timeAndForget() { 
    time().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/touch">touch</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> touch(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.touch(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#touch(List<String>)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response touchAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) touch(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#touch(List<String>)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#touch(List<String>)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#touch(List<String>)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI touchAndForget(List<String> args) { 
    touch(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ttl">ttl</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param arg0 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> ttl(String arg0) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.ttl(arg0, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#ttl(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param arg0 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response ttlAndAwait(String arg0) { 
    return (io.vertx.mutiny.redis.client.Response) ttl(arg0).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#ttl(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#ttl(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#ttl(String)} but you don't need to compose it with other operations.
   * @param arg0 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI ttlAndForget(String arg0) { 
    ttl(arg0).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/type">type</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param arg0 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> type(String arg0) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.type(arg0, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#type(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param arg0 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response typeAndAwait(String arg0) { 
    return (io.vertx.mutiny.redis.client.Response) type(arg0).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#type(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#type(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#type(String)} but you don't need to compose it with other operations.
   * @param arg0 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI typeAndForget(String arg0) { 
    type(arg0).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/unlink">unlink</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> unlink(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.unlink(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#unlink(List<String>)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response unlinkAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) unlink(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#unlink(List<String>)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#unlink(List<String>)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#unlink(List<String>)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI unlinkAndForget(List<String> args) { 
    unlink(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/unsubscribe">unsubscribe</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> unsubscribe(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.unsubscribe(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#unsubscribe(List<String>)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response unsubscribeAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) unsubscribe(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#unsubscribe(List<String>)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#unsubscribe(List<String>)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#unsubscribe(List<String>)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI unsubscribeAndForget(List<String> args) { 
    unsubscribe(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/unwatch">unwatch</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> unwatch() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.unwatch(new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#unwatch}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response unwatchAndAwait() { 
    return (io.vertx.mutiny.redis.client.Response) unwatch().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#unwatch} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#unwatch}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#unwatch} but you don't need to compose it with other operations.
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI unwatchAndForget() { 
    unwatch().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/wait">wait</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param arg0 
   * @param arg1 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> wait(String arg0, String arg1) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.wait(arg0, arg1, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#wait(String,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param arg0 
   * @param arg1 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response waitAndAwait(String arg0, String arg1) { 
    return (io.vertx.mutiny.redis.client.Response) wait(arg0, arg1).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#wait(String,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#wait(String,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#wait(String,String)} but you don't need to compose it with other operations.
   * @param arg0 
   * @param arg1 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI waitAndForget(String arg0, String arg1) { 
    wait(arg0, arg1).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/watch">watch</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> watch(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.watch(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#watch(List<String>)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response watchAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) watch(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#watch(List<String>)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#watch(List<String>)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#watch(List<String>)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI watchAndForget(List<String> args) { 
    watch(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/xack">xack</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> xack(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.xack(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#xack(List<String>)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response xackAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) xack(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#xack(List<String>)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#xack(List<String>)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#xack(List<String>)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI xackAndForget(List<String> args) { 
    xack(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/xadd">xadd</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> xadd(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.xadd(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#xadd(List<String>)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response xaddAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) xadd(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#xadd(List<String>)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#xadd(List<String>)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#xadd(List<String>)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI xaddAndForget(List<String> args) { 
    xadd(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/xautoclaim">xautoclaim</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> xautoclaim(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.xautoclaim(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#xautoclaim(List<String>)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response xautoclaimAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) xautoclaim(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#xautoclaim(List<String>)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#xautoclaim(List<String>)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#xautoclaim(List<String>)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI xautoclaimAndForget(List<String> args) { 
    xautoclaim(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/xclaim">xclaim</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> xclaim(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.xclaim(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#xclaim(List<String>)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response xclaimAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) xclaim(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#xclaim(List<String>)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#xclaim(List<String>)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#xclaim(List<String>)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI xclaimAndForget(List<String> args) { 
    xclaim(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/xdel">xdel</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> xdel(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.xdel(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#xdel(List<String>)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response xdelAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) xdel(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#xdel(List<String>)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#xdel(List<String>)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#xdel(List<String>)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI xdelAndForget(List<String> args) { 
    xdel(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/xgroup">xgroup</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> xgroup(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.xgroup(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#xgroup(List<String>)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response xgroupAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) xgroup(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#xgroup(List<String>)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#xgroup(List<String>)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#xgroup(List<String>)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI xgroupAndForget(List<String> args) { 
    xgroup(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/xinfo">xinfo</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> xinfo(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.xinfo(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#xinfo(List<String>)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response xinfoAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) xinfo(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#xinfo(List<String>)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#xinfo(List<String>)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#xinfo(List<String>)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI xinfoAndForget(List<String> args) { 
    xinfo(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/xlen">xlen</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param arg0 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> xlen(String arg0) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.xlen(arg0, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#xlen(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param arg0 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response xlenAndAwait(String arg0) { 
    return (io.vertx.mutiny.redis.client.Response) xlen(arg0).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#xlen(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#xlen(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#xlen(String)} but you don't need to compose it with other operations.
   * @param arg0 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI xlenAndForget(String arg0) { 
    xlen(arg0).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/xpending">xpending</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> xpending(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.xpending(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#xpending(List<String>)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response xpendingAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) xpending(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#xpending(List<String>)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#xpending(List<String>)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#xpending(List<String>)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI xpendingAndForget(List<String> args) { 
    xpending(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/xrange">xrange</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> xrange(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.xrange(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#xrange(List<String>)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response xrangeAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) xrange(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#xrange(List<String>)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#xrange(List<String>)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#xrange(List<String>)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI xrangeAndForget(List<String> args) { 
    xrange(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/xread">xread</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> xread(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.xread(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#xread(List<String>)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response xreadAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) xread(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#xread(List<String>)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#xread(List<String>)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#xread(List<String>)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI xreadAndForget(List<String> args) { 
    xread(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/xreadgroup">xreadgroup</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> xreadgroup(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.xreadgroup(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#xreadgroup(List<String>)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response xreadgroupAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) xreadgroup(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#xreadgroup(List<String>)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#xreadgroup(List<String>)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#xreadgroup(List<String>)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI xreadgroupAndForget(List<String> args) { 
    xreadgroup(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/xrevrange">xrevrange</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> xrevrange(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.xrevrange(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#xrevrange(List<String>)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response xrevrangeAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) xrevrange(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#xrevrange(List<String>)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#xrevrange(List<String>)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#xrevrange(List<String>)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI xrevrangeAndForget(List<String> args) { 
    xrevrange(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/xsetid">xsetid</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param arg0 
   * @param arg1 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> xsetid(String arg0, String arg1) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.xsetid(arg0, arg1, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#xsetid(String,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param arg0 
   * @param arg1 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response xsetidAndAwait(String arg0, String arg1) { 
    return (io.vertx.mutiny.redis.client.Response) xsetid(arg0, arg1).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#xsetid(String,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#xsetid(String,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#xsetid(String,String)} but you don't need to compose it with other operations.
   * @param arg0 
   * @param arg1 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI xsetidAndForget(String arg0, String arg1) { 
    xsetid(arg0, arg1).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/xtrim">xtrim</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> xtrim(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.xtrim(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#xtrim(List<String>)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response xtrimAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) xtrim(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#xtrim(List<String>)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#xtrim(List<String>)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#xtrim(List<String>)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI xtrimAndForget(List<String> args) { 
    xtrim(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zadd">zadd</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> zadd(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.zadd(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#zadd(List<String>)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response zaddAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) zadd(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#zadd(List<String>)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#zadd(List<String>)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#zadd(List<String>)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI zaddAndForget(List<String> args) { 
    zadd(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zcard">zcard</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param arg0 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> zcard(String arg0) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.zcard(arg0, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#zcard(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param arg0 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response zcardAndAwait(String arg0) { 
    return (io.vertx.mutiny.redis.client.Response) zcard(arg0).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#zcard(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#zcard(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#zcard(String)} but you don't need to compose it with other operations.
   * @param arg0 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI zcardAndForget(String arg0) { 
    zcard(arg0).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zcount">zcount</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> zcount(String arg0, String arg1, String arg2) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.zcount(arg0, arg1, arg2, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#zcount(String,String,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response zcountAndAwait(String arg0, String arg1, String arg2) { 
    return (io.vertx.mutiny.redis.client.Response) zcount(arg0, arg1, arg2).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#zcount(String,String,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#zcount(String,String,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#zcount(String,String,String)} but you don't need to compose it with other operations.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI zcountAndForget(String arg0, String arg1, String arg2) { 
    zcount(arg0, arg1, arg2).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zdiff">zdiff</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> zdiff(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.zdiff(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#zdiff(List<String>)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response zdiffAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) zdiff(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#zdiff(List<String>)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#zdiff(List<String>)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#zdiff(List<String>)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI zdiffAndForget(List<String> args) { 
    zdiff(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zdiffstore">zdiffstore</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> zdiffstore(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.zdiffstore(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#zdiffstore(List<String>)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response zdiffstoreAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) zdiffstore(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#zdiffstore(List<String>)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#zdiffstore(List<String>)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#zdiffstore(List<String>)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI zdiffstoreAndForget(List<String> args) { 
    zdiffstore(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zincrby">zincrby</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> zincrby(String arg0, String arg1, String arg2) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.zincrby(arg0, arg1, arg2, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#zincrby(String,String,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response zincrbyAndAwait(String arg0, String arg1, String arg2) { 
    return (io.vertx.mutiny.redis.client.Response) zincrby(arg0, arg1, arg2).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#zincrby(String,String,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#zincrby(String,String,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#zincrby(String,String,String)} but you don't need to compose it with other operations.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI zincrbyAndForget(String arg0, String arg1, String arg2) { 
    zincrby(arg0, arg1, arg2).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zinter">zinter</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> zinter(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.zinter(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#zinter(List<String>)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response zinterAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) zinter(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#zinter(List<String>)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#zinter(List<String>)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#zinter(List<String>)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI zinterAndForget(List<String> args) { 
    zinter(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zinterstore">zinterstore</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> zinterstore(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.zinterstore(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#zinterstore(List<String>)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response zinterstoreAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) zinterstore(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#zinterstore(List<String>)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#zinterstore(List<String>)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#zinterstore(List<String>)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI zinterstoreAndForget(List<String> args) { 
    zinterstore(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zlexcount">zlexcount</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> zlexcount(String arg0, String arg1, String arg2) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.zlexcount(arg0, arg1, arg2, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#zlexcount(String,String,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response zlexcountAndAwait(String arg0, String arg1, String arg2) { 
    return (io.vertx.mutiny.redis.client.Response) zlexcount(arg0, arg1, arg2).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#zlexcount(String,String,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#zlexcount(String,String,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#zlexcount(String,String,String)} but you don't need to compose it with other operations.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI zlexcountAndForget(String arg0, String arg1, String arg2) { 
    zlexcount(arg0, arg1, arg2).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zmscore">zmscore</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> zmscore(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.zmscore(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#zmscore(List<String>)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response zmscoreAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) zmscore(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#zmscore(List<String>)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#zmscore(List<String>)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#zmscore(List<String>)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI zmscoreAndForget(List<String> args) { 
    zmscore(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zpopmax">zpopmax</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> zpopmax(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.zpopmax(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#zpopmax(List<String>)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response zpopmaxAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) zpopmax(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#zpopmax(List<String>)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#zpopmax(List<String>)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#zpopmax(List<String>)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI zpopmaxAndForget(List<String> args) { 
    zpopmax(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zpopmin">zpopmin</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> zpopmin(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.zpopmin(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#zpopmin(List<String>)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response zpopminAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) zpopmin(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#zpopmin(List<String>)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#zpopmin(List<String>)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#zpopmin(List<String>)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI zpopminAndForget(List<String> args) { 
    zpopmin(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zrandmember">zrandmember</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> zrandmember(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.zrandmember(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#zrandmember(List<String>)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response zrandmemberAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) zrandmember(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#zrandmember(List<String>)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#zrandmember(List<String>)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#zrandmember(List<String>)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI zrandmemberAndForget(List<String> args) { 
    zrandmember(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zrange">zrange</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> zrange(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.zrange(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#zrange(List<String>)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response zrangeAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) zrange(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#zrange(List<String>)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#zrange(List<String>)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#zrange(List<String>)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI zrangeAndForget(List<String> args) { 
    zrange(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zrangebylex">zrangebylex</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> zrangebylex(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.zrangebylex(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#zrangebylex(List<String>)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response zrangebylexAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) zrangebylex(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#zrangebylex(List<String>)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#zrangebylex(List<String>)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#zrangebylex(List<String>)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI zrangebylexAndForget(List<String> args) { 
    zrangebylex(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zrangebyscore">zrangebyscore</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> zrangebyscore(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.zrangebyscore(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#zrangebyscore(List<String>)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response zrangebyscoreAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) zrangebyscore(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#zrangebyscore(List<String>)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#zrangebyscore(List<String>)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#zrangebyscore(List<String>)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI zrangebyscoreAndForget(List<String> args) { 
    zrangebyscore(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zrangestore">zrangestore</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> zrangestore(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.zrangestore(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#zrangestore(List<String>)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response zrangestoreAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) zrangestore(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#zrangestore(List<String>)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#zrangestore(List<String>)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#zrangestore(List<String>)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI zrangestoreAndForget(List<String> args) { 
    zrangestore(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zrank">zrank</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param arg0 
   * @param arg1 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> zrank(String arg0, String arg1) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.zrank(arg0, arg1, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#zrank(String,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param arg0 
   * @param arg1 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response zrankAndAwait(String arg0, String arg1) { 
    return (io.vertx.mutiny.redis.client.Response) zrank(arg0, arg1).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#zrank(String,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#zrank(String,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#zrank(String,String)} but you don't need to compose it with other operations.
   * @param arg0 
   * @param arg1 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI zrankAndForget(String arg0, String arg1) { 
    zrank(arg0, arg1).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zrem">zrem</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> zrem(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.zrem(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#zrem(List<String>)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response zremAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) zrem(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#zrem(List<String>)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#zrem(List<String>)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#zrem(List<String>)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI zremAndForget(List<String> args) { 
    zrem(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zremrangebylex">zremrangebylex</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> zremrangebylex(String arg0, String arg1, String arg2) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.zremrangebylex(arg0, arg1, arg2, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#zremrangebylex(String,String,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response zremrangebylexAndAwait(String arg0, String arg1, String arg2) { 
    return (io.vertx.mutiny.redis.client.Response) zremrangebylex(arg0, arg1, arg2).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#zremrangebylex(String,String,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#zremrangebylex(String,String,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#zremrangebylex(String,String,String)} but you don't need to compose it with other operations.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI zremrangebylexAndForget(String arg0, String arg1, String arg2) { 
    zremrangebylex(arg0, arg1, arg2).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zremrangebyrank">zremrangebyrank</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> zremrangebyrank(String arg0, String arg1, String arg2) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.zremrangebyrank(arg0, arg1, arg2, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#zremrangebyrank(String,String,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response zremrangebyrankAndAwait(String arg0, String arg1, String arg2) { 
    return (io.vertx.mutiny.redis.client.Response) zremrangebyrank(arg0, arg1, arg2).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#zremrangebyrank(String,String,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#zremrangebyrank(String,String,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#zremrangebyrank(String,String,String)} but you don't need to compose it with other operations.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI zremrangebyrankAndForget(String arg0, String arg1, String arg2) { 
    zremrangebyrank(arg0, arg1, arg2).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zremrangebyscore">zremrangebyscore</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> zremrangebyscore(String arg0, String arg1, String arg2) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.zremrangebyscore(arg0, arg1, arg2, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#zremrangebyscore(String,String,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response zremrangebyscoreAndAwait(String arg0, String arg1, String arg2) { 
    return (io.vertx.mutiny.redis.client.Response) zremrangebyscore(arg0, arg1, arg2).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#zremrangebyscore(String,String,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#zremrangebyscore(String,String,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#zremrangebyscore(String,String,String)} but you don't need to compose it with other operations.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI zremrangebyscoreAndForget(String arg0, String arg1, String arg2) { 
    zremrangebyscore(arg0, arg1, arg2).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zrevrange">zrevrange</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> zrevrange(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.zrevrange(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#zrevrange(List<String>)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response zrevrangeAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) zrevrange(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#zrevrange(List<String>)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#zrevrange(List<String>)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#zrevrange(List<String>)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI zrevrangeAndForget(List<String> args) { 
    zrevrange(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zrevrangebylex">zrevrangebylex</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> zrevrangebylex(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.zrevrangebylex(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#zrevrangebylex(List<String>)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response zrevrangebylexAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) zrevrangebylex(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#zrevrangebylex(List<String>)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#zrevrangebylex(List<String>)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#zrevrangebylex(List<String>)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI zrevrangebylexAndForget(List<String> args) { 
    zrevrangebylex(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zrevrangebyscore">zrevrangebyscore</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> zrevrangebyscore(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.zrevrangebyscore(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#zrevrangebyscore(List<String>)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response zrevrangebyscoreAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) zrevrangebyscore(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#zrevrangebyscore(List<String>)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#zrevrangebyscore(List<String>)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#zrevrangebyscore(List<String>)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI zrevrangebyscoreAndForget(List<String> args) { 
    zrevrangebyscore(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zrevrank">zrevrank</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param arg0 
   * @param arg1 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> zrevrank(String arg0, String arg1) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.zrevrank(arg0, arg1, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#zrevrank(String,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param arg0 
   * @param arg1 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response zrevrankAndAwait(String arg0, String arg1) { 
    return (io.vertx.mutiny.redis.client.Response) zrevrank(arg0, arg1).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#zrevrank(String,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#zrevrank(String,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#zrevrank(String,String)} but you don't need to compose it with other operations.
   * @param arg0 
   * @param arg1 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI zrevrankAndForget(String arg0, String arg1) { 
    zrevrank(arg0, arg1).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zscan">zscan</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> zscan(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.zscan(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#zscan(List<String>)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response zscanAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) zscan(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#zscan(List<String>)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#zscan(List<String>)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#zscan(List<String>)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI zscanAndForget(List<String> args) { 
    zscan(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zscore">zscore</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param arg0 
   * @param arg1 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> zscore(String arg0, String arg1) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.zscore(arg0, arg1, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#zscore(String,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param arg0 
   * @param arg1 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response zscoreAndAwait(String arg0, String arg1) { 
    return (io.vertx.mutiny.redis.client.Response) zscore(arg0, arg1).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#zscore(String,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#zscore(String,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#zscore(String,String)} but you don't need to compose it with other operations.
   * @param arg0 
   * @param arg1 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI zscoreAndForget(String arg0, String arg1) { 
    zscore(arg0, arg1).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zunion">zunion</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> zunion(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.zunion(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#zunion(List<String>)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response zunionAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) zunion(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#zunion(List<String>)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#zunion(List<String>)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#zunion(List<String>)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI zunionAndForget(List<String> args) { 
    zunion(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zunionstore">zunionstore</a>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param args 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> zunionstore(List<String> args) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.zunionstore(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisAPI#zunionstore(List<String>)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param args 
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response zunionstoreAndAwait(List<String> args) { 
    return (io.vertx.mutiny.redis.client.Response) zunionstore(args).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisAPI#zunionstore(List<String>)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisAPI#zunionstore(List<String>)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisAPI#zunionstore(List<String>)} but you don't need to compose it with other operations.
   * @param args 
   * @return the instance of RedisAPI to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisAPI zunionstoreAndForget(List<String> args) { 
    zunionstore(args).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  public static io.vertx.mutiny.redis.client.RedisAPI api(io.vertx.mutiny.redis.client.Redis client) { 
    io.vertx.mutiny.redis.client.RedisAPI ret = io.vertx.mutiny.redis.client.RedisAPI.newInstance((io.vertx.redis.client.RedisAPI)io.vertx.redis.client.RedisAPI.api(client.getDelegate()));
    return ret;
  }

  public static io.vertx.mutiny.redis.client.RedisAPI api(io.vertx.mutiny.redis.client.RedisConnection connection) { 
    io.vertx.mutiny.redis.client.RedisAPI ret = io.vertx.mutiny.redis.client.RedisAPI.newInstance((io.vertx.redis.client.RedisAPI)io.vertx.redis.client.RedisAPI.api(connection.getDelegate()));
    return ret;
  }

  public static  RedisAPI newInstance(io.vertx.redis.client.RedisAPI arg) {
    return arg != null ? new RedisAPI(arg) : null;
  }

}
