package io.vertx.mutiny.redis.client;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Publisher;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import java.util.List;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Future;

/**
 * A simple Redis client.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.redis.client.RedisConnection original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.redis.client.RedisConnection.class)
public class RedisConnection implements io.vertx.mutiny.core.streams.ReadStream<io.vertx.mutiny.redis.client.Response> {

  public static final io.smallrye.mutiny.vertx.TypeArg<RedisConnection> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new RedisConnection((io.vertx.redis.client.RedisConnection) obj),
    RedisConnection::getDelegate
  );

  private final io.vertx.redis.client.RedisConnection delegate;
  
  public RedisConnection(io.vertx.redis.client.RedisConnection delegate) {
    this.delegate = delegate;
  }

  public RedisConnection(Object delegate) {
    this.delegate = (io.vertx.redis.client.RedisConnection)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  RedisConnection() {
    this.delegate = null;
  }

  public io.vertx.redis.client.RedisConnection getDelegate() {
    return delegate;
  }

  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.redis.client.Response> TYPE_ARG_0 = new TypeArg<io.vertx.mutiny.redis.client.Response>(o1 -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)o1), o1 -> o1.getDelegate());
  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    RedisConnection that = (RedisConnection) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public io.vertx.mutiny.core.streams.Pipe<io.vertx.mutiny.redis.client.Response> pipe() { 
    io.vertx.mutiny.core.streams.Pipe<io.vertx.mutiny.redis.client.Response> ret = io.vertx.mutiny.core.streams.Pipe.newInstance((io.vertx.core.streams.Pipe)delegate.pipe(), TYPE_ARG_0);
    return ret;
  }

  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> pipeTo(io.vertx.mutiny.core.streams.WriteStream<io.vertx.mutiny.redis.client.Response> dst) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.pipeTo(dst.getDelegate(), handler);
    });
  }

  public Void pipeToAndAwait(io.vertx.mutiny.core.streams.WriteStream<io.vertx.mutiny.redis.client.Response> dst) { 
    return (Void) pipeTo(dst).await().indefinitely();
  }

  public void pipeToAndForget(io.vertx.mutiny.core.streams.WriteStream<io.vertx.mutiny.redis.client.Response> dst) { 
    pipeTo(dst).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * @param handler 
   * @return the instance of RedisConnection to chain method calls.
   */
  @Fluent
  private io.vertx.mutiny.redis.client.RedisConnection __exceptionHandler(Handler<java.lang.Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  /**
   * @param handler 
   * @return 
   */
  public io.vertx.mutiny.redis.client.RedisConnection exceptionHandler(java.util.function.Consumer<java.lang.Throwable> handler) {
    return __exceptionHandler(handler != null ? handler::accept : null);
  }

  /**
   * @param handler 
   * @return the instance of RedisConnection to chain method calls.
   */
  @Fluent
  private io.vertx.mutiny.redis.client.RedisConnection __handler(Handler<io.vertx.mutiny.redis.client.Response> handler) { 
    delegate.handler(new Handler<io.vertx.redis.client.Response>() {
      public void handle(io.vertx.redis.client.Response event) {
        handler.handle(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)event));
      }
    });
    return this;
  }

  /**
   * @param handler 
   * @return 
   */
  public io.vertx.mutiny.redis.client.RedisConnection handler(java.util.function.Consumer<io.vertx.mutiny.redis.client.Response> handler) {
    return __handler(handler != null ? handler::accept : null);
  }

  /**
   * @return the instance of RedisConnection to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisConnection pause() { 
    delegate.pause();
    return this;
  }

  /**
   * @return the instance of RedisConnection to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisConnection resume() { 
    delegate.resume();
    return this;
  }

  /**
   * @param amount 
   * @return the instance of RedisConnection to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisConnection fetch(long amount) { 
    delegate.fetch(amount);
    return this;
  }

  /**
   * @param endHandler 
   * @return the instance of RedisConnection to chain method calls.
   */
  @Fluent
  private io.vertx.mutiny.redis.client.RedisConnection __endHandler(Handler<Void> endHandler) { 
    delegate.endHandler(endHandler);
    return this;
  }

  /**
   * @param endHandler 
   * @return 
   */
  public io.vertx.mutiny.redis.client.RedisConnection endHandler(java.lang.Runnable endHandler) {
    return __endHandler(ignored -> endHandler.run()
);
  }

  /**
   * Send the given command to the redis server or cluster.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param command the command to send
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.redis.client.Response> send(io.vertx.mutiny.redis.client.Request command) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(onSend -> {
        delegate.send(command.getDelegate(), new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          onSend.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          onSend.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisConnection#send(io.vertx.mutiny.redis.client.Request)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param command the command to send
   * @return the Response instance produced by the operation.
   */
  public io.vertx.mutiny.redis.client.Response sendAndAwait(io.vertx.mutiny.redis.client.Request command) { 
    return (io.vertx.mutiny.redis.client.Response) send(command).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisConnection#send(io.vertx.mutiny.redis.client.Request)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisConnection#send(io.vertx.mutiny.redis.client.Request)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisConnection#send(io.vertx.mutiny.redis.client.Request)} but you don't need to compose it with other operations.
   * @param command the command to send
   * @return the instance of RedisConnection to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisConnection sendAndForget(io.vertx.mutiny.redis.client.Request command) { 
    send(command).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Sends a list of commands in a single IO operation, this prevents any inter twinning to happen from other
   * client users.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param commands list of command to send
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<List<io.vertx.mutiny.redis.client.Response>> batch(List<io.vertx.mutiny.redis.client.Request> commands) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(onSend -> {
        delegate.batch(commands.stream().map(elt -> elt.getDelegate()).collect(java.util.stream.Collectors.toList()), new Handler<AsyncResult<java.util.List<io.vertx.redis.client.Response>>>() {
      public void handle(AsyncResult<java.util.List<io.vertx.redis.client.Response>> ar) {
        if (ar.succeeded()) {
          onSend.handle(io.vertx.core.Future.succeededFuture(ar.result().stream().map(elt -> io.vertx.mutiny.redis.client.Response.newInstance((io.vertx.redis.client.Response)elt)).collect(java.util.stream.Collectors.toList())));
        } else {
          onSend.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisConnection#batch(List<Request>)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param commands list of command to send
   * @return the List<Response> instance produced by the operation.
   */
  public List<io.vertx.mutiny.redis.client.Response> batchAndAwait(List<io.vertx.mutiny.redis.client.Request> commands) { 
    return (List<io.vertx.mutiny.redis.client.Response>) batch(commands).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisConnection#batch(List<Request>)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisConnection#batch(List<Request>)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisConnection#batch(List<Request>)} but you don't need to compose it with other operations.
   * @param commands list of command to send
   * @return the instance of RedisConnection to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisConnection batchAndForget(List<io.vertx.mutiny.redis.client.Request> commands) { 
    batch(commands).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Closes the connection or returns to the pool.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> close() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(onClose -> {
        delegate.close(onClose);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.redis.client.RedisConnection#close}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the Void instance produced by the operation.
   */
  public Void closeAndAwait() { 
    return (Void) close().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.redis.client.RedisConnection#close} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.redis.client.RedisConnection#close}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.redis.client.RedisConnection#close} but you don't need to compose it with other operations.
   * @return the instance of RedisConnection to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.redis.client.RedisConnection closeAndForget() { 
    close().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * @return true is queue is full.
   */
  public boolean pendingQueueFull() { 
    boolean ret = delegate.pendingQueueFull();
    return ret;
  }

  private Multi<io.vertx.mutiny.redis.client.Response> multi;

  @CheckReturnValue
  public synchronized Multi<io.vertx.mutiny.redis.client.Response> toMulti() {
    if (multi == null) {
      java.util.function.Function<io.vertx.redis.client.Response, io.vertx.mutiny.redis.client.Response> conv = io.vertx.mutiny.redis.client.Response::newInstance;
      multi = io.smallrye.mutiny.vertx.MultiHelper.toMulti(delegate, conv);    }
    return multi;
  }

  public java.lang.Iterable<io.vertx.mutiny.redis.client.Response> toBlockingIterable() {
    return toMulti().subscribe().asIterable();
  }

  public java.util.stream.Stream<io.vertx.mutiny.redis.client.Response> toBlockingStream() {
    return toMulti().subscribe().asStream();
  }

  public static  RedisConnection newInstance(io.vertx.redis.client.RedisConnection arg) {
    return arg != null ? new RedisConnection(arg) : null;
  }

}
