package io.vertx.mutiny.ext.shell;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import java.util.List;
import java.util.function.Function;

/**
 * An interactive session between a consumer and a shell.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.shell.Shell original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.ext.shell.Shell.class)
public class Shell {

  public static final io.smallrye.mutiny.vertx.TypeArg<Shell> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new Shell((io.vertx.ext.shell.Shell) obj),
    Shell::getDelegate
  );

  private final io.vertx.ext.shell.Shell delegate;
  
  public Shell(io.vertx.ext.shell.Shell delegate) {
    this.delegate = delegate;
  }

  public Shell(Object delegate) {
    this.delegate = (io.vertx.ext.shell.Shell)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  Shell() {
    this.delegate = null;
  }

  public io.vertx.ext.shell.Shell getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    Shell that = (Shell) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @param line the command line creating this job
   * @return the created job
   */
  public io.vertx.mutiny.ext.shell.system.Job createJob(List<io.vertx.mutiny.ext.shell.cli.CliToken> line) { 
    io.vertx.mutiny.ext.shell.system.Job ret = io.vertx.mutiny.ext.shell.system.Job.newInstance((io.vertx.ext.shell.system.Job)delegate.createJob(line.stream().map(elt -> elt.getDelegate()).collect(java.util.stream.Collectors.toList())));
    return ret;
  }

  /**
   * @param line 
   * @return 
   */
  public io.vertx.mutiny.ext.shell.system.Job createJob(String line) { 
    io.vertx.mutiny.ext.shell.system.Job ret = io.vertx.mutiny.ext.shell.system.Job.newInstance((io.vertx.ext.shell.system.Job)delegate.createJob(line));
    return ret;
  }

  /**
   * @return the shell's job controller
   */
  public io.vertx.mutiny.ext.shell.system.JobController jobController() { 
    if (cached_0 != null) {
      return cached_0;
    }
    io.vertx.mutiny.ext.shell.system.JobController ret = io.vertx.mutiny.ext.shell.system.JobController.newInstance((io.vertx.ext.shell.system.JobController)delegate.jobController());
    cached_0 = ret;
    return ret;
  }

  /**
   * @return the current shell session
   */
  public io.vertx.mutiny.ext.shell.session.Session session() { 
    if (cached_1 != null) {
      return cached_1;
    }
    io.vertx.mutiny.ext.shell.session.Session ret = io.vertx.mutiny.ext.shell.session.Session.newInstance((io.vertx.ext.shell.session.Session)delegate.session());
    cached_1 = ret;
    return ret;
  }

  /**
   * @param prompt the new prompt will be calculated when it's needed.
   */
  public void setPrompt(Function<io.vertx.mutiny.ext.shell.session.Session, String> prompt) { 
    delegate.setPrompt(new java.util.function.Function<io.vertx.ext.shell.session.Session,java.lang.String>() {
      public String apply(io.vertx.ext.shell.session.Session arg) {
        String ret = prompt.apply(io.vertx.mutiny.ext.shell.session.Session.newInstance((io.vertx.ext.shell.session.Session)arg));
        return ret;
      }
    });
  }

  /**
   */
  public void close() { 
    delegate.close();
  }

  private io.vertx.mutiny.ext.shell.system.JobController cached_0;
  private io.vertx.mutiny.ext.shell.session.Session cached_1;
  public static  Shell newInstance(io.vertx.ext.shell.Shell arg) {
    return arg != null ? new Shell(arg) : null;
  }

}
