package io.vertx.mutiny.ext.shell;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import io.vertx.ext.shell.ShellServerOptions;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Future;

/**
 * The shell server.<p/>
 *
 * A shell server is associated with a collection of : the {@link io.vertx.mutiny.ext.shell.ShellServer#registerTermServer}
 * method registers a term server. Term servers life cycle are managed by this server.<p/>
 *
 * When a  receives an incoming connection, a  instance is created and
 * associated with this connection.<p/>
 *
 * The {@link io.vertx.mutiny.ext.shell.ShellServer#createShell} method can be used to create  instance for testing purposes.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.shell.ShellServer original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.ext.shell.ShellServer.class)
public class ShellServer {

  public static final io.smallrye.mutiny.vertx.TypeArg<ShellServer> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new ShellServer((io.vertx.ext.shell.ShellServer) obj),
    ShellServer::getDelegate
  );

  private final io.vertx.ext.shell.ShellServer delegate;
  
  public ShellServer(io.vertx.ext.shell.ShellServer delegate) {
    this.delegate = delegate;
  }

  public ShellServer(Object delegate) {
    this.delegate = (io.vertx.ext.shell.ShellServer)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  ShellServer() {
    this.delegate = null;
  }

  public io.vertx.ext.shell.ShellServer getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ShellServer that = (ShellServer) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @param vertx the vertx
   * @param options the options
   * @return the created shell server
   */
  public static io.vertx.mutiny.ext.shell.ShellServer create(io.vertx.mutiny.core.Vertx vertx, io.vertx.ext.shell.ShellServerOptions options) { 
    io.vertx.mutiny.ext.shell.ShellServer ret = io.vertx.mutiny.ext.shell.ShellServer.newInstance((io.vertx.ext.shell.ShellServer)io.vertx.ext.shell.ShellServer.create(vertx.getDelegate(), options));
    return ret;
  }

  /**
   * @param vertx the vertx
   * @return the created shell server
   */
  public static io.vertx.mutiny.ext.shell.ShellServer create(io.vertx.mutiny.core.Vertx vertx) { 
    io.vertx.mutiny.ext.shell.ShellServer ret = io.vertx.mutiny.ext.shell.ShellServer.newInstance((io.vertx.ext.shell.ShellServer)io.vertx.ext.shell.ShellServer.create(vertx.getDelegate()));
    return ret;
  }

  /**
   * @param resolver the resolver
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  public io.vertx.mutiny.ext.shell.ShellServer registerCommandResolver(io.vertx.mutiny.ext.shell.command.CommandResolver resolver) { 
    delegate.registerCommandResolver(resolver.getDelegate());
    return this;
  }

  /**
   * @param termServer the term server to add
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  public io.vertx.mutiny.ext.shell.ShellServer registerTermServer(io.vertx.mutiny.ext.shell.term.TermServer termServer) { 
    delegate.registerTermServer(termServer.getDelegate());
    return this;
  }

  /**
   * @param term the shell associated terminal
   * @return the created shell
   */
  public io.vertx.mutiny.ext.shell.Shell createShell(io.vertx.mutiny.ext.shell.term.Term term) { 
    io.vertx.mutiny.ext.shell.Shell ret = io.vertx.mutiny.ext.shell.Shell.newInstance((io.vertx.ext.shell.Shell)delegate.createShell(term.getDelegate()));
    return ret;
  }

  /**
   * @return the created shell
   */
  public io.vertx.mutiny.ext.shell.Shell createShell() { 
    io.vertx.mutiny.ext.shell.Shell ret = io.vertx.mutiny.ext.shell.Shell.newInstance((io.vertx.ext.shell.Shell)delegate.createShell());
    return ret;
  }

  /**
   * Start the shell service, this is an asynchronous start.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> listen() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(listenHandler -> {
        delegate.listen(listenHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.shell.ShellServer#listen}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the Void instance produced by the operation.
   */
  public Void listenAndAwait() { 
    return (Void) listen().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.shell.ShellServer#listen} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.shell.ShellServer#listen}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.shell.ShellServer#listen} but you don't need to compose it with other operations.
   * @return the instance of ShellServer to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.shell.ShellServer listenAndForget() { 
    listen().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Close the shell server, this is an asynchronous close.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> close() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(completionHandler -> {
        delegate.close(completionHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.shell.ShellServer#close}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the Void instance produced by the operation.
   */
  public Void closeAndAwait() { 
    return (Void) close().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.shell.ShellServer#close} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.shell.ShellServer#close}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.shell.ShellServer#close} but you don't need to compose it with other operations.
   */
  public void closeAndForget() { 
    close().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * @param shellHandler handler for getting notified when the server creates a new shell.
   */
  private void __shellHandler(Handler<io.vertx.mutiny.ext.shell.Shell> shellHandler) { 
    delegate.shellHandler(new io.smallrye.mutiny.vertx.DelegatingHandler<>(shellHandler, event -> io.vertx.mutiny.ext.shell.Shell.newInstance((io.vertx.ext.shell.Shell)event)));
  }

  /**
   * @param shellHandler handler for getting notified when the server creates a new shell.
   */
  public void shellHandler(java.util.function.Consumer<io.vertx.mutiny.ext.shell.Shell> shellHandler) {
    __shellHandler(shellHandler != null ? new io.smallrye.mutiny.vertx.DelegatingConsumerHandler(shellHandler) : null);
  }

  public static  ShellServer newInstance(io.vertx.ext.shell.ShellServer arg) {
    return arg != null ? new ShellServer(arg) : null;
  }

}
