package io.vertx.mutiny.ext.shell;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import io.vertx.ext.shell.ShellServiceOptions;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Future;

/**
 * The shell service, provides a remotely accessible shell available via Telnet or SSH according to the
 * {@link io.vertx.ext.shell.ShellServiceOptions} configuration.<p/>
 *
 * The shell service will expose commands using {@link io.vertx.mutiny.ext.shell.command.CommandResolver} on the classpath and
 * the shared command registry for the Vert.x instance.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.shell.ShellService original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.ext.shell.ShellService.class)
public class ShellService {

  public static final io.smallrye.mutiny.vertx.TypeArg<ShellService> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new ShellService((io.vertx.ext.shell.ShellService) obj),
    ShellService::getDelegate
  );

  private final io.vertx.ext.shell.ShellService delegate;
  
  public ShellService(io.vertx.ext.shell.ShellService delegate) {
    this.delegate = delegate;
  }

  public ShellService(Object delegate) {
    this.delegate = (io.vertx.ext.shell.ShellService)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  ShellService() {
    this.delegate = null;
  }

  public io.vertx.ext.shell.ShellService getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ShellService that = (ShellService) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @param vertx 
   * @return 
   */
  public static io.vertx.mutiny.ext.shell.ShellService create(io.vertx.mutiny.core.Vertx vertx) { 
    io.vertx.mutiny.ext.shell.ShellService ret = io.vertx.mutiny.ext.shell.ShellService.newInstance((io.vertx.ext.shell.ShellService)io.vertx.ext.shell.ShellService.create(vertx.getDelegate()));
    return ret;
  }

  /**
   * @param vertx the Vert.x instance
   * @param options the service config options
   * @return the shell service
   */
  public static io.vertx.mutiny.ext.shell.ShellService create(io.vertx.mutiny.core.Vertx vertx, io.vertx.ext.shell.ShellServiceOptions options) { 
    io.vertx.mutiny.ext.shell.ShellService ret = io.vertx.mutiny.ext.shell.ShellService.newInstance((io.vertx.ext.shell.ShellService)io.vertx.ext.shell.ShellService.create(vertx.getDelegate(), options));
    return ret;
  }

  /**
   * Start the shell service, this is an asynchronous start.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> start() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(startHandler -> {
        delegate.start(startHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.shell.ShellService#start}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the Void instance produced by the operation.
   */
  public Void startAndAwait() { 
    return (Void) start().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.shell.ShellService#start} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.shell.ShellService#start}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.shell.ShellService#start} but you don't need to compose it with other operations.
   */
  public void startAndForget() { 
    start().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * @return the shell server
   */
  public io.vertx.mutiny.ext.shell.ShellServer server() { 
    io.vertx.mutiny.ext.shell.ShellServer ret = io.vertx.mutiny.ext.shell.ShellServer.newInstance((io.vertx.ext.shell.ShellServer)delegate.server());
    return ret;
  }

  /**
   * Stop the shell service, this is an asynchronous start.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> stop() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(stopHandler -> {
        delegate.stop(stopHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.shell.ShellService#stop}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the Void instance produced by the operation.
   */
  public Void stopAndAwait() { 
    return (Void) stop().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.shell.ShellService#stop} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.shell.ShellService#stop}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.shell.ShellService#stop} but you don't need to compose it with other operations.
   */
  public void stopAndForget() { 
    stop().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  public static  ShellService newInstance(io.vertx.ext.shell.ShellService arg) {
    return arg != null ? new ShellService(arg) : null;
  }

}
