package io.vertx.mutiny.ext.shell.cli;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import java.util.List;

/**
 * A parsed token in the command line interface.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.shell.cli.CliToken original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.ext.shell.cli.CliToken.class)
public class CliToken {

  public static final io.smallrye.mutiny.vertx.TypeArg<CliToken> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new CliToken((io.vertx.ext.shell.cli.CliToken) obj),
    CliToken::getDelegate
  );

  private final io.vertx.ext.shell.cli.CliToken delegate;
  
  public CliToken(io.vertx.ext.shell.cli.CliToken delegate) {
    this.delegate = delegate;
  }

  public CliToken(Object delegate) {
    this.delegate = (io.vertx.ext.shell.cli.CliToken)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  CliToken() {
    this.delegate = null;
  }

  public io.vertx.ext.shell.cli.CliToken getDelegate() {
    return delegate;
  }

  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.ext.shell.cli.CliToken> TYPE_ARG_0 = new TypeArg<io.vertx.mutiny.ext.shell.cli.CliToken>(o1 -> io.vertx.mutiny.ext.shell.cli.CliToken.newInstance((io.vertx.ext.shell.cli.CliToken)o1), o1 -> o1.getDelegate());
  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    CliToken that = (CliToken) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @param text the text
   * @return the token
   */
  public static io.vertx.mutiny.ext.shell.cli.CliToken createText(String text) { 
    io.vertx.mutiny.ext.shell.cli.CliToken ret = io.vertx.mutiny.ext.shell.cli.CliToken.newInstance((io.vertx.ext.shell.cli.CliToken)io.vertx.ext.shell.cli.CliToken.createText(text));
    return ret;
  }

  /**
   * @param blank the blank value
   * @return the token
   */
  public static io.vertx.mutiny.ext.shell.cli.CliToken createBlank(String blank) { 
    io.vertx.mutiny.ext.shell.cli.CliToken ret = io.vertx.mutiny.ext.shell.cli.CliToken.newInstance((io.vertx.ext.shell.cli.CliToken)io.vertx.ext.shell.cli.CliToken.createBlank(blank));
    return ret;
  }

  /**
   * @return the token value
   */
  public String value() { 
    String ret = delegate.value();
    return ret;
  }

  /**
   * @return the raw token value, that may contain unescaped chars, for instance 
   */
  public String raw() { 
    String ret = delegate.raw();
    return ret;
  }

  /**
   * @return true when it's a text token
   */
  public boolean isText() { 
    boolean ret = delegate.isText();
    return ret;
  }

  /**
   * @return true when it's a blank token
   */
  public boolean isBlank() { 
    boolean ret = delegate.isBlank();
    return ret;
  }

  /**
   * @param s the tokenized string
   * @return the tokens
   */
  public static List<io.vertx.mutiny.ext.shell.cli.CliToken> tokenize(String s) { 
    List<io.vertx.mutiny.ext.shell.cli.CliToken> ret = io.vertx.ext.shell.cli.CliToken.tokenize(s).stream().map(elt -> io.vertx.mutiny.ext.shell.cli.CliToken.newInstance((io.vertx.ext.shell.cli.CliToken)elt)).collect(java.util.stream.Collectors.toList());
    return ret;
  }

  public static  CliToken newInstance(io.vertx.ext.shell.cli.CliToken arg) {
    return arg != null ? new CliToken(arg) : null;
  }

}
