package io.vertx.mutiny.ext.shell.cli;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import java.util.List;

/**
 * The completion object
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.shell.cli.Completion original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.ext.shell.cli.Completion.class)
public class Completion {

  public static final io.smallrye.mutiny.vertx.TypeArg<Completion> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new Completion((io.vertx.ext.shell.cli.Completion) obj),
    Completion::getDelegate
  );

  private final io.vertx.ext.shell.cli.Completion delegate;
  
  public Completion(io.vertx.ext.shell.cli.Completion delegate) {
    this.delegate = delegate;
  }

  public Completion(Object delegate) {
    this.delegate = (io.vertx.ext.shell.cli.Completion)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  Completion() {
    this.delegate = null;
  }

  public io.vertx.ext.shell.cli.Completion getDelegate() {
    return delegate;
  }

  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.ext.shell.cli.CliToken> TYPE_ARG_0 = new TypeArg<io.vertx.mutiny.ext.shell.cli.CliToken>(o1 -> io.vertx.mutiny.ext.shell.cli.CliToken.newInstance((io.vertx.ext.shell.cli.CliToken)o1), o1 -> o1.getDelegate());
  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    Completion that = (Completion) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @return the current Vert.x instance
   */
  public io.vertx.mutiny.core.Vertx vertx() { 
    io.vertx.mutiny.core.Vertx ret = io.vertx.mutiny.core.Vertx.newInstance((io.vertx.core.Vertx)delegate.vertx());
    return ret;
  }

  /**
   * @return the shell current session, useful for accessing data like the current path for file completion, etc...
   */
  public io.vertx.mutiny.ext.shell.session.Session session() { 
    io.vertx.mutiny.ext.shell.session.Session ret = io.vertx.mutiny.ext.shell.session.Session.newInstance((io.vertx.ext.shell.session.Session)delegate.session());
    return ret;
  }

  /**
   * @return the current line being completed in raw format, i.e without any char escape performed
   */
  public String rawLine() { 
    String ret = delegate.rawLine();
    return ret;
  }

  /**
   * @return the current line being completed as preparsed tokens
   */
  public List<io.vertx.mutiny.ext.shell.cli.CliToken> lineTokens() { 
    List<io.vertx.mutiny.ext.shell.cli.CliToken> ret = delegate.lineTokens().stream().map(elt -> io.vertx.mutiny.ext.shell.cli.CliToken.newInstance((io.vertx.ext.shell.cli.CliToken)elt)).collect(java.util.stream.Collectors.toList());
    return ret;
  }

  /**
   * @param candidates the candidates
   */
  public void complete(List<String> candidates) { 
    delegate.complete(candidates);
  }

  /**
   * @param value the value to complete with
   * @param terminal true if the value is terminal, i.e can be further completed
   */
  public void complete(String value, boolean terminal) { 
    delegate.complete(value, terminal);
  }

  public static  Completion newInstance(io.vertx.ext.shell.cli.Completion arg) {
    return arg != null ? new Completion(arg) : null;
  }

}
