package io.vertx.mutiny.ext.shell.command;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import java.util.List;

/**
 * A Vert.x Shell command, it can be created from any language using the {@link io.vertx.mutiny.ext.shell.command.CommandBuilder#command} or from a
 * Java class using {@link io.vertx.mutiny.ext.shell.command.Command#create}
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.shell.command.Command original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.ext.shell.command.Command.class)
public class Command {

  public static final io.smallrye.mutiny.vertx.TypeArg<Command> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new Command((io.vertx.ext.shell.command.Command) obj),
    Command::getDelegate
  );

  private final io.vertx.ext.shell.command.Command delegate;
  
  public Command(io.vertx.ext.shell.command.Command delegate) {
    this.delegate = delegate;
  }

  public Command(Object delegate) {
    this.delegate = (io.vertx.ext.shell.command.Command)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  Command() {
    this.delegate = null;
  }

  public io.vertx.ext.shell.command.Command getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    Command that = (Command) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @return the command name
   */
  public String name() { 
    String ret = delegate.name();
    return ret;
  }

  /**
   * @return the command line interface, can be null
   */
  public io.vertx.mutiny.core.cli.CLI cli() { 
    io.vertx.mutiny.core.cli.CLI ret = io.vertx.mutiny.core.cli.CLI.newInstance((io.vertx.core.cli.CLI)delegate.cli());
    return ret;
  }

  /**
   * @return the process
   */
  public io.vertx.mutiny.ext.shell.system.Process createProcess() { 
    io.vertx.mutiny.ext.shell.system.Process ret = io.vertx.mutiny.ext.shell.system.Process.newInstance((io.vertx.ext.shell.system.Process)delegate.createProcess());
    return ret;
  }

  /**
   * @param args the process arguments
   * @return the process
   */
  public io.vertx.mutiny.ext.shell.system.Process createProcess(List<io.vertx.mutiny.ext.shell.cli.CliToken> args) { 
    io.vertx.mutiny.ext.shell.system.Process ret = io.vertx.mutiny.ext.shell.system.Process.newInstance((io.vertx.ext.shell.system.Process)delegate.createProcess(args.stream().map(elt -> elt.getDelegate()).collect(java.util.stream.Collectors.toList())));
    return ret;
  }

  /**
   * @param completion the completion object
   */
  public void complete(io.vertx.mutiny.ext.shell.cli.Completion completion) { 
    delegate.complete(completion.getDelegate());
  }

  public static  Command newInstance(io.vertx.ext.shell.command.Command arg) {
    return arg != null ? new Command(arg) : null;
  }

}
