package io.vertx.mutiny.ext.shell.command;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import io.vertx.core.Handler;

/**
 * A build for Vert.x Shell command.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.shell.command.CommandBuilder original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.ext.shell.command.CommandBuilder.class)
public class CommandBuilder {

  public static final io.smallrye.mutiny.vertx.TypeArg<CommandBuilder> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new CommandBuilder((io.vertx.ext.shell.command.CommandBuilder) obj),
    CommandBuilder::getDelegate
  );

  private final io.vertx.ext.shell.command.CommandBuilder delegate;
  
  public CommandBuilder(io.vertx.ext.shell.command.CommandBuilder delegate) {
    this.delegate = delegate;
  }

  public CommandBuilder(Object delegate) {
    this.delegate = (io.vertx.ext.shell.command.CommandBuilder)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  CommandBuilder() {
    this.delegate = null;
  }

  public io.vertx.ext.shell.command.CommandBuilder getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    CommandBuilder that = (CommandBuilder) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @param name the command name
   * @return the command
   */
  public static io.vertx.mutiny.ext.shell.command.CommandBuilder command(String name) { 
    io.vertx.mutiny.ext.shell.command.CommandBuilder ret = io.vertx.mutiny.ext.shell.command.CommandBuilder.newInstance((io.vertx.ext.shell.command.CommandBuilder)io.vertx.ext.shell.command.CommandBuilder.command(name));
    return ret;
  }

  /**
   * @param cli the cli to use
   * @return the command
   */
  public static io.vertx.mutiny.ext.shell.command.CommandBuilder command(io.vertx.mutiny.core.cli.CLI cli) { 
    io.vertx.mutiny.ext.shell.command.CommandBuilder ret = io.vertx.mutiny.ext.shell.command.CommandBuilder.newInstance((io.vertx.ext.shell.command.CommandBuilder)io.vertx.ext.shell.command.CommandBuilder.command(cli.getDelegate()));
    return ret;
  }

  /**
   * @param handler the process handler
   * @return this command object
   */
  @Fluent
  private io.vertx.mutiny.ext.shell.command.CommandBuilder __processHandler(Handler<io.vertx.mutiny.ext.shell.command.CommandProcess> handler) { 
    delegate.processHandler(new io.smallrye.mutiny.vertx.DelegatingHandler<>(handler, event -> io.vertx.mutiny.ext.shell.command.CommandProcess.newInstance((io.vertx.ext.shell.command.CommandProcess)event)));
    return this;
  }

  /**
   * @param handler the process handler
   * @return 
   */
  public io.vertx.mutiny.ext.shell.command.CommandBuilder processHandler(java.util.function.Consumer<io.vertx.mutiny.ext.shell.command.CommandProcess> handler) {
    return __processHandler(handler != null ? new io.smallrye.mutiny.vertx.DelegatingConsumerHandler(handler) : null);
  }

  /**
   * @param handler the completion handler
   * @return this command object
   */
  @Fluent
  private io.vertx.mutiny.ext.shell.command.CommandBuilder __completionHandler(Handler<io.vertx.mutiny.ext.shell.cli.Completion> handler) { 
    delegate.completionHandler(new io.smallrye.mutiny.vertx.DelegatingHandler<>(handler, event -> io.vertx.mutiny.ext.shell.cli.Completion.newInstance((io.vertx.ext.shell.cli.Completion)event)));
    return this;
  }

  /**
   * @param handler the completion handler
   * @return 
   */
  public io.vertx.mutiny.ext.shell.command.CommandBuilder completionHandler(java.util.function.Consumer<io.vertx.mutiny.ext.shell.cli.Completion> handler) {
    return __completionHandler(handler != null ? new io.smallrye.mutiny.vertx.DelegatingConsumerHandler(handler) : null);
  }

  /**
   * @param vertx the vertx instance
   * @return the built command
   */
  public io.vertx.mutiny.ext.shell.command.Command build(io.vertx.mutiny.core.Vertx vertx) { 
    io.vertx.mutiny.ext.shell.command.Command ret = io.vertx.mutiny.ext.shell.command.Command.newInstance((io.vertx.ext.shell.command.Command)delegate.build(vertx.getDelegate()));
    return ret;
  }

  public static  CommandBuilder newInstance(io.vertx.ext.shell.command.CommandBuilder arg) {
    return arg != null ? new CommandBuilder(arg) : null;
  }

}
