package io.vertx.mutiny.ext.shell.command;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import java.util.List;
import io.vertx.core.Handler;

/**
 * The command process provides interaction with the process of the command provided by Vert.x Shell.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.shell.command.CommandProcess original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.ext.shell.command.CommandProcess.class)
public class CommandProcess extends io.vertx.mutiny.ext.shell.term.Tty {

  public static final io.smallrye.mutiny.vertx.TypeArg<CommandProcess> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new CommandProcess((io.vertx.ext.shell.command.CommandProcess) obj),
    CommandProcess::getDelegate
  );

  private final io.vertx.ext.shell.command.CommandProcess delegate;
  
  public CommandProcess(io.vertx.ext.shell.command.CommandProcess delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public CommandProcess(Object delegate) {
    super((io.vertx.ext.shell.command.CommandProcess)delegate);
    this.delegate = (io.vertx.ext.shell.command.CommandProcess)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  CommandProcess() {
    super(null);
    this.delegate = null;
  }

  public io.vertx.ext.shell.command.CommandProcess getDelegate() {
    return delegate;
  }

  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.ext.shell.cli.CliToken> TYPE_ARG_0 = new TypeArg<io.vertx.mutiny.ext.shell.cli.CliToken>(o1 -> io.vertx.mutiny.ext.shell.cli.CliToken.newInstance((io.vertx.ext.shell.cli.CliToken)o1), o1 -> o1.getDelegate());
  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    CommandProcess that = (CommandProcess) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @return the current Vert.x instance
   */
  public io.vertx.mutiny.core.Vertx vertx() { 
    io.vertx.mutiny.core.Vertx ret = io.vertx.mutiny.core.Vertx.newInstance((io.vertx.core.Vertx)delegate.vertx());
    return ret;
  }

  /**
   * @return the unparsed arguments tokens
   */
  public List<io.vertx.mutiny.ext.shell.cli.CliToken> argsTokens() { 
    List<io.vertx.mutiny.ext.shell.cli.CliToken> ret = delegate.argsTokens().stream().map(elt -> io.vertx.mutiny.ext.shell.cli.CliToken.newInstance((io.vertx.ext.shell.cli.CliToken)elt)).collect(java.util.stream.Collectors.toList());
    return ret;
  }

  /**
   * @return the actual string arguments of the command
   */
  public List<String> args() { 
    List<String> ret = delegate.args();
    return ret;
  }

  /**
   * @return the command line object or null
   */
  public io.vertx.mutiny.core.cli.CommandLine commandLine() { 
    io.vertx.mutiny.core.cli.CommandLine ret = io.vertx.mutiny.core.cli.CommandLine.newInstance((io.vertx.core.cli.CommandLine)delegate.commandLine());
    return ret;
  }

  /**
   * @return the shell session
   */
  public io.vertx.mutiny.ext.shell.session.Session session() { 
    io.vertx.mutiny.ext.shell.session.Session ret = io.vertx.mutiny.ext.shell.session.Session.newInstance((io.vertx.ext.shell.session.Session)delegate.session());
    return ret;
  }

  /**
   * @return true if the command is running in foreground
   */
  public boolean isForeground() { 
    boolean ret = delegate.isForeground();
    return ret;
  }

  @Fluent
  private io.vertx.mutiny.ext.shell.command.CommandProcess __stdinHandler(Handler<String> handler) { 
    delegate.stdinHandler(handler);
    return this;
  }

  public io.vertx.mutiny.ext.shell.command.CommandProcess stdinHandler(java.util.function.Consumer<String> handler) {
    return __stdinHandler(handler != null ? new io.smallrye.mutiny.vertx.DelegatingConsumerHandler(handler) : null);
  }

  /**
   * @param handler the interrupt handler
   * @return this command
   */
  @Fluent
  private io.vertx.mutiny.ext.shell.command.CommandProcess __interruptHandler(Handler<Void> handler) { 
    delegate.interruptHandler(handler);
    return this;
  }

  /**
   * @param handler the interrupt handler
   * @return 
   */
  public io.vertx.mutiny.ext.shell.command.CommandProcess interruptHandler(java.lang.Runnable handler) {
    return __interruptHandler(ignored -> handler.run()
);
  }

  /**
   * @param handler the interrupt handler
   * @return this command
   */
  @Fluent
  private io.vertx.mutiny.ext.shell.command.CommandProcess __suspendHandler(Handler<Void> handler) { 
    delegate.suspendHandler(handler);
    return this;
  }

  /**
   * @param handler the interrupt handler
   * @return 
   */
  public io.vertx.mutiny.ext.shell.command.CommandProcess suspendHandler(java.lang.Runnable handler) {
    return __suspendHandler(ignored -> handler.run()
);
  }

  /**
   * @param handler the interrupt handler
   * @return this command
   */
  @Fluent
  private io.vertx.mutiny.ext.shell.command.CommandProcess __resumeHandler(Handler<Void> handler) { 
    delegate.resumeHandler(handler);
    return this;
  }

  /**
   * @param handler the interrupt handler
   * @return 
   */
  public io.vertx.mutiny.ext.shell.command.CommandProcess resumeHandler(java.lang.Runnable handler) {
    return __resumeHandler(ignored -> handler.run()
);
  }

  /**
   * @param handler the end handler
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  private io.vertx.mutiny.ext.shell.command.CommandProcess __endHandler(Handler<Void> handler) { 
    delegate.endHandler(handler);
    return this;
  }

  /**
   * @param handler the end handler
   * @return 
   */
  public io.vertx.mutiny.ext.shell.command.CommandProcess endHandler(java.lang.Runnable handler) {
    return __endHandler(ignored -> handler.run()
);
  }

  /**
   * @param data the text
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  public io.vertx.mutiny.ext.shell.command.CommandProcess write(String data) { 
    delegate.write(data);
    return this;
  }

  /**
   * @param handler the background handler
   * @return this command
   */
  @Fluent
  private io.vertx.mutiny.ext.shell.command.CommandProcess __backgroundHandler(Handler<Void> handler) { 
    delegate.backgroundHandler(handler);
    return this;
  }

  /**
   * @param handler the background handler
   * @return 
   */
  public io.vertx.mutiny.ext.shell.command.CommandProcess backgroundHandler(java.lang.Runnable handler) {
    return __backgroundHandler(ignored -> handler.run()
);
  }

  /**
   * @param handler the foreground handler
   * @return this command
   */
  @Fluent
  private io.vertx.mutiny.ext.shell.command.CommandProcess __foregroundHandler(Handler<Void> handler) { 
    delegate.foregroundHandler(handler);
    return this;
  }

  /**
   * @param handler the foreground handler
   * @return 
   */
  public io.vertx.mutiny.ext.shell.command.CommandProcess foregroundHandler(java.lang.Runnable handler) {
    return __foregroundHandler(ignored -> handler.run()
);
  }

  @Fluent
  private io.vertx.mutiny.ext.shell.command.CommandProcess __resizehandler(Handler<Void> handler) { 
    delegate.resizehandler(handler);
    return this;
  }

  public io.vertx.mutiny.ext.shell.command.CommandProcess resizehandler(java.lang.Runnable handler) {
    return __resizehandler(ignored -> handler.run()
);
  }

  /**
   */
  public void end() { 
    delegate.end();
  }

  /**
   * @param status the exit status.
   */
  public void end(int status) { 
    delegate.end(status);
  }

  public static  CommandProcess newInstance(io.vertx.ext.shell.command.CommandProcess arg) {
    return arg != null ? new CommandProcess(arg) : null;
  }

}
