package io.vertx.mutiny.ext.shell.command;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import java.util.List;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Future;

/**
 * A registry that contains the commands known by a shell.<p/>
 *
 * It is a mutable command resolver.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.shell.command.CommandRegistry original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.ext.shell.command.CommandRegistry.class)
public class CommandRegistry extends io.vertx.mutiny.ext.shell.command.CommandResolver {

  public static final io.smallrye.mutiny.vertx.TypeArg<CommandRegistry> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new CommandRegistry((io.vertx.ext.shell.command.CommandRegistry) obj),
    CommandRegistry::getDelegate
  );

  private final io.vertx.ext.shell.command.CommandRegistry delegate;
  
  public CommandRegistry(io.vertx.ext.shell.command.CommandRegistry delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public CommandRegistry(Object delegate) {
    super((io.vertx.ext.shell.command.CommandRegistry)delegate);
    this.delegate = (io.vertx.ext.shell.command.CommandRegistry)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  CommandRegistry() {
    super(null);
    this.delegate = null;
  }

  public io.vertx.ext.shell.command.CommandRegistry getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    CommandRegistry that = (CommandRegistry) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @param vertx the vertx instance
   * @return the shared registry
   */
  public static io.vertx.mutiny.ext.shell.command.CommandRegistry getShared(io.vertx.mutiny.core.Vertx vertx) { 
    io.vertx.mutiny.ext.shell.command.CommandRegistry ret = io.vertx.mutiny.ext.shell.command.CommandRegistry.newInstance((io.vertx.ext.shell.command.CommandRegistry)io.vertx.ext.shell.command.CommandRegistry.getShared(vertx.getDelegate()));
    return ret;
  }

  /**
   * @param vertx the vertx instance
   * @return the created registry
   */
  public static io.vertx.mutiny.ext.shell.command.CommandRegistry create(io.vertx.mutiny.core.Vertx vertx) { 
    io.vertx.mutiny.ext.shell.command.CommandRegistry ret = io.vertx.mutiny.ext.shell.command.CommandRegistry.newInstance((io.vertx.ext.shell.command.CommandRegistry)io.vertx.ext.shell.command.CommandRegistry.create(vertx.getDelegate()));
    return ret;
  }

  /**
   * Register a command
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param command the command to register
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.ext.shell.command.Command> registerCommand(io.vertx.mutiny.ext.shell.command.Command command) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(completionHandler -> {
        delegate.registerCommand(command.getDelegate(), new io.smallrye.mutiny.vertx.DelegatingHandler<>(completionHandler, ar -> ar.map(event -> io.vertx.mutiny.ext.shell.command.Command.newInstance((io.vertx.ext.shell.command.Command)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.shell.command.CommandRegistry#registerCommand(io.vertx.mutiny.ext.shell.command.Command)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param command the command to register
   * @return the Command instance produced by the operation.
   */
  public io.vertx.mutiny.ext.shell.command.Command registerCommandAndAwait(io.vertx.mutiny.ext.shell.command.Command command) { 
    return (io.vertx.mutiny.ext.shell.command.Command) registerCommand(command).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.shell.command.CommandRegistry#registerCommand(io.vertx.mutiny.ext.shell.command.Command)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.shell.command.CommandRegistry#registerCommand(io.vertx.mutiny.ext.shell.command.Command)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.shell.command.CommandRegistry#registerCommand(io.vertx.mutiny.ext.shell.command.Command)} but you don't need to compose it with other operations.
   * @param command the command to register
   * @return the instance of CommandRegistry to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.shell.command.CommandRegistry registerCommandAndForget(io.vertx.mutiny.ext.shell.command.Command command) { 
    registerCommand(command).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Register a list of commands.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param commands the commands to register
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<List<io.vertx.mutiny.ext.shell.command.Command>> registerCommands(List<io.vertx.mutiny.ext.shell.command.Command> commands) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(completionHandler -> {
        delegate.registerCommands(commands.stream().map(elt -> elt.getDelegate()).collect(java.util.stream.Collectors.toList()), new io.smallrye.mutiny.vertx.DelegatingHandler<>(completionHandler, ar -> ar.map(event -> event.stream().map(elt -> io.vertx.mutiny.ext.shell.command.Command.newInstance((io.vertx.ext.shell.command.Command)elt)).collect(java.util.stream.Collectors.toList()))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.shell.command.CommandRegistry#registerCommands(List)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param commands the commands to register
   * @return the List<Command> instance produced by the operation.
   */
  public List<io.vertx.mutiny.ext.shell.command.Command> registerCommandsAndAwait(List<io.vertx.mutiny.ext.shell.command.Command> commands) { 
    return (List<io.vertx.mutiny.ext.shell.command.Command>) registerCommands(commands).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.shell.command.CommandRegistry#registerCommands(List)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.shell.command.CommandRegistry#registerCommands(List)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.shell.command.CommandRegistry#registerCommands(List)} but you don't need to compose it with other operations.
   * @param commands the commands to register
   * @return the instance of CommandRegistry to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.shell.command.CommandRegistry registerCommandsAndForget(List<io.vertx.mutiny.ext.shell.command.Command> commands) { 
    registerCommands(commands).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Unregister a command.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param commandName the command name
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> unregisterCommand(String commandName) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(completionHandler -> {
        delegate.unregisterCommand(commandName, completionHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.shell.command.CommandRegistry#unregisterCommand(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param commandName the command name
   * @return the Void instance produced by the operation.
   */
  public Void unregisterCommandAndAwait(String commandName) { 
    return (Void) unregisterCommand(commandName).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.shell.command.CommandRegistry#unregisterCommand(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.shell.command.CommandRegistry#unregisterCommand(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.shell.command.CommandRegistry#unregisterCommand(String)} but you don't need to compose it with other operations.
   * @param commandName the command name
   * @return the instance of CommandRegistry to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.shell.command.CommandRegistry unregisterCommandAndForget(String commandName) { 
    unregisterCommand(commandName).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  public static  CommandRegistry newInstance(io.vertx.ext.shell.command.CommandRegistry arg) {
    return arg != null ? new CommandRegistry(arg) : null;
  }

}
