package io.vertx.mutiny.ext.shell.command;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import java.util.List;

/**
 * A resolver for commands, so the shell can discover commands.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.shell.command.CommandResolver original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.ext.shell.command.CommandResolver.class)
public class CommandResolver {

  public static final io.smallrye.mutiny.vertx.TypeArg<CommandResolver> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new CommandResolver((io.vertx.ext.shell.command.CommandResolver) obj),
    CommandResolver::getDelegate
  );

  private final io.vertx.ext.shell.command.CommandResolver delegate;
  
  public CommandResolver(io.vertx.ext.shell.command.CommandResolver delegate) {
    this.delegate = delegate;
  }

  public CommandResolver(Object delegate) {
    this.delegate = (io.vertx.ext.shell.command.CommandResolver)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  CommandResolver() {
    this.delegate = null;
  }

  public io.vertx.ext.shell.command.CommandResolver getDelegate() {
    return delegate;
  }

  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.ext.shell.command.Command> TYPE_ARG_0 = new TypeArg<io.vertx.mutiny.ext.shell.command.Command>(o1 -> io.vertx.mutiny.ext.shell.command.Command.newInstance((io.vertx.ext.shell.command.Command)o1), o1 -> o1.getDelegate());
  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    CommandResolver that = (CommandResolver) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @param vertx 
   * @return the base commands of Vert.x Shell.
   */
  public static io.vertx.mutiny.ext.shell.command.CommandResolver baseCommands(io.vertx.mutiny.core.Vertx vertx) { 
    io.vertx.mutiny.ext.shell.command.CommandResolver ret = io.vertx.mutiny.ext.shell.command.CommandResolver.newInstance((io.vertx.ext.shell.command.CommandResolver)io.vertx.ext.shell.command.CommandResolver.baseCommands(vertx.getDelegate()));
    return ret;
  }

  /**
   * @return the current commands
   */
  public List<io.vertx.mutiny.ext.shell.command.Command> commands() { 
    List<io.vertx.mutiny.ext.shell.command.Command> ret = delegate.commands().stream().map(elt -> io.vertx.mutiny.ext.shell.command.Command.newInstance((io.vertx.ext.shell.command.Command)elt)).collect(java.util.stream.Collectors.toList());
    return ret;
  }

  /**
   * @param name the command name
   * @return the commad or null
   */
  public io.vertx.mutiny.ext.shell.command.Command getCommand(String name) { 
    io.vertx.mutiny.ext.shell.command.Command ret = io.vertx.mutiny.ext.shell.command.Command.newInstance((io.vertx.ext.shell.command.Command)delegate.getCommand(name));
    return ret;
  }

  public static  CommandResolver newInstance(io.vertx.ext.shell.command.CommandResolver arg) {
    return arg != null ? new CommandResolver(arg) : null;
  }

}
