package io.vertx.mutiny.ext.shell.session;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;

/**
 * A shell session.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.shell.session.Session original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.ext.shell.session.Session.class)
public class Session {

  public static final io.smallrye.mutiny.vertx.TypeArg<Session> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new Session((io.vertx.ext.shell.session.Session) obj),
    Session::getDelegate
  );

  private final io.vertx.ext.shell.session.Session delegate;
  
  public Session(io.vertx.ext.shell.session.Session delegate) {
    this.delegate = delegate;
  }

  public Session(Object delegate) {
    this.delegate = (io.vertx.ext.shell.session.Session)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  Session() {
    this.delegate = null;
  }

  public io.vertx.ext.shell.session.Session getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    Session that = (Session) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @return the created session
   */
  public static io.vertx.mutiny.ext.shell.session.Session create() { 
    io.vertx.mutiny.ext.shell.session.Session ret = io.vertx.mutiny.ext.shell.session.Session.newInstance((io.vertx.ext.shell.session.Session)io.vertx.ext.shell.session.Session.create());
    return ret;
  }

  /**
   * @param key the key for the data
   * @param obj the data
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  public io.vertx.mutiny.ext.shell.session.Session put(String key, java.lang.Object obj) { 
    delegate.put(key, obj);
    return this;
  }

  /**
   * @param key the key of the data
   * @return the data
   */
  public <T> T get(String key) { 
    T ret = (T) delegate.get(key);
    return ret;
  }

  /**
   * @param key the key of the data
   * @return the data that was there or null if none there
   */
  public <T> T remove(String key) { 
    T ret = (T) delegate.remove(key);
    return ret;
  }

  public static  Session newInstance(io.vertx.ext.shell.session.Session arg) {
    return arg != null ? new Session(arg) : null;
  }

}
