package io.vertx.mutiny.ext.shell.system;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import io.vertx.ext.shell.system.ExecStatus;
import io.vertx.core.Handler;

/**
 * A job executed in a {@link io.vertx.mutiny.ext.shell.system.JobController}, grouping one or several process.<p/>
 *
 * The job life cycle can be controlled with the {@link io.vertx.mutiny.ext.shell.system.Job#run}, {@link io.vertx.mutiny.ext.shell.system.Job#resume} and {@link io.vertx.mutiny.ext.shell.system.Job#suspend} and {@link io.vertx.mutiny.ext.shell.system.Job#interrupt}
 * methods.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.shell.system.Job original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.ext.shell.system.Job.class)
public class Job {

  public static final io.smallrye.mutiny.vertx.TypeArg<Job> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new Job((io.vertx.ext.shell.system.Job) obj),
    Job::getDelegate
  );

  private final io.vertx.ext.shell.system.Job delegate;
  
  public Job(io.vertx.ext.shell.system.Job delegate) {
    this.delegate = delegate;
  }

  public Job(Object delegate) {
    this.delegate = (io.vertx.ext.shell.system.Job)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  Job() {
    this.delegate = null;
  }

  public io.vertx.ext.shell.system.Job getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    Job that = (Job) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @return the job id
   */
  public int id() { 
    int ret = delegate.id();
    return ret;
  }

  /**
   * @return the job exec status
   */
  public io.vertx.ext.shell.system.ExecStatus status() { 
    io.vertx.ext.shell.system.ExecStatus ret = delegate.status();
    return ret;
  }

  /**
   * @return when the job was last stopped
   */
  public long lastStopped() { 
    long ret = delegate.lastStopped();
    return ret;
  }

  /**
   * @return the execution line of the job, i.e the shell command line that launched this job
   */
  public String line() { 
    String ret = delegate.line();
    return ret;
  }

  /**
   * @param tty the tty to use
   * @return this object
   */
  @Fluent
  public io.vertx.mutiny.ext.shell.system.Job setTty(io.vertx.mutiny.ext.shell.term.Tty tty) { 
    delegate.setTty(tty.getDelegate());
    return this;
  }

  /**
   * @param session the session to use
   * @return this object
   */
  @Fluent
  public io.vertx.mutiny.ext.shell.system.Job setSession(io.vertx.mutiny.ext.shell.session.Session session) { 
    delegate.setSession(session.getDelegate());
    return this;
  }

  /**
   * @param handler the terminate handler
   * @return this object
   */
  @Fluent
  private io.vertx.mutiny.ext.shell.system.Job __statusUpdateHandler(Handler<io.vertx.ext.shell.system.ExecStatus> handler) { 
    delegate.statusUpdateHandler(handler);
    return this;
  }

  /**
   * @param handler the terminate handler
   * @return 
   */
  public io.vertx.mutiny.ext.shell.system.Job statusUpdateHandler(java.util.function.Consumer<io.vertx.ext.shell.system.ExecStatus> handler) {
    return __statusUpdateHandler(handler != null ? new io.smallrye.mutiny.vertx.DelegatingConsumerHandler(handler) : null);
  }

  /**
   * @return this object
   */
  @Fluent
  public io.vertx.mutiny.ext.shell.system.Job run() { 
    delegate.run();
    return this;
  }

  /**
   * @return true if the job is actually interrupted
   */
  public boolean interrupt() { 
    boolean ret = delegate.interrupt();
    return ret;
  }

  /**
   * @return 
   */
  public io.vertx.mutiny.ext.shell.system.Job resume() { 
    io.vertx.mutiny.ext.shell.system.Job ret = io.vertx.mutiny.ext.shell.system.Job.newInstance((io.vertx.ext.shell.system.Job)delegate.resume());
    return ret;
  }

  /**
   * @return this object
   */
  @Fluent
  public io.vertx.mutiny.ext.shell.system.Job toBackground() { 
    delegate.toBackground();
    return this;
  }

  /**
   * @return this object
   */
  @Fluent
  public io.vertx.mutiny.ext.shell.system.Job toForeground() { 
    delegate.toForeground();
    return this;
  }

  /**
   * @param foreground true when the job is resumed in foreground
   * @return the instance of Job to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.shell.system.Job resume(boolean foreground) { 
    delegate.resume(foreground);
    return this;
  }

  /**
   * @return this object
   */
  @Fluent
  public io.vertx.mutiny.ext.shell.system.Job suspend() { 
    delegate.suspend();
    return this;
  }

  /**
   */
  public void terminate() { 
    delegate.terminate();
  }

  /**
   * @return the first process in the job
   */
  public io.vertx.mutiny.ext.shell.system.Process process() { 
    if (cached_0 != null) {
      return cached_0;
    }
    io.vertx.mutiny.ext.shell.system.Process ret = io.vertx.mutiny.ext.shell.system.Process.newInstance((io.vertx.ext.shell.system.Process)delegate.process());
    cached_0 = ret;
    return ret;
  }

  private io.vertx.mutiny.ext.shell.system.Process cached_0;
  public static  Job newInstance(io.vertx.ext.shell.system.Job arg) {
    return arg != null ? new Job(arg) : null;
  }

}
