package io.vertx.mutiny.ext.shell.system;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import io.vertx.ext.shell.system.ExecStatus;
import io.vertx.core.Handler;

/**
 * A process managed by the shell.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.shell.system.Process original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.ext.shell.system.Process.class)
public class Process {

  public static final io.smallrye.mutiny.vertx.TypeArg<Process> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new Process((io.vertx.ext.shell.system.Process) obj),
    Process::getDelegate
  );

  private final io.vertx.ext.shell.system.Process delegate;
  
  public Process(io.vertx.ext.shell.system.Process delegate) {
    this.delegate = delegate;
  }

  public Process(Object delegate) {
    this.delegate = (io.vertx.ext.shell.system.Process)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  Process() {
    this.delegate = null;
  }

  public io.vertx.ext.shell.system.Process getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    Process that = (Process) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @return the current process status
   */
  public io.vertx.ext.shell.system.ExecStatus status() { 
    io.vertx.ext.shell.system.ExecStatus ret = delegate.status();
    return ret;
  }

  /**
   * @return the process exit code when the status is  otherwise <code>null</code>
   */
  public Integer exitCode() { 
    Integer ret = delegate.exitCode();
    return ret;
  }

  /**
   * @param tty the process tty
   * @return this object
   */
  @Fluent
  public io.vertx.mutiny.ext.shell.system.Process setTty(io.vertx.mutiny.ext.shell.term.Tty tty) { 
    delegate.setTty(tty.getDelegate());
    return this;
  }

  /**
   * @return the process tty
   */
  public io.vertx.mutiny.ext.shell.term.Tty getTty() { 
    if (cached_0 != null) {
      return cached_0;
    }
    io.vertx.mutiny.ext.shell.term.Tty ret = io.vertx.mutiny.ext.shell.term.Tty.newInstance((io.vertx.ext.shell.term.Tty)delegate.getTty());
    cached_0 = ret;
    return ret;
  }

  /**
   * @param session the process session
   * @return this object
   */
  @Fluent
  public io.vertx.mutiny.ext.shell.system.Process setSession(io.vertx.mutiny.ext.shell.session.Session session) { 
    delegate.setSession(session.getDelegate());
    return this;
  }

  /**
   * @return the process session
   */
  public io.vertx.mutiny.ext.shell.session.Session getSession() { 
    if (cached_1 != null) {
      return cached_1;
    }
    io.vertx.mutiny.ext.shell.session.Session ret = io.vertx.mutiny.ext.shell.session.Session.newInstance((io.vertx.ext.shell.session.Session)delegate.getSession());
    cached_1 = ret;
    return ret;
  }

  /**
   * @param handler the handler called when the process terminates.
   * @return this object
   */
  @Fluent
  private io.vertx.mutiny.ext.shell.system.Process __terminatedHandler(Handler<Integer> handler) { 
    delegate.terminatedHandler(handler);
    return this;
  }

  /**
   * @param handler the handler called when the process terminates.
   * @return 
   */
  public io.vertx.mutiny.ext.shell.system.Process terminatedHandler(java.util.function.Consumer<Integer> handler) {
    return __terminatedHandler(handler != null ? new io.smallrye.mutiny.vertx.DelegatingConsumerHandler(handler) : null);
  }

  /**
   */
  public void run() { 
    delegate.run();
  }

  /**
   * @param foregraound 
   */
  public void run(boolean foregraound) { 
    delegate.run(foregraound);
  }

  /**
   * @return true if the process caught the signal
   */
  public boolean interrupt() { 
    boolean ret = delegate.interrupt();
    return ret;
  }

  /**
   * @param completionHandler handler called after interrupt callback
   * @return true if the process caught the signal
   */
  private boolean __interrupt(Handler<Void> completionHandler) { 
    boolean ret = delegate.interrupt(completionHandler);
    return ret;
  }

  /**
   * @param completionHandler handler called after interrupt callback
   * @return 
   */
  public boolean interrupt(java.lang.Runnable completionHandler) {
    return __interrupt(ignored -> completionHandler.run()
);
  }

  /**
   */
  public void resume() { 
    delegate.resume();
  }

  /**
   * @param foreground 
   */
  public void resume(boolean foreground) { 
    delegate.resume(foreground);
  }

  /**
   * @param completionHandler handler called after resume callback
   */
  private void __resume(Handler<Void> completionHandler) { 
    delegate.resume(completionHandler);
  }

  /**
   * @param completionHandler handler called after resume callback
   */
  public void resume(java.lang.Runnable completionHandler) {
    __resume(ignored -> completionHandler.run()
);
  }

  /**
   * @param foreground 
   * @param completionHandler handler called after resume callback
   */
  private void __resume(boolean foreground, Handler<Void> completionHandler) { 
    delegate.resume(foreground, completionHandler);
  }

  /**
   * @param foreground 
   * @param completionHandler handler called after resume callback
   */
  public void resume(boolean foreground, java.lang.Runnable completionHandler) {
    __resume(foreground, ignored -> completionHandler.run()
);
  }

  /**
   */
  public void suspend() { 
    delegate.suspend();
  }

  /**
   * @param completionHandler handler called after suspend callback
   */
  private void __suspend(Handler<Void> completionHandler) { 
    delegate.suspend(completionHandler);
  }

  /**
   * @param completionHandler handler called after suspend callback
   */
  public void suspend(java.lang.Runnable completionHandler) {
    __suspend(ignored -> completionHandler.run()
);
  }

  /**
   */
  public void terminate() { 
    delegate.terminate();
  }

  /**
   * @param completionHandler handler called after end callback
   */
  private void __terminate(Handler<Void> completionHandler) { 
    delegate.terminate(completionHandler);
  }

  /**
   * @param completionHandler handler called after end callback
   */
  public void terminate(java.lang.Runnable completionHandler) {
    __terminate(ignored -> completionHandler.run()
);
  }

  /**
   */
  public void toBackground() { 
    delegate.toBackground();
  }

  /**
   * @param completionHandler handler called after background callback
   */
  private void __toBackground(Handler<Void> completionHandler) { 
    delegate.toBackground(completionHandler);
  }

  /**
   * @param completionHandler handler called after background callback
   */
  public void toBackground(java.lang.Runnable completionHandler) {
    __toBackground(ignored -> completionHandler.run()
);
  }

  /**
   */
  public void toForeground() { 
    delegate.toForeground();
  }

  /**
   * @param completionHandler handler called after foreground callback
   */
  private void __toForeground(Handler<Void> completionHandler) { 
    delegate.toForeground(completionHandler);
  }

  /**
   * @param completionHandler handler called after foreground callback
   */
  public void toForeground(java.lang.Runnable completionHandler) {
    __toForeground(ignored -> completionHandler.run()
);
  }

  private io.vertx.mutiny.ext.shell.term.Tty cached_0;
  private io.vertx.mutiny.ext.shell.session.Session cached_1;
  public static  Process newInstance(io.vertx.ext.shell.system.Process arg) {
    return arg != null ? new Process(arg) : null;
  }

}
