package io.vertx.mutiny.ext.shell.term;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import io.vertx.core.Handler;

/**
 * A pseudo terminal used for controlling a {@link io.vertx.mutiny.ext.shell.term.Tty}. This interface acts as a pseudo
 * terminal master, {@link io.vertx.mutiny.ext.shell.term.Pty#slave} returns the assocated slave pseudo terminal.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.shell.term.Pty original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.ext.shell.term.Pty.class)
public class Pty {

  public static final io.smallrye.mutiny.vertx.TypeArg<Pty> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new Pty((io.vertx.ext.shell.term.Pty) obj),
    Pty::getDelegate
  );

  private final io.vertx.ext.shell.term.Pty delegate;
  
  public Pty(io.vertx.ext.shell.term.Pty delegate) {
    this.delegate = delegate;
  }

  public Pty(Object delegate) {
    this.delegate = (io.vertx.ext.shell.term.Pty)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  Pty() {
    this.delegate = null;
  }

  public io.vertx.ext.shell.term.Pty getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    Pty that = (Pty) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @return 
   */
  public static io.vertx.mutiny.ext.shell.term.Pty create() { 
    io.vertx.mutiny.ext.shell.term.Pty ret = io.vertx.mutiny.ext.shell.term.Pty.newInstance((io.vertx.ext.shell.term.Pty)io.vertx.ext.shell.term.Pty.create());
    return ret;
  }

  /**
   * @param terminalType the terminal type, for instance 
   * @return the created pseudo terminal
   */
  public static io.vertx.mutiny.ext.shell.term.Pty create(String terminalType) { 
    io.vertx.mutiny.ext.shell.term.Pty ret = io.vertx.mutiny.ext.shell.term.Pty.newInstance((io.vertx.ext.shell.term.Pty)io.vertx.ext.shell.term.Pty.create(terminalType));
    return ret;
  }

  /**
   * @param handler the standard output
   * @return this current object
   */
  @Fluent
  private io.vertx.mutiny.ext.shell.term.Pty __stdoutHandler(Handler<String> handler) { 
    delegate.stdoutHandler(handler);
    return this;
  }

  /**
   * @param handler the standard output
   * @return 
   */
  public io.vertx.mutiny.ext.shell.term.Pty stdoutHandler(java.util.function.Consumer<String> handler) {
    return __stdoutHandler(handler != null ? new io.smallrye.mutiny.vertx.DelegatingConsumerHandler(handler) : null);
  }

  /**
   * @param data the data to write
   * @return this current object
   */
  @Fluent
  public io.vertx.mutiny.ext.shell.term.Pty write(String data) { 
    delegate.write(data);
    return this;
  }

  /**
   * @param width 
   * @param height 
   * @return this current object
   */
  @Fluent
  public io.vertx.mutiny.ext.shell.term.Pty setSize(int width, int height) { 
    delegate.setSize(width, height);
    return this;
  }

  /**
   * @return the pseudo terminal slave
   */
  public io.vertx.mutiny.ext.shell.term.Tty slave() { 
    io.vertx.mutiny.ext.shell.term.Tty ret = io.vertx.mutiny.ext.shell.term.Tty.newInstance((io.vertx.ext.shell.term.Tty)delegate.slave());
    return ret;
  }

  public static  Pty newInstance(io.vertx.ext.shell.term.Pty arg) {
    return arg != null ? new Pty(arg) : null;
  }

}
