package io.vertx.mutiny.ext.shell.term;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import io.vertx.core.Handler;

/**
 * The terminal.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.shell.term.Term original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.ext.shell.term.Term.class)
public class Term extends io.vertx.mutiny.ext.shell.term.Tty {

  public static final io.smallrye.mutiny.vertx.TypeArg<Term> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new Term((io.vertx.ext.shell.term.Term) obj),
    Term::getDelegate
  );

  private final io.vertx.ext.shell.term.Term delegate;
  
  public Term(io.vertx.ext.shell.term.Term delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public Term(Object delegate) {
    super((io.vertx.ext.shell.term.Term)delegate);
    this.delegate = (io.vertx.ext.shell.term.Term)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  Term() {
    super(null);
    this.delegate = null;
  }

  public io.vertx.ext.shell.term.Term getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    Term that = (Term) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  @Fluent
  private io.vertx.mutiny.ext.shell.term.Term __resizehandler(Handler<Void> handler) { 
    delegate.resizehandler(handler);
    return this;
  }

  public io.vertx.mutiny.ext.shell.term.Term resizehandler(java.lang.Runnable handler) {
    return __resizehandler(ignored -> handler.run()
);
  }

  @Fluent
  private io.vertx.mutiny.ext.shell.term.Term __stdinHandler(Handler<String> handler) { 
    delegate.stdinHandler(handler);
    return this;
  }

  public io.vertx.mutiny.ext.shell.term.Term stdinHandler(java.util.function.Consumer<String> handler) {
    return __stdinHandler(handler != null ? new io.smallrye.mutiny.vertx.DelegatingConsumerHandler(handler) : null);
  }

  @Fluent
  public io.vertx.mutiny.ext.shell.term.Term write(String data) { 
    delegate.write(data);
    return this;
  }

  /**
   * @return the last time this term received input
   */
  public long lastAccessedTime() { 
    long ret = delegate.lastAccessedTime();
    return ret;
  }

  /**
   * @param text the text to echo
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  public io.vertx.mutiny.ext.shell.term.Term echo(String text) { 
    delegate.echo(text);
    return this;
  }

  /**
   * @param session the session to set
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.mutiny.ext.shell.term.Term setSession(io.vertx.mutiny.ext.shell.session.Session session) { 
    io.vertx.mutiny.ext.shell.term.Term ret = io.vertx.mutiny.ext.shell.term.Term.newInstance((io.vertx.ext.shell.term.Term)delegate.setSession(session.getDelegate()));
    return ret;
  }

  /**
   * @param handler the interrupt handler
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  public io.vertx.mutiny.ext.shell.term.Term interruptHandler(io.vertx.mutiny.ext.shell.term.SignalHandler handler) { 
    delegate.interruptHandler(handler.getDelegate());
    return this;
  }

  /**
   * @param handler the suspend handler
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  public io.vertx.mutiny.ext.shell.term.Term suspendHandler(io.vertx.mutiny.ext.shell.term.SignalHandler handler) { 
    delegate.suspendHandler(handler.getDelegate());
    return this;
  }

  /**
   * @param prompt the displayed prompt
   * @param lineHandler the line handler called with the line
   */
  private void __readline(String prompt, Handler<String> lineHandler) { 
    delegate.readline(prompt, lineHandler);
  }

  /**
   * @param prompt the displayed prompt
   * @param lineHandler the line handler called with the line
   */
  public void readline(String prompt, java.util.function.Consumer<String> lineHandler) {
    __readline(prompt, lineHandler != null ? new io.smallrye.mutiny.vertx.DelegatingConsumerHandler(lineHandler) : null);
  }

  /**
   * @param prompt the displayed prompt
   * @param lineHandler the line handler called with the line
   * @param completionHandler the completion handler
   */
  private void __readline(String prompt, Handler<String> lineHandler, Handler<io.vertx.mutiny.ext.shell.cli.Completion> completionHandler) { 
    delegate.readline(prompt, lineHandler, new io.smallrye.mutiny.vertx.DelegatingHandler<>(completionHandler, event -> io.vertx.mutiny.ext.shell.cli.Completion.newInstance((io.vertx.ext.shell.cli.Completion)event)));
  }

  /**
   * @param prompt the displayed prompt
   * @param lineHandler the line handler called with the line
   * @param completionHandler the completion handler
   */
  public void readline(String prompt, Handler<String> lineHandler, java.util.function.Consumer<io.vertx.mutiny.ext.shell.cli.Completion> completionHandler) {
    __readline(prompt, lineHandler, completionHandler != null ? new io.smallrye.mutiny.vertx.DelegatingConsumerHandler(completionHandler) : null);
  }

  /**
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  private io.vertx.mutiny.ext.shell.term.Term __closeHandler(Handler<Void> handler) { 
    delegate.closeHandler(handler);
    return this;
  }

  /**
   * @param handler the handler
   * @return 
   */
  public io.vertx.mutiny.ext.shell.term.Term closeHandler(java.lang.Runnable handler) {
    return __closeHandler(ignored -> handler.run()
);
  }

  /**
   */
  public void close() { 
    delegate.close();
  }

  public static  Term newInstance(io.vertx.ext.shell.term.Term arg) {
    return arg != null ? new Term(arg) : null;
  }

}
