package io.vertx.mutiny.ext.shell.term;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import io.vertx.ext.shell.term.TelnetTermOptions;
import io.vertx.ext.shell.term.HttpTermOptions;
import io.vertx.core.Future;
import io.vertx.ext.shell.term.SSHTermOptions;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

/**
 * A server for terminal based applications.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.shell.term.TermServer original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.ext.shell.term.TermServer.class)
public class TermServer {

  public static final io.smallrye.mutiny.vertx.TypeArg<TermServer> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new TermServer((io.vertx.ext.shell.term.TermServer) obj),
    TermServer::getDelegate
  );

  private final io.vertx.ext.shell.term.TermServer delegate;
  
  public TermServer(io.vertx.ext.shell.term.TermServer delegate) {
    this.delegate = delegate;
  }

  public TermServer(Object delegate) {
    this.delegate = (io.vertx.ext.shell.term.TermServer)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  TermServer() {
    this.delegate = null;
  }

  public io.vertx.ext.shell.term.TermServer getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    TermServer that = (TermServer) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @param vertx the vertx instance
   * @return the term server
   */
  public static io.vertx.mutiny.ext.shell.term.TermServer createSSHTermServer(io.vertx.mutiny.core.Vertx vertx) { 
    io.vertx.mutiny.ext.shell.term.TermServer ret = io.vertx.mutiny.ext.shell.term.TermServer.newInstance((io.vertx.ext.shell.term.TermServer)io.vertx.ext.shell.term.TermServer.createSSHTermServer(vertx.getDelegate()));
    return ret;
  }

  /**
   * @param vertx the vertx instance
   * @param options the ssh options
   * @return the term server
   */
  public static io.vertx.mutiny.ext.shell.term.TermServer createSSHTermServer(io.vertx.mutiny.core.Vertx vertx, io.vertx.ext.shell.term.SSHTermOptions options) { 
    io.vertx.mutiny.ext.shell.term.TermServer ret = io.vertx.mutiny.ext.shell.term.TermServer.newInstance((io.vertx.ext.shell.term.TermServer)io.vertx.ext.shell.term.TermServer.createSSHTermServer(vertx.getDelegate(), options));
    return ret;
  }

  /**
   * @param vertx the vertx instance
   * @return the term server
   */
  public static io.vertx.mutiny.ext.shell.term.TermServer createTelnetTermServer(io.vertx.mutiny.core.Vertx vertx) { 
    io.vertx.mutiny.ext.shell.term.TermServer ret = io.vertx.mutiny.ext.shell.term.TermServer.newInstance((io.vertx.ext.shell.term.TermServer)io.vertx.ext.shell.term.TermServer.createTelnetTermServer(vertx.getDelegate()));
    return ret;
  }

  /**
   * @param vertx the vertx instance
   * @param options the term options
   * @return the term server
   */
  public static io.vertx.mutiny.ext.shell.term.TermServer createTelnetTermServer(io.vertx.mutiny.core.Vertx vertx, io.vertx.ext.shell.term.TelnetTermOptions options) { 
    io.vertx.mutiny.ext.shell.term.TermServer ret = io.vertx.mutiny.ext.shell.term.TermServer.newInstance((io.vertx.ext.shell.term.TermServer)io.vertx.ext.shell.term.TermServer.createTelnetTermServer(vertx.getDelegate(), options));
    return ret;
  }

  /**
   * @param vertx the vertx instance
   * @return the term server
   */
  public static io.vertx.mutiny.ext.shell.term.TermServer createHttpTermServer(io.vertx.mutiny.core.Vertx vertx) { 
    io.vertx.mutiny.ext.shell.term.TermServer ret = io.vertx.mutiny.ext.shell.term.TermServer.newInstance((io.vertx.ext.shell.term.TermServer)io.vertx.ext.shell.term.TermServer.createHttpTermServer(vertx.getDelegate()));
    return ret;
  }

  /**
   * @param vertx the vertx instance
   * @param options the term options
   * @return the term server
   */
  public static io.vertx.mutiny.ext.shell.term.TermServer createHttpTermServer(io.vertx.mutiny.core.Vertx vertx, io.vertx.ext.shell.term.HttpTermOptions options) { 
    io.vertx.mutiny.ext.shell.term.TermServer ret = io.vertx.mutiny.ext.shell.term.TermServer.newInstance((io.vertx.ext.shell.term.TermServer)io.vertx.ext.shell.term.TermServer.createHttpTermServer(vertx.getDelegate(), options));
    return ret;
  }

  /**
   * @param vertx the vertx instance
   * @param router the router
   * @return the term server
   */
  public static io.vertx.mutiny.ext.shell.term.TermServer createHttpTermServer(io.vertx.mutiny.core.Vertx vertx, io.vertx.mutiny.ext.web.Router router) { 
    io.vertx.mutiny.ext.shell.term.TermServer ret = io.vertx.mutiny.ext.shell.term.TermServer.newInstance((io.vertx.ext.shell.term.TermServer)io.vertx.ext.shell.term.TermServer.createHttpTermServer(vertx.getDelegate(), router.getDelegate()));
    return ret;
  }

  /**
   * @param vertx the vertx instance
   * @param router the router
   * @param options the term options
   * @return the term server
   */
  public static io.vertx.mutiny.ext.shell.term.TermServer createHttpTermServer(io.vertx.mutiny.core.Vertx vertx, io.vertx.mutiny.ext.web.Router router, io.vertx.ext.shell.term.HttpTermOptions options) { 
    io.vertx.mutiny.ext.shell.term.TermServer ret = io.vertx.mutiny.ext.shell.term.TermServer.newInstance((io.vertx.ext.shell.term.TermServer)io.vertx.ext.shell.term.TermServer.createHttpTermServer(vertx.getDelegate(), router.getDelegate(), options));
    return ret;
  }

  /**
   * @param handler the term handler
   * @return this object
   */
  @Fluent
  private io.vertx.mutiny.ext.shell.term.TermServer __termHandler(Handler<io.vertx.mutiny.ext.shell.term.Term> handler) { 
    delegate.termHandler(new io.smallrye.mutiny.vertx.DelegatingHandler<>(handler, event -> io.vertx.mutiny.ext.shell.term.Term.newInstance((io.vertx.ext.shell.term.Term)event)));
    return this;
  }

  /**
   * @param handler the term handler
   * @return 
   */
  public io.vertx.mutiny.ext.shell.term.TermServer termHandler(java.util.function.Consumer<io.vertx.mutiny.ext.shell.term.Term> handler) {
    return __termHandler(handler != null ? new io.smallrye.mutiny.vertx.DelegatingConsumerHandler(handler) : null);
  }

  /**
   * @param provider the auth to use
   * @return this object
   * @deprecated See {@link #authenticationProvider(AuthenticationProvider)} Set an auth provider to use, any provider configured in options will override this provider. This should be used when a custom auth provider should be used.   */
  @Deprecated
  @Fluent
  public io.vertx.mutiny.ext.shell.term.TermServer authProvider(io.vertx.mutiny.ext.auth.AuthProvider provider) { 
    delegate.authProvider(provider.getDelegate());
    return this;
  }

  /**
   * @param provider the auth to use
   * @return this object
   */
  @Fluent
  public io.vertx.mutiny.ext.shell.term.TermServer authenticationProvider(io.vertx.mutiny.ext.auth.authentication.AuthenticationProvider provider) { 
    delegate.authenticationProvider(provider.getDelegate());
    return this;
  }

  /**
   * Bind the term server, the {@link io.vertx.mutiny.ext.shell.term.TermServer#termHandler} must be set before.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> listen() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(listenHandler -> {
        delegate.listen(listenHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.shell.term.TermServer#listen}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the Void instance produced by the operation.
   */
  public Void listenAndAwait() { 
    return (Void) listen().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.shell.term.TermServer#listen} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.shell.term.TermServer#listen}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.shell.term.TermServer#listen} but you don't need to compose it with other operations.
   * @return the instance of TermServer to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.shell.term.TermServer listenAndForget() { 
    listen().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * @return the actual port the server is listening on.
   */
  public int actualPort() { 
    int ret = delegate.actualPort();
    return ret;
  }

  /**
   * Like {@link io.vertx.mutiny.ext.shell.term.TermServer#close} but supplying a handler that will be notified when close is complete.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> close() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(completionHandler -> {
        delegate.close(completionHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.shell.term.TermServer#close}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the Void instance produced by the operation.
   */
  public Void closeAndAwait() { 
    return (Void) close().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.shell.term.TermServer#close} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.shell.term.TermServer#close}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.shell.term.TermServer#close} but you don't need to compose it with other operations.
   */
  public void closeAndForget() { 
    close().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  public static  TermServer newInstance(io.vertx.ext.shell.term.TermServer arg) {
    return arg != null ? new TermServer(arg) : null;
  }

}
