package io.vertx.mutiny.ext.shell.term;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import io.vertx.core.Handler;

/**
 * Provide interactions with the Shell TTY.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.shell.term.Tty original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.ext.shell.term.Tty.class)
public class Tty {

  public static final io.smallrye.mutiny.vertx.TypeArg<Tty> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new Tty((io.vertx.ext.shell.term.Tty) obj),
    Tty::getDelegate
  );

  private final io.vertx.ext.shell.term.Tty delegate;
  
  public Tty(io.vertx.ext.shell.term.Tty delegate) {
    this.delegate = delegate;
  }

  public Tty(Object delegate) {
    this.delegate = (io.vertx.ext.shell.term.Tty)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  Tty() {
    this.delegate = null;
  }

  public io.vertx.ext.shell.term.Tty getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    Tty that = (Tty) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @return the declared tty type, for instance , , etc... it can be null when the tty does not have declared its type.
   */
  public String type() { 
    String ret = delegate.type();
    return ret;
  }

  /**
   * @return the current width, i.e the number of rows or  if unknown
   */
  public int width() { 
    int ret = delegate.width();
    return ret;
  }

  /**
   * @return the current height, i.e the number of columns or  if unknown
   */
  public int height() { 
    int ret = delegate.height();
    return ret;
  }

  /**
   * @param handler the standard input
   * @return this object
   */
  @Fluent
  private io.vertx.mutiny.ext.shell.term.Tty __stdinHandler(Handler<String> handler) { 
    delegate.stdinHandler(handler);
    return this;
  }

  /**
   * @param handler the standard input
   * @return 
   */
  public io.vertx.mutiny.ext.shell.term.Tty stdinHandler(java.util.function.Consumer<String> handler) {
    return __stdinHandler(handler != null ? new io.smallrye.mutiny.vertx.DelegatingConsumerHandler(handler) : null);
  }

  /**
   * @param data the data to write
   * @return this object
   */
  @Fluent
  public io.vertx.mutiny.ext.shell.term.Tty write(String data) { 
    delegate.write(data);
    return this;
  }

  /**
   * @param handler the resize handler
   * @return this object
   */
  @Fluent
  private io.vertx.mutiny.ext.shell.term.Tty __resizehandler(Handler<Void> handler) { 
    delegate.resizehandler(handler);
    return this;
  }

  /**
   * @param handler the resize handler
   * @return 
   */
  public io.vertx.mutiny.ext.shell.term.Tty resizehandler(java.lang.Runnable handler) {
    return __resizehandler(ignored -> handler.run()
);
  }

  public static  Tty newInstance(io.vertx.ext.shell.term.Tty arg) {
    return arg != null ? new Tty(arg) : null;
  }

}
