package io.vertx.mutiny.sqlclient.templates;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Publisher;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.vertx.core.Future;
import java.util.List;
import java.util.Map;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

/**
 * An SQL template.
 *
 * <p>SQL templates are useful for interacting with a relational database.
 *
 * <p>SQL templates execute queries using named instead of positional parameters. Query execution is parameterized
 * by a map of string to objects instead of a {@link io.vertx.mutiny.sqlclient.Tuple}. The default source of parameters is a
 * simple map, a user defined mapping can be used instead given it maps the source to such a map.
 *
 * <p>SQL template default results are , a user defined mapping can be used instead, mapping the
 * result set  to a  of the mapped type.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.sqlclient.templates.SqlTemplate original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.sqlclient.templates.SqlTemplate.class)
public class SqlTemplate<I,R> {

  public static final io.smallrye.mutiny.vertx.TypeArg<SqlTemplate> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new SqlTemplate((io.vertx.sqlclient.templates.SqlTemplate) obj),
    SqlTemplate::getDelegate
  );

  private final io.vertx.sqlclient.templates.SqlTemplate<I,R> delegate;
  public final io.smallrye.mutiny.vertx.TypeArg<I> __typeArg_0;
  public final io.smallrye.mutiny.vertx.TypeArg<R> __typeArg_1;
  
  public SqlTemplate(io.vertx.sqlclient.templates.SqlTemplate delegate) {
    this.delegate = delegate;
    this.__typeArg_0 = io.smallrye.mutiny.vertx.TypeArg.unknown();    this.__typeArg_1 = io.smallrye.mutiny.vertx.TypeArg.unknown();  }

  public SqlTemplate(Object delegate, TypeArg<I> typeArg_0, TypeArg<R> typeArg_1) {
    this.delegate = (io.vertx.sqlclient.templates.SqlTemplate)delegate;
    this.__typeArg_0 = typeArg_0;
    this.__typeArg_1 = typeArg_1;
  }

  public SqlTemplate(io.vertx.sqlclient.templates.SqlTemplate delegate, io.smallrye.mutiny.vertx.TypeArg<I> typeArg_0, io.smallrye.mutiny.vertx.TypeArg<R> typeArg_1) {
    this.delegate = delegate;
    this.__typeArg_0 = typeArg_0;
    this.__typeArg_1 = typeArg_1;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  SqlTemplate() {
    this.delegate = null;
    this.__typeArg_0 = io.smallrye.mutiny.vertx.TypeArg.unknown();    this.__typeArg_1 = io.smallrye.mutiny.vertx.TypeArg.unknown();  }

  public io.vertx.sqlclient.templates.SqlTemplate getDelegate() {
    return delegate;
  }

  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.sqlclient.SqlResult<java.lang.Void>> TYPE_ARG_1 = new TypeArg<io.vertx.mutiny.sqlclient.SqlResult<java.lang.Void>>(o1 -> io.vertx.mutiny.sqlclient.SqlResult.newInstance((io.vertx.sqlclient.SqlResult)o1, TypeArg.unknown()), o1 -> o1.getDelegate());
  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.sqlclient.RowSet<io.vertx.mutiny.sqlclient.Row>> TYPE_ARG_0 = new TypeArg<io.vertx.mutiny.sqlclient.RowSet<io.vertx.mutiny.sqlclient.Row>>(o1 -> io.vertx.mutiny.sqlclient.RowSet.newInstance((io.vertx.sqlclient.RowSet)o1, new TypeArg<io.vertx.mutiny.sqlclient.Row>(o2 -> io.vertx.mutiny.sqlclient.Row.newInstance((io.vertx.sqlclient.Row)o2), o2 -> o2.getDelegate())), o1 -> o1.getDelegate());
  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SqlTemplate that = (SqlTemplate) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @param client the wrapped SQL client
   * @param template the template query string
   * @return the template
   */
  public static io.vertx.mutiny.sqlclient.templates.SqlTemplate<java.util.Map<String, java.lang.Object>, io.vertx.mutiny.sqlclient.RowSet<io.vertx.mutiny.sqlclient.Row>> forQuery(io.vertx.mutiny.sqlclient.SqlClient client, String template) { 
    io.vertx.mutiny.sqlclient.templates.SqlTemplate<java.util.Map<String, java.lang.Object>, io.vertx.mutiny.sqlclient.RowSet<io.vertx.mutiny.sqlclient.Row>> ret = io.vertx.mutiny.sqlclient.templates.SqlTemplate.newInstance((io.vertx.sqlclient.templates.SqlTemplate)io.vertx.sqlclient.templates.SqlTemplate.forQuery(client.getDelegate(), template), TypeArg.unknown(), TYPE_ARG_0);
    return ret;
  }

  /**
   * @param client the wrapped SQL client
   * @param template the template update string
   * @return the template
   */
  public static io.vertx.mutiny.sqlclient.templates.SqlTemplate<java.util.Map<String, java.lang.Object>, io.vertx.mutiny.sqlclient.SqlResult<Void>> forUpdate(io.vertx.mutiny.sqlclient.SqlClient client, String template) { 
    io.vertx.mutiny.sqlclient.templates.SqlTemplate<java.util.Map<String, java.lang.Object>, io.vertx.mutiny.sqlclient.SqlResult<Void>> ret = io.vertx.mutiny.sqlclient.templates.SqlTemplate.newInstance((io.vertx.sqlclient.templates.SqlTemplate)io.vertx.sqlclient.templates.SqlTemplate.forUpdate(client.getDelegate(), template), TypeArg.unknown(), TYPE_ARG_1);
    return ret;
  }

  /**
   * @param mapper the mapping function
   * @return a new template
   */
  public <T> io.vertx.mutiny.sqlclient.templates.SqlTemplate<T, R> mapFrom(io.vertx.mutiny.sqlclient.templates.TupleMapper<T> mapper) { 
    io.vertx.mutiny.sqlclient.templates.SqlTemplate<T, R> ret = io.vertx.mutiny.sqlclient.templates.SqlTemplate.newInstance((io.vertx.sqlclient.templates.SqlTemplate)delegate.mapFrom(mapper.getDelegate()), mapper.__typeArg_0, __typeArg_1);
    return ret;
  }

  /**
   * @param type the mapping type
   * @return a new template
   */
  public <T> io.vertx.mutiny.sqlclient.templates.SqlTemplate<T, R> mapFrom(java.lang.Class<T> type) { 
    io.vertx.mutiny.sqlclient.templates.SqlTemplate<T, R> ret = io.vertx.mutiny.sqlclient.templates.SqlTemplate.newInstance((io.vertx.sqlclient.templates.SqlTemplate)delegate.mapFrom(io.smallrye.mutiny.vertx.MutinyHelper.unwrap(type)), io.smallrye.mutiny.vertx.TypeArg.of(type), __typeArg_1);
    return ret;
  }

  /**
   * @param mapper the mapping function
   * @return a new template
   */
  public <U> io.vertx.mutiny.sqlclient.templates.SqlTemplate<I, io.vertx.mutiny.sqlclient.RowSet<U>> mapTo(io.vertx.mutiny.sqlclient.templates.RowMapper<U> mapper) { 
    io.vertx.mutiny.sqlclient.templates.SqlTemplate<I, io.vertx.mutiny.sqlclient.RowSet<U>> ret = io.vertx.mutiny.sqlclient.templates.SqlTemplate.newInstance((io.vertx.sqlclient.templates.SqlTemplate)delegate.mapTo(mapper.getDelegate()), __typeArg_0, new TypeArg<io.vertx.mutiny.sqlclient.RowSet<U>>(o0 -> io.vertx.mutiny.sqlclient.RowSet.newInstance((io.vertx.sqlclient.RowSet)o0, mapper.__typeArg_0), o0 -> o0.getDelegate()));
    return ret;
  }

  /**
   * @param type the mapping type
   * @return a new template
   */
  public <U> io.vertx.mutiny.sqlclient.templates.SqlTemplate<I, io.vertx.mutiny.sqlclient.RowSet<U>> mapTo(java.lang.Class<U> type) { 
    io.vertx.mutiny.sqlclient.templates.SqlTemplate<I, io.vertx.mutiny.sqlclient.RowSet<U>> ret = io.vertx.mutiny.sqlclient.templates.SqlTemplate.newInstance((io.vertx.sqlclient.templates.SqlTemplate)delegate.mapTo(io.smallrye.mutiny.vertx.MutinyHelper.unwrap(type)), __typeArg_0, new TypeArg<io.vertx.mutiny.sqlclient.RowSet<U>>(o0 -> io.vertx.mutiny.sqlclient.RowSet.newInstance((io.vertx.sqlclient.RowSet)o0, io.smallrye.mutiny.vertx.TypeArg.of(type)), o0 -> o0.getDelegate()));
    return ret;
  }

  /**
   * Execute the query with the <code>parameters</code>
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param parameters the query parameters
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  public io.smallrye.mutiny.Uni<R> execute(I parameters) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.execute(__typeArg_0.<I>unwrap(parameters), new Handler<AsyncResult<R>>() {
      public void handle(AsyncResult<R> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture((R)__typeArg_1.wrap(ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.sqlclient.templates.SqlTemplate#execute(I)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param parameters the query parameters
   * @return the R instance produced by the operation.
   */
  public R executeAndAwait(I parameters) { 
    return (R) execute(parameters).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.sqlclient.templates.SqlTemplate#execute(I)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.sqlclient.templates.SqlTemplate#execute(I)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.sqlclient.templates.SqlTemplate#execute(I)} but you don't need to compose it with other operations.
   * @param parameters the query parameters
   */
  public void executeAndForget(I parameters) { 
    execute(parameters).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Execute a batch query with the <code>batch</code>.
   *
   * <p>Each item in the batch is mapped to a tuple.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param batch the batch
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  public io.smallrye.mutiny.Uni<R> executeBatch(List<I> batch) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.executeBatch(batch.stream().map(elt -> __typeArg_0.<I>unwrap(elt)).collect(java.util.stream.Collectors.toList()), new Handler<AsyncResult<R>>() {
      public void handle(AsyncResult<R> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture((R)__typeArg_1.wrap(ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.sqlclient.templates.SqlTemplate#executeBatch(List<I>)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param batch the batch
   * @return the R instance produced by the operation.
   */
  public R executeBatchAndAwait(List<I> batch) { 
    return (R) executeBatch(batch).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.sqlclient.templates.SqlTemplate#executeBatch(List<I>)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.sqlclient.templates.SqlTemplate#executeBatch(List<I>)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.sqlclient.templates.SqlTemplate#executeBatch(List<I>)} but you don't need to compose it with other operations.
   * @param batch the batch
   */
  public void executeBatchAndForget(List<I> batch) { 
    executeBatch(batch).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  public static <I,R>SqlTemplate<I,R> newInstance(io.vertx.sqlclient.templates.SqlTemplate arg) {
    return arg != null ? new SqlTemplate<I,R>(arg) : null;
  }


  public static <I,R>SqlTemplate<I,R> newInstance(io.vertx.sqlclient.templates.SqlTemplate arg, io.smallrye.mutiny.vertx.TypeArg<I> __typeArg_I, io.smallrye.mutiny.vertx.TypeArg<R> __typeArg_R) {
    return arg != null ? new SqlTemplate<I,R>(arg, __typeArg_I, __typeArg_R) : null;
  }

}
