/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.json;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.smallrye.reactive.messaging.json.JsonMapping;
import javax.annotation.Priority;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;

@ApplicationScoped
@Priority(value=500)
public class JacksonMapping
implements JsonMapping {
    @Inject
    ObjectMapper objectMapper;

    public String toJson(Object object) {
        try {
            return this.objectMapper.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public <T> T fromJson(String str, Class<T> type) {
        try {
            return (T)this.objectMapper.readValue(str, type);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }
}

