package io.smallrye.reactive.messaging.jms.i18n;

import java.util.Locale;
import java.lang.IllegalStateException;
import java.io.Serializable;
import java.lang.Throwable;
import java.lang.Class;
import java.lang.String;
import java.util.Arrays;
import java.lang.IllegalArgumentException;

/**
 * Warning this class consists of generated code.
 */
public class JmsExceptions_$bundle implements JmsExceptions, Serializable {
    private static final long serialVersionUID = 1L;
    protected JmsExceptions_$bundle() {}
    public static final JmsExceptions_$bundle INSTANCE = new JmsExceptions_$bundle();
    protected Object readResolve() {
        return INSTANCE;
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    protected String illegalStateUnableToLoadClass$str() {
        return "SRMSG15600: Unable to load the class";
    }
    @Override
    public final IllegalArgumentException illegalStateUnableToLoadClass(final Throwable t) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), illegalStateUnableToLoadClass$str()), t);
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    protected String illegalStateUnableToUnwrap$str() {
        return "SRMSG15601: Unable to unwrap message to %s";
    }
    @Override
    public final IllegalArgumentException illegalStateUnableToUnwrap(final Class unwrapType) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), illegalStateUnableToUnwrap$str(), unwrapType));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String illegalStateCannotFindFactory$str() {
        return "SRMSG15602: Cannot find a javax.jms.ConnectionFactory bean";
    }
    @Override
    public final IllegalStateException illegalStateCannotFindFactory() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), illegalStateCannotFindFactory$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String illegalStateCannotFindNamedFactory$str() {
        return "SRMSG15603: Cannot find a javax.jms.ConnectionFactory bean named %s";
    }
    @Override
    public final IllegalStateException illegalStateCannotFindNamedFactory(final String factoryName) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), illegalStateCannotFindNamedFactory$str(), factoryName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String illegalStateUnknowSessionMode$str() {
        return "SRMSG15604: Unknown session mode: %s";
    }
    @Override
    public final IllegalArgumentException illegalStateUnknowSessionMode(final String mode) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), illegalStateUnknowSessionMode$str(), mode));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String illegalStateKeyNull$str() {
        return "SRMSG15605: The key must not be `null` or blank";
    }
    @Override
    public final IllegalArgumentException illegalStateKeyNull() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), illegalStateKeyNull$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String illegalStateValueNull$str() {
        return "SRMSG15606: The value must not be `null`";
    }
    @Override
    public final IllegalArgumentException illegalStateValueNull() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), illegalStateValueNull$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String illegalArgumentInvalidDeliveryMode$str() {
        return "SRMSG15607: Invalid delivery mode, it should be either `persistent` or `non_persistent`: %s";
    }
    @Override
    public final IllegalArgumentException illegalArgumentInvalidDeliveryMode(final String v) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), illegalArgumentInvalidDeliveryMode$str(), v));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String illegalArgumentInvalidDestinationType$str() {
        return "SRMSG15608: Invalid destination type, it should be either `queue` or `topic`: %s";
    }
    @Override
    public final IllegalArgumentException illegalArgumentInvalidDestinationType(final String replyToDestinationType) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), illegalArgumentInvalidDestinationType$str(), replyToDestinationType));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String illegalStateUnableToMapProperties$str() {
        return "SRMSG15609: Unable to map JMS properties to the outgoing message, OutgoingJmsProperties expected, found %s";
    }
    @Override
    public final IllegalStateException illegalStateUnableToMapProperties(final String name) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), illegalStateUnableToMapProperties$str(), name));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String illegalStateUnknownDestinationType$str() {
        return "SRMSG15610: Unknown destination type: %s";
    }
    @Override
    public final IllegalStateException illegalStateUnknownDestinationType(final String type) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), illegalStateUnknownDestinationType$str(), type));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String illegalArgumentInvalidDestination$str() {
        return "SRMSG15611: Invalid destination, only topic can be durable";
    }
    @Override
    public final IllegalArgumentException illegalArgumentInvalidDestination() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), illegalArgumentInvalidDestination$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String illegalArgumentUnknownDestinationType$str() {
        return "SRMSG15612: Unknown destination type: %s";
    }
    @Override
    public final IllegalArgumentException illegalArgumentUnknownDestinationType(final String type) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), illegalArgumentUnknownDestinationType$str(), type));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String illegalStateAlreadySubscriber$str() {
        return "SRMSG15613: There is already a subscriber";
    }
    @Override
    public final IllegalStateException illegalStateAlreadySubscriber() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), illegalStateAlreadySubscriber$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
}
