/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.jms;

import io.smallrye.reactive.messaging.jms.JmsProperties;
import io.smallrye.reactive.messaging.jms.i18n.JmsExceptions;
import io.smallrye.reactive.messaging.jms.impl.JmsTask;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import javax.jms.Message;

public class JmsPropertiesBuilder {
    private final Map<String, Property<?>> properties = new LinkedHashMap();

    public JmsPropertiesBuilder with(String key, boolean value) {
        this.validate(key, value);
        this.properties.put(key, new Property<Boolean>(key, value, JmsTask.wrap(m -> m.setBooleanProperty(key, value))));
        return this;
    }

    public JmsPropertiesBuilder with(String key, byte value) {
        this.validate(key, value);
        this.properties.put(key, new Property<Byte>(key, value, JmsTask.wrap(m -> m.setByteProperty(key, value))));
        return this;
    }

    public JmsPropertiesBuilder with(String key, short value) {
        this.validate(key, value);
        this.properties.put(key, new Property<Short>(key, value, JmsTask.wrap(m -> m.setShortProperty(key, value))));
        return this;
    }

    public JmsPropertiesBuilder with(String key, int value) {
        this.validate(key, value);
        this.properties.put(key, new Property<Integer>(key, value, JmsTask.wrap(m -> m.setIntProperty(key, value))));
        return this;
    }

    public JmsPropertiesBuilder with(String key, long value) {
        this.validate(key, value);
        this.properties.put(key, new Property<Long>(key, value, JmsTask.wrap(m -> m.setLongProperty(key, value))));
        return this;
    }

    public JmsPropertiesBuilder with(String key, float value) {
        this.validate(key, Float.valueOf(value));
        this.properties.put(key, new Property<Float>(key, Float.valueOf(value), JmsTask.wrap(m -> m.setFloatProperty(key, value))));
        return this;
    }

    public JmsPropertiesBuilder with(String key, double value) {
        this.validate(key, value);
        this.properties.put(key, new Property<Double>(key, value, JmsTask.wrap(m -> m.setDoubleProperty(key, value))));
        return this;
    }

    public JmsPropertiesBuilder with(String key, String value) {
        this.validate(key, value);
        this.properties.put(key, new Property<String>(key, value, JmsTask.wrap(m -> m.setStringProperty(key, value))));
        return this;
    }

    public JmsPropertiesBuilder without(String key) {
        this.properties.remove(key);
        return this;
    }

    private void validate(String key, Object value) {
        if (key == null || key.trim().length() == 0) {
            throw JmsExceptions.ex.illegalStateKeyNull();
        }
        if (value == null) {
            throw JmsExceptions.ex.illegalStateValueNull();
        }
    }

    public JmsProperties build() {
        return new OutgoingJmsProperties(this.properties);
    }

    public static class Property<T> {
        private final String name;
        private final T value;
        private final Consumer<Message> applier;

        private Property(String name, T value, Consumer<Message> applier) {
            this.name = name;
            this.value = value;
            this.applier = applier;
        }

        public T value() {
            return this.value;
        }

        public String name() {
            return this.name;
        }

        public void apply(Message message) {
            this.applier.accept(message);
        }
    }

    public static class OutgoingJmsProperties
    implements JmsProperties {
        private final Map<String, Property<?>> properties;

        public OutgoingJmsProperties(Map<String, Property<?>> properties) {
            this.properties = properties;
        }

        @Override
        public boolean propertyExists(String name) {
            return this.properties.containsKey(name);
        }

        private <T> Optional<Property<T>> get(String name) {
            return Optional.ofNullable(this.properties.get(name));
        }

        @Override
        public boolean getBooleanProperty(String name) {
            Optional<Property<Property>> property = this.get(name);
            return property.map(Property::value).orElse(false);
        }

        @Override
        public byte getByteProperty(String name) {
            Optional<Property<Property>> property = this.get(name);
            return property.map(Property::value).orElse((byte)0);
        }

        @Override
        public short getShortProperty(String name) {
            Optional<Property<Property>> property = this.get(name);
            return property.map(Property::value).orElse((short)0);
        }

        @Override
        public int getIntProperty(String name) {
            Optional<Property<Property>> property = this.get(name);
            return property.map(Property::value).orElse(0);
        }

        @Override
        public long getLongProperty(String name) {
            Optional<Property<Property>> property = this.get(name);
            return property.map(Property::value).orElse(0L);
        }

        @Override
        public float getFloatProperty(String name) {
            Optional<Property<Property>> property = this.get(name);
            return property.map(Property::value).orElse(Float.valueOf(0.0f)).floatValue();
        }

        @Override
        public double getDoubleProperty(String name) {
            Optional<Property<Property>> property = this.get(name);
            return property.map(Property::value).orElse(0.0);
        }

        @Override
        public String getStringProperty(String name) {
            Optional<Property<Property>> property = this.get(name);
            return property.map(p -> p.value().toString()).orElse(null);
        }

        @Override
        public Object getObjectProperty(String name) {
            Optional<Property<Property>> property = this.get(name);
            return property.map(Property::value).orElse(null);
        }

        @Override
        public Enumeration<String> getPropertyNames() {
            return Collections.enumeration(this.properties.keySet());
        }

        public Collection<Property<?>> getProperties() {
            return this.properties.values();
        }
    }
}

