/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.jms;

import io.smallrye.reactive.messaging.jms.JmsConnectorOutgoingConfiguration;
import io.smallrye.reactive.messaging.jms.JmsProperties;
import io.smallrye.reactive.messaging.jms.JmsPropertiesBuilder;
import io.smallrye.reactive.messaging.jms.OutgoingJmsMessageMetadata;
import io.smallrye.reactive.messaging.jms.i18n.JmsExceptions;
import io.smallrye.reactive.messaging.jms.i18n.JmsLogging;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.JMSContext;
import javax.jms.JMSException;
import javax.jms.JMSProducer;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.json.bind.Jsonb;
import org.eclipse.microprofile.reactive.messaging.Message;
import org.eclipse.microprofile.reactive.streams.operators.ReactiveStreams;
import org.eclipse.microprofile.reactive.streams.operators.SubscriberBuilder;

class JmsSink {
    private final JMSProducer producer;
    private final Destination destination;
    private final SubscriberBuilder<Message<?>, Void> sink;
    private final JMSContext context;
    private final Jsonb json;
    private final Executor executor;

    JmsSink(JMSContext context, JmsConnectorOutgoingConfiguration config, Jsonb jsonb, Executor executor) {
        String name = config.getDestination().orElseGet(config::getChannel);
        this.destination = this.getDestination(context, name, config.getDestinationType());
        this.context = context;
        this.json = jsonb;
        this.executor = executor;
        this.producer = context.createProducer();
        config.getDeliveryDelay().ifPresent(arg_0 -> ((JMSProducer)this.producer).setDeliveryDelay(arg_0));
        config.getDeliveryMode().ifPresent(v -> {
            if (v.equalsIgnoreCase("persistent")) {
                this.producer.setDeliveryMode(2);
            } else if (v.equalsIgnoreCase("non_persistent")) {
                this.producer.setDeliveryMode(1);
            } else {
                throw JmsExceptions.ex.illegalArgumentInvalidDeliveryMode((String)v);
            }
        });
        config.getDisableMessageId().ifPresent(arg_0 -> ((JMSProducer)this.producer).setDisableMessageID(arg_0));
        config.getDisableMessageTimestamp().ifPresent(arg_0 -> ((JMSProducer)this.producer).setDisableMessageTimestamp(arg_0));
        config.getCorrelationId().ifPresent(arg_0 -> ((JMSProducer)this.producer).setJMSCorrelationID(arg_0));
        config.getTtl().ifPresent(arg_0 -> ((JMSProducer)this.producer).setTimeToLive(arg_0));
        config.getPriority().ifPresent(arg_0 -> ((JMSProducer)this.producer).setPriority(arg_0));
        config.getReplyTo().ifPresent(rt -> {
            Topic replyToDestination;
            String replyToDestinationType = config.getReplyToDestinationType();
            if (replyToDestinationType.equalsIgnoreCase("topic")) {
                replyToDestination = context.createTopic(rt);
            } else if (replyToDestinationType.equalsIgnoreCase("queue")) {
                replyToDestination = context.createQueue(rt);
            } else {
                throw JmsExceptions.ex.illegalArgumentInvalidDestinationType(replyToDestinationType);
            }
            this.producer.setJMSReplyTo((Destination)replyToDestination);
        });
        this.sink = ReactiveStreams.builder().flatMapCompletionStage(m -> {
            try {
                return this.send((Message<?>)m);
            }
            catch (JMSException e) {
                throw new IllegalStateException(e);
            }
        }).onError(t -> JmsLogging.log.unableToSend((Throwable)t)).ignore();
    }

    private CompletionStage<Message<?>> send(Message<?> message) throws JMSException {
        Destination actualDestination;
        TextMessage outgoing;
        Object payload = message.getPayload();
        if (payload instanceof javax.jms.Message) {
            return this.dispatch(message, () -> this.producer.send(this.destination, (javax.jms.Message)payload));
        }
        if (payload instanceof String || payload.getClass().isPrimitive() || this.isPrimitiveBoxed(payload.getClass())) {
            outgoing = this.context.createTextMessage(payload.toString());
            outgoing.setStringProperty("_classname", payload.getClass().getName());
            outgoing.setJMSType(payload.getClass().getName());
        } else if (payload.getClass().isArray() && payload.getClass().getComponentType().equals(Byte.TYPE)) {
            BytesMessage o = this.context.createBytesMessage();
            o.writeBytes((byte[])payload);
            outgoing = o;
        } else {
            outgoing = this.context.createTextMessage(this.json.toJson(payload));
            outgoing.setJMSType(payload.getClass().getName());
            outgoing.setStringProperty("_classname", payload.getClass().getName());
        }
        OutgoingJmsMessageMetadata metadata = message.getMetadata(OutgoingJmsMessageMetadata.class).orElse(null);
        if (metadata != null) {
            String correlationId = metadata.getCorrelationId();
            Destination replyTo = metadata.getReplyTo();
            Destination dest = metadata.getDestination();
            int deliveryMode = metadata.getDeliveryMode();
            String type = metadata.getType();
            JmsProperties properties = metadata.getProperties();
            if (correlationId != null) {
                outgoing.setJMSCorrelationID(correlationId);
            }
            if (replyTo != null) {
                outgoing.setJMSReplyTo(replyTo);
            }
            if (dest != null) {
                outgoing.setJMSDestination(dest);
            }
            if (deliveryMode != -1) {
                outgoing.setJMSDeliveryMode(deliveryMode);
            }
            if (type != null) {
                outgoing.setJMSType(type);
            }
            if (type != null) {
                outgoing.setJMSType(type);
            }
            if (properties != null) {
                if (!(properties instanceof JmsPropertiesBuilder.OutgoingJmsProperties)) {
                    throw JmsExceptions.ex.illegalStateUnableToMapProperties(properties.getClass().getName());
                }
                JmsPropertiesBuilder.OutgoingJmsProperties op = (JmsPropertiesBuilder.OutgoingJmsProperties)properties;
                op.getProperties().forEach(arg_0 -> JmsSink.lambda$send$5((javax.jms.Message)outgoing, arg_0));
            }
            actualDestination = dest != null ? dest : this.destination;
        } else {
            actualDestination = this.destination;
        }
        return this.dispatch(message, () -> this.lambda$send$6(actualDestination, (javax.jms.Message)outgoing));
    }

    private boolean isPrimitiveBoxed(Class<?> c) {
        return c.equals(Boolean.class) || c.equals(Integer.class) || c.equals(Byte.class) || c.equals(Double.class) || c.equals(Float.class) || c.equals(Short.class) || c.equals(Character.class) || c.equals(Long.class);
    }

    private CompletionStage<Message<?>> dispatch(Message<?> incoming, Runnable action) {
        return ((CompletableFuture)CompletableFuture.runAsync(action, this.executor).thenCompose(x -> incoming.ack())).thenApply(x -> incoming);
    }

    private Destination getDestination(JMSContext context, String name, String type) {
        switch (type.toLowerCase()) {
            case "queue": {
                return context.createQueue(name);
            }
            case "topic": {
                return context.createTopic(name);
            }
        }
        throw JmsExceptions.ex.illegalStateUnknownDestinationType(type);
    }

    SubscriberBuilder<Message<?>, Void> getSink() {
        return this.sink;
    }

    private /* synthetic */ void lambda$send$6(Destination actualDestination, javax.jms.Message outgoing) {
        this.producer.send(actualDestination, outgoing);
    }

    private static /* synthetic */ void lambda$send$5(javax.jms.Message outgoing, JmsPropertiesBuilder.Property p) {
        p.apply(outgoing);
    }
}

