/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.test.common.config;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Properties;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.config.ConfigValue;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.eclipse.microprofile.config.spi.Converter;

public class MapBasedConfig
extends LinkedHashMap<String, Object>
implements Config {
    protected static final String TEST_MP_CFG_PROPERTIES = "target/test-classes/META-INF/microprofile-config.properties";

    public MapBasedConfig(Map<String, Object> map) {
        super(map);
    }

    public MapBasedConfig() {
    }

    public static void cleanup() {
        File out = new File(TEST_MP_CFG_PROPERTIES);
        if (out.isFile()) {
            out.delete();
        }
    }

    public MapBasedConfig with(String k, Object v) {
        return this.put(k, v);
    }

    public MapBasedConfig without(String s) {
        this.remove(s);
        return this;
    }

    public MapBasedConfig copy() {
        return new MapBasedConfig(this);
    }

    @Override
    public MapBasedConfig put(String key, Object value) {
        super.put(key, value);
        return this;
    }

    public Map<String, Object> getMap() {
        return this;
    }

    public <T> T getValue(String propertyName, Class<T> propertyType) {
        return this.getOptionalValue(propertyName, propertyType).orElseThrow(() -> new NoSuchElementException(propertyName));
    }

    public ConfigValue getConfigValue(final String propertyName) {
        return new ConfigValue(){

            public String getName() {
                return propertyName;
            }

            public String getValue() {
                return MapBasedConfig.this.getOptionalValue(propertyName, String.class).orElse(null);
            }

            public String getRawValue() {
                return MapBasedConfig.this.getOptionalValue(propertyName, String.class).orElse(null);
            }

            public String getSourceName() {
                return MapBasedConfig.class.getName();
            }

            public int getSourceOrdinal() {
                return 100;
            }
        };
    }

    public <T> Optional<T> getOptionalValue(String propertyName, Class<T> propertyType) {
        Object value = super.get(propertyName);
        return Optional.ofNullable(value);
    }

    public Iterable<String> getPropertyNames() {
        return super.keySet();
    }

    public Iterable<ConfigSource> getConfigSources() {
        return Collections.emptyList();
    }

    public <T> Optional<Converter<T>> getConverter(Class<T> forType) {
        return ConfigProvider.getConfig().getConverter(forType);
    }

    public <T> T unwrap(Class<T> type) {
        return (T)ConfigProvider.getConfig().unwrap(type);
    }

    public void write() {
        File out = new File(TEST_MP_CFG_PROPERTIES);
        if (out.isFile()) {
            out.delete();
        }
        out.getParentFile().mkdirs();
        Properties properties = new Properties();
        super.forEach((key, value) -> properties.setProperty((String)key, value.toString()));
        try (FileOutputStream fos = new FileOutputStream(out);){
            properties.store(fos, "file generated for testing purpose");
            fos.flush();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

