/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.context.inject;

import com.arjuna.ats.jta.TransactionManager;
import com.arjuna.ats.jta.UserTransaction;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.jboss.weld.transaction.spi.TransactionServices;

public class TransactionServicesImpl
implements TransactionServices {
    private Transaction getTransaction() {
        try {
            javax.transaction.TransactionManager tm = TransactionManager.transactionManager();
            return tm == null ? null : tm.getTransaction();
        }
        catch (SystemException e) {
            throw new RuntimeException(e);
        }
    }

    public void registerSynchronization(Synchronization synchronization) {
        Transaction transaction = this.getTransaction();
        if (transaction == null) {
            throw new RuntimeException("No active transaction");
        }
        try {
            transaction.registerSynchronization(synchronization);
        }
        catch (RollbackException | SystemException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isTransactionActive() {
        try {
            Transaction transaction = this.getTransaction();
            if (transaction == null) {
                return false;
            }
            int status = transaction.getStatus();
            return status == 0 || status == 8 || status == 1 || status == 2 || status == 7 || status == 9;
        }
        catch (RuntimeException | SystemException e) {
            return false;
        }
    }

    public javax.transaction.UserTransaction getUserTransaction() {
        try {
            return UserTransaction.userTransaction();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void cleanup() {
    }
}

