/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.context.jta.context.propagation;

import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.CreationException;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.CDI;
import javax.transaction.InvalidTransactionException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.eclipse.microprofile.context.spi.ThreadContextProvider;
import org.eclipse.microprofile.context.spi.ThreadContextSnapshot;

public class JtaContextProvider
implements ThreadContextProvider {
    private static final Logger logger = Logger.getLogger(JtaContextProvider.class.getName());
    private volatile TransactionManager transactionManager;
    private volatile boolean transactionManagerNotAvailable;

    public ThreadContextSnapshot currentContext(Map<String, String> props) {
        if (this.isCdiUnavailable()) {
            return null;
        }
        TransactionManager tm = this.tm();
        if (tm == null) {
            return null;
        }
        Transaction capturedTransaction = this.currentTransaction(tm);
        return () -> {
            Transaction currentTransaction = this.currentTransaction(tm);
            if (capturedTransaction != null) {
                if (capturedTransaction != currentTransaction) {
                    if (currentTransaction != null) {
                        this.suspendTransaction(tm);
                    }
                    this.resumeTransaction(tm, capturedTransaction);
                } else if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Keeping current transaction " + currentTransaction);
                }
            } else if (currentTransaction != null) {
                this.suspendTransaction(tm);
            }
            return () -> {
                if (capturedTransaction != null) {
                    if (capturedTransaction != currentTransaction) {
                        this.suspendTransaction(tm);
                        if (currentTransaction != null) {
                            this.resumeTransaction(tm, currentTransaction);
                        }
                    } else if (logger.isLoggable(Level.FINE)) {
                        logger.fine("Keeping (not restoring) current transaction " + currentTransaction);
                    }
                } else if (currentTransaction != null) {
                    this.resumeTransaction(tm, currentTransaction);
                }
            };
        };
    }

    private void resumeTransaction(TransactionManager tm, Transaction transaction) {
        try {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Resuming transaction " + transaction);
            }
            tm.resume(transaction);
        }
        catch (IllegalStateException | InvalidTransactionException | SystemException e) {
            throw new RuntimeException(e);
        }
    }

    private void suspendTransaction(TransactionManager tm) {
        try {
            Transaction t = tm.suspend();
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Suspending transaction " + t);
            }
        }
        catch (SystemException e) {
            throw new RuntimeException(e);
        }
    }

    private Transaction currentTransaction(TransactionManager tm) {
        try {
            return tm.getTransaction();
        }
        catch (SystemException e) {
            logger.log(Level.SEVERE, "Failed to capture current transaction", e);
            return null;
        }
    }

    private TransactionManager tm() {
        Instance tmInstance;
        TransactionManager tm = this.transactionManager;
        if (tm != null || this.transactionManagerNotAvailable) {
            return tm;
        }
        Instance lifecycleManagers = CDI.current().select(LifecycleManager.class, new Annotation[0]);
        if (lifecycleManagers.isResolvable()) {
            ((LifecycleManager)lifecycleManagers.get()).setProvider(this);
        }
        if ((tmInstance = CDI.current().select(TransactionManager.class, new Annotation[0])).isResolvable()) {
            tm = (TransactionManager)tmInstance.get();
            if (tm != null) {
                try {
                    tm.getStatus();
                }
                catch (CreationException | SystemException x) {
                    this.transactionManagerNotAvailable = true;
                    return null;
                }
            }
        } else {
            this.transactionManagerNotAvailable = true;
            return null;
        }
        this.transactionManager = tm;
        return this.transactionManager;
    }

    public ThreadContextSnapshot clearedContext(Map<String, String> props) {
        if (this.isCdiUnavailable()) {
            return null;
        }
        TransactionManager tm = this.tm();
        if (tm == null) {
            return null;
        }
        return () -> {
            Transaction currentTransaction = this.currentTransaction(tm);
            if (currentTransaction != null) {
                this.suspendTransaction(tm);
            }
            return () -> {
                if (currentTransaction != null) {
                    this.resumeTransaction(tm, currentTransaction);
                }
            };
        };
    }

    public String getThreadContextType() {
        return "Transaction";
    }

    private boolean isCdiUnavailable() {
        if (this.transactionManager != null) {
            return false;
        }
        try {
            return CDI.current() == null;
        }
        catch (IllegalStateException e) {
            return true;
        }
    }

    @ApplicationScoped
    public static class LifecycleManager {
        private volatile JtaContextProvider provider;

        public JtaContextProvider getProvider() {
            return this.provider;
        }

        public LifecycleManager setProvider(JtaContextProvider provider) {
            this.provider = provider;
            return this;
        }

        @PreDestroy
        void shutdown() {
            this.provider.transactionManager = null;
            this.provider.transactionManagerNotAvailable = false;
        }
    }
}

