/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.client.impl.dynamic.cdi;

import io.smallrye.graphql.client.GraphQLClient;
import io.smallrye.graphql.client.dynamic.api.DynamicGraphQLClient;
import io.smallrye.graphql.client.dynamic.api.DynamicGraphQLClientBuilder;
import io.smallrye.graphql.client.impl.GraphQLClientsConfiguration;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.InjectionPoint;

@ApplicationScoped
public class NamedDynamicClients {
    private final String DEFAULT_CLIENT_NAME = "default";
    GraphQLClientsConfiguration globalConfig;
    private Map<String, DynamicGraphQLClient> createdClients;

    @PostConstruct
    void initialize() {
        this.createdClients = new HashMap<String, DynamicGraphQLClient>();
        this.globalConfig = GraphQLClientsConfiguration.getInstance();
    }

    @Produces
    @Default
    @Dependent
    DynamicGraphQLClient getClient(InjectionPoint ip) {
        GraphQLClient annotation = (GraphQLClient)ip.getAnnotated().getAnnotation(GraphQLClient.class);
        String clientName = annotation != null ? annotation.value() : "default";
        return this.createdClients.computeIfAbsent(clientName, name -> DynamicGraphQLClientBuilder.newBuilder().configKey(name).build());
    }

    @PreDestroy
    void cleanup() {
        this.createdClients.values().forEach(client -> {
            try {
                client.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }
}

