/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.client.impl.typesafe.json;

import io.smallrye.graphql.client.InvalidResponseException;
import io.smallrye.graphql.client.impl.typesafe.json.GraphQLClientValueHelper;
import io.smallrye.graphql.client.impl.typesafe.json.JsonReader;
import io.smallrye.graphql.client.impl.typesafe.json.Location;
import io.smallrye.graphql.client.impl.typesafe.json.MapLocationBuilder;
import io.smallrye.graphql.client.impl.typesafe.json.Reader;
import io.smallrye.graphql.client.impl.typesafe.reflection.FieldInfo;
import io.smallrye.graphql.client.impl.typesafe.reflection.TypeInfo;
import java.util.HashMap;
import javax.json.JsonArray;
import javax.json.JsonValue;

class JsonMapReader
extends Reader<JsonArray> {
    private static final String JSON_KEY_FOR_KEY = "key";
    private static final String JSON_KEY_FOR_VALUE = "value";
    private final TypeInfo keyType;
    private final TypeInfo valueType;

    JsonMapReader(TypeInfo type, Location location, JsonArray value, FieldInfo field) {
        super(type, location, value, field);
        this.keyType = type.getKeyType();
        this.valueType = type.getValueType();
    }

    @Override
    Object read() {
        GraphQLClientValueHelper.check(this.location, this.value, this.type.isMap());
        MapLocationBuilder locationBuilder = new MapLocationBuilder(this.location);
        HashMap<Object, Object> result = new HashMap<Object, Object>();
        for (JsonValue entry : (JsonArray)this.value) {
            Location keyLocation = locationBuilder.nextKeyLocation();
            Location valueLocation = locationBuilder.nextValueLocation();
            JsonValue keyJson = (JsonValue)entry.asJsonObject().get((Object)JSON_KEY_FOR_KEY);
            if (keyJson.getValueType() == JsonValue.ValueType.NULL) {
                throw new InvalidResponseException("unexpected null key at " + keyLocation);
            }
            JsonValue valueJson = (JsonValue)entry.asJsonObject().get((Object)JSON_KEY_FOR_VALUE);
            if (valueJson.getValueType() == JsonValue.ValueType.NULL && this.valueType.isNonNull()) {
                throw new InvalidResponseException("unexpected null value at " + keyLocation);
            }
            Object keyDeserialized = JsonReader.readJson(keyLocation, this.keyType, keyJson, this.field);
            Object valueDeserialized = JsonReader.readJson(valueLocation, this.valueType, valueJson, this.field);
            result.put(keyDeserialized, valueDeserialized);
        }
        return result;
    }
}

