/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.schema.creator.type;

import io.smallrye.graphql.schema.Annotations;
import io.smallrye.graphql.schema.ScanningContext;
import io.smallrye.graphql.schema.creator.FieldCreator;
import io.smallrye.graphql.schema.creator.ReferenceCreator;
import io.smallrye.graphql.schema.creator.type.Creator;
import io.smallrye.graphql.schema.creator.type.InputTypeCreator;
import io.smallrye.graphql.schema.helper.DescriptionHelper;
import io.smallrye.graphql.schema.helper.Direction;
import io.smallrye.graphql.schema.helper.MethodHelper;
import io.smallrye.graphql.schema.helper.TypeAutoNameStrategy;
import io.smallrye.graphql.schema.helper.TypeNameHelper;
import io.smallrye.graphql.schema.model.InterfaceType;
import io.smallrye.graphql.schema.model.Reference;
import io.smallrye.graphql.schema.model.ReferenceType;
import java.util.List;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;
import org.jboss.logging.Logger;

public class InterfaceCreator
implements Creator<InterfaceType> {
    private static final Logger LOG = Logger.getLogger((String)InputTypeCreator.class.getName());
    private final ReferenceCreator referenceCreator;
    private final FieldCreator fieldCreator;
    private final TypeAutoNameStrategy autoNameStrategy;
    private static final String JAVA_DOT = "java.";

    public InterfaceCreator(ReferenceCreator referenceCreator, FieldCreator fieldCreator, TypeAutoNameStrategy autoNameStrategy) {
        this.referenceCreator = referenceCreator;
        this.fieldCreator = fieldCreator;
        this.autoNameStrategy = autoNameStrategy;
    }

    @Override
    public InterfaceType create(ClassInfo classInfo, Reference reference) {
        LOG.debug((Object)("Creating Interface from " + classInfo.name().toString()));
        Annotations annotations = Annotations.getAnnotationsForClass(classInfo);
        String name = TypeNameHelper.getAnyTypeName(reference, ReferenceType.INTERFACE, classInfo, annotations, this.autoNameStrategy);
        String description = DescriptionHelper.getDescriptionForType(annotations).orElse(null);
        InterfaceType interfaceType = new InterfaceType(classInfo.name().toString(), name, description);
        this.addFields(interfaceType, classInfo, reference);
        this.addInterfaces(interfaceType, classInfo);
        return interfaceType;
    }

    private void addFields(InterfaceType interfaceType, ClassInfo classInfo, Reference reference) {
        for (MethodInfo methodInfo : classInfo.methods()) {
            if (!MethodHelper.isPropertyMethod(Direction.OUT, methodInfo)) continue;
            this.fieldCreator.createFieldForInterface(methodInfo, reference).ifPresent(arg_0 -> ((InterfaceType)interfaceType).addField(arg_0));
        }
        List interfaceNames = classInfo.interfaceNames();
        for (DotName interfaceName : interfaceNames) {
            ClassInfo c;
            if (!InterfaceCreator.canAddInterfaceIntoScheme(interfaceName.toString()) || (c = ScanningContext.getIndex().getClassByName(interfaceName)) == null) continue;
            this.addFields(interfaceType, c, reference);
        }
    }

    private void addInterfaces(InterfaceType interfaceType, ClassInfo classInfo) {
        List interfaceNames = classInfo.interfaceNames();
        for (DotName interfaceName : interfaceNames) {
            ClassInfo c;
            if (!InterfaceCreator.canAddInterfaceIntoScheme(interfaceName.toString()) || (c = ScanningContext.getIndex().getClassByName(interfaceName)) == null) continue;
            Reference interfaceRef = this.referenceCreator.createReference(Direction.OUT, c);
            interfaceType.addInterface(interfaceRef);
            this.addInterfaces(interfaceType, c);
        }
    }

    public static boolean canAddInterfaceIntoScheme(String interfaceFullName) {
        return interfaceFullName != null && !interfaceFullName.startsWith(JAVA_DOT);
    }
}

