/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.schema.helper;

import io.smallrye.graphql.schema.Annotations;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;

public class NonNullHelper {
    private static final Logger LOG = Logger.getLogger((String)NonNullHelper.class.getName());

    private NonNullHelper() {
    }

    public static boolean markAsNonNull(Type type, Annotations annotations) {
        return NonNullHelper.markAsNonNull(type, annotations, false);
    }

    public static boolean markAsNonNull(Type type, Annotations annotations, boolean ignorePrimitiveCheck) {
        boolean hasDefaultValue;
        boolean hasNonNull = NonNullHelper.hasNonNull(annotations);
        if (!ignorePrimitiveCheck && type.kind().equals((Object)Type.Kind.PRIMITIVE)) {
            hasNonNull = true;
        }
        if (hasDefaultValue = NonNullHelper.hasDefaultValue(annotations)) {
            if (hasNonNull && !type.kind().equals((Object)Type.Kind.PRIMITIVE)) {
                LOG.warn((Object)("Ignoring non null on [" + type.name() + "] as there is a @DefaultValue"));
            }
            return false;
        }
        return hasNonNull;
    }

    private static boolean hasNonNull(Annotations annotations) {
        return annotations.containsOneOfTheseAnnotations(Annotations.NON_NULL, Annotations.BEAN_VALIDATION_NOT_NULL, Annotations.BEAN_VALIDATION_NOT_EMPTY, Annotations.BEAN_VALIDATION_NOT_BLANK);
    }

    private static boolean hasDefaultValue(Annotations annotations) {
        return annotations.containsKeyAndValidValue(Annotations.DEFAULT_VALUE);
    }
}

