/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.schema.model;

import io.smallrye.graphql.schema.model.AdaptTo;
import io.smallrye.graphql.schema.model.AdaptWith;
import io.smallrye.graphql.schema.model.DirectiveInstance;
import io.smallrye.graphql.schema.model.ReferenceType;
import io.smallrye.graphql.schema.model.Wrapper;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class Reference
implements Serializable {
    private String className;
    private String name;
    private ReferenceType type;
    private String graphQlClassName;
    private AdaptTo adaptTo = null;
    private AdaptWith adaptWith = null;
    private Map<String, Reference> parametrizedTypeArguments;
    private boolean addParametrizedTypeNameExtension;
    private List<DirectiveInstance> directiveInstances;
    private Wrapper wrapper = null;

    public Reference() {
    }

    public Reference(String className, String name, ReferenceType type, String graphQlClassName, Map<String, Reference> parametrizedTypeArguments, boolean addParametrizedTypeNameExtension) {
        this(className, name, type, graphQlClassName, parametrizedTypeArguments, addParametrizedTypeNameExtension, null, null, null);
    }

    public Reference(String className, String name, ReferenceType type, String graphQlClassName) {
        this(className, name, type, graphQlClassName, null, false, null, null, null);
    }

    public Reference(String className, String name, ReferenceType type, String graphQlClassName, Map<String, Reference> parametrizedTypeArguments, boolean addParametrizedTypeNameExtension, AdaptTo adaptTo, AdaptWith adaptWith, List<DirectiveInstance> directiveInstances) {
        this.className = className;
        this.name = name;
        this.type = type;
        this.graphQlClassName = graphQlClassName;
        this.parametrizedTypeArguments = parametrizedTypeArguments;
        this.adaptTo = adaptTo;
        this.adaptWith = adaptWith;
        this.addParametrizedTypeNameExtension = addParametrizedTypeNameExtension;
        this.directiveInstances = directiveInstances;
    }

    public Reference(String className, String name, ReferenceType type) {
        this(className, name, type, className, null, false, null, null, null);
    }

    public Reference(String className, String name, ReferenceType type, Map<String, Reference> parametrizedTypeArguments, boolean addParametrizedTypeNameExtension) {
        this(className, name, type, className, parametrizedTypeArguments, addParametrizedTypeNameExtension, null, null, null);
    }

    public Reference(Reference reference) {
        this(reference.className, reference.name, reference.type, reference.graphQlClassName, reference.parametrizedTypeArguments, reference.addParametrizedTypeNameExtension, reference.adaptTo, reference.adaptWith, reference.directiveInstances);
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ReferenceType getType() {
        return this.type;
    }

    public void setType(ReferenceType type) {
        this.type = type;
    }

    public String getGraphQlClassName() {
        return this.graphQlClassName;
    }

    public void setGraphQlClassName(String graphQlClassName) {
        this.graphQlClassName = graphQlClassName;
    }

    public AdaptTo getAdaptTo() {
        return this.adaptTo;
    }

    public void setAdaptTo(AdaptTo adaptTo) {
        this.adaptTo = adaptTo;
    }

    public boolean isAdaptingTo() {
        return this.adaptTo != null;
    }

    public AdaptWith getAdaptWith() {
        return this.adaptWith;
    }

    public void setAdaptWith(AdaptWith adaptWith) {
        this.adaptWith = adaptWith;
    }

    public boolean isAdaptingWith() {
        return this.adaptWith != null;
    }

    public Map<String, Reference> getParametrizedTypeArguments() {
        return this.parametrizedTypeArguments;
    }

    public void setParametrizedTypeArguments(Map<String, Reference> parametrizedTypeArguments) {
        this.parametrizedTypeArguments = parametrizedTypeArguments;
    }

    public boolean isAddParametrizedTypeNameExtension() {
        return this.addParametrizedTypeNameExtension;
    }

    public void setAddParametrizedTypeNameExtension(boolean addParametrizedTypeNameExtension) {
        this.addParametrizedTypeNameExtension = addParametrizedTypeNameExtension;
    }

    public List<DirectiveInstance> getDirectiveInstances() {
        return this.directiveInstances;
    }

    public boolean hasDirectiveInstances() {
        return this.directiveInstances != null && !this.directiveInstances.isEmpty();
    }

    public void setDirectiveInstances(List<DirectiveInstance> directiveInstances) {
        this.directiveInstances = directiveInstances;
    }

    public void addDirectiveInstance(DirectiveInstance directiveInstance) {
        this.directiveInstances.add(directiveInstance);
    }

    public Wrapper getWrapper() {
        return this.wrapper;
    }

    public void setWrapper(Wrapper wrapper) {
        this.wrapper = wrapper;
    }

    public boolean hasWrapper() {
        return this.wrapper != null;
    }

    public String toString() {
        return "Reference{className=" + this.className + ", name=" + this.name + ", type=" + (Object)((Object)this.type) + ", graphQlClassName=" + this.graphQlClassName + ", adaptTo=" + this.adaptTo + ", adaptWith=" + this.adaptWith + ", parametrizedTypeArguments=" + this.parametrizedTypeArguments + ", addParametrizedTypeNameExtension=" + this.addParametrizedTypeNameExtension + ", directiveInstances=" + this.directiveInstances + ", wrapper=" + this.wrapper + '}';
    }

    public int hashCode() {
        int hash = 7;
        hash = 97 * hash + Objects.hashCode(this.className);
        hash = 97 * hash + Objects.hashCode(this.name);
        hash = 97 * hash + Objects.hashCode((Object)this.type);
        hash = 97 * hash + Objects.hashCode(this.graphQlClassName);
        hash = 97 * hash + Objects.hashCode(this.adaptTo);
        hash = 97 * hash + Objects.hashCode(this.adaptWith);
        hash = 97 * hash + Objects.hashCode(this.parametrizedTypeArguments);
        hash = 97 * hash + (this.addParametrizedTypeNameExtension ? 1 : 0);
        hash = 97 * hash + Objects.hashCode(this.directiveInstances);
        hash = 97 * hash + Objects.hashCode(this.wrapper);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Reference other = (Reference)obj;
        if (this.addParametrizedTypeNameExtension != other.addParametrizedTypeNameExtension) {
            return false;
        }
        if (!Objects.equals(this.className, other.className)) {
            return false;
        }
        if (!Objects.equals(this.name, other.name)) {
            return false;
        }
        if (!Objects.equals(this.graphQlClassName, other.graphQlClassName)) {
            return false;
        }
        if (this.type != other.type) {
            return false;
        }
        if (!Objects.equals(this.adaptTo, other.adaptTo)) {
            return false;
        }
        if (!Objects.equals(this.adaptWith, other.adaptWith)) {
            return false;
        }
        if (!Objects.equals(this.parametrizedTypeArguments, other.parametrizedTypeArguments)) {
            return false;
        }
        if (!Objects.equals(this.directiveInstances, other.directiveInstances)) {
            return false;
        }
        return Objects.equals(this.wrapper, other.wrapper);
    }
}

