package io.soffa.gradle.plugins.java

import org.gradle.api.Plugin
import org.gradle.api.Project
import org.gradle.api.tasks.compile.JavaCompile

public class Java8ModulePlugin implements Plugin<Project> {

    private static String DEFAULT_JAVA_VERSION = "1.8"

    void apply(Project project) {
        project.plugins.apply('java')
        // project.plugins.apply('java-library')
        project.setProperty("sourceCompatibility", DEFAULT_JAVA_VERSION)
        project.setProperty("targetCompatibility", DEFAULT_JAVA_VERSION)
        project.afterEvaluate {
            project.compileJava.options.encoding = 'UTF-8'
            project.tasks.withType(JavaCompile) {
                options.encoding = 'UTF-8'
            }
        }
    }

}
