/*
 * Copyright 2015 The original authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.netflix.spinnaker.clouddriver.azure.config

import com.netflix.spinnaker.clouddriver.azure.resources.vmimage.model.AzureCustomImageStorage
import com.netflix.spinnaker.clouddriver.azure.resources.vmimage.model.AzureVMImage
import com.netflix.spinnaker.fiat.model.resources.Permissions
import groovy.transform.ToString

class AzureConfigurationProperties {

  @ToString(includeNames = true)
  static class ManagedAccount {
    String name
    String environment
    String accountType
    String clientId
    String appKey
    String tenantId
    String subscriptionId
    List<String> regions
    List<AzureVMImage> vmImages
    List<AzureCustomImageStorage> customImages
    String defaultResourceGroup
    String defaultKeyVault
    Boolean useSshPublicKey
    Permissions.Builder permissions = new Permissions.Builder()
  }

  List<ManagedAccount> accounts = []
}
