/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.azure.client;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.microsoft.azure.AzureEnvironment;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.credentials.ApplicationTokenCredentials;
import com.microsoft.azure.credentials.AzureTokenCredentials;
import com.microsoft.azure.management.Azure;
import com.microsoft.rest.LogLevel;
import com.microsoft.rest.ServiceResponse;
import com.netflix.spinnaker.clouddriver.azure.client.AzureResourceManagerClient;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyStaticMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AzureBaseClient
implements GroovyObject {
    private final String subscriptionId;
    private static final long AZURE_ATOMICOPERATION_RETRY;
    private static ObjectMapper mapper;
    private final String userAgentApplicationName;
    private final Azure azure;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private static /* synthetic */ long $const$0;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    protected AzureBaseClient(String subscriptionId, String userAgentAppName, ApplicationTokenCredentials credentials) {
        Azure azure;
        String string;
        ObjectMapper objectMapper;
        String string2;
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.subscriptionId = string2 = subscriptionId;
        mapper = objectMapper = new ObjectMapper().configure(SerializationFeature.INDENT_OUTPUT, true);
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.userAgentApplicationName = string = userAgentAppName;
        this.azure = azure = this.initialize(credentials, subscriptionId, userAgentAppName);
    }

    private Azure initialize(ApplicationTokenCredentials credentials, String subscriptionId, String userAgentAppName) {
        return ((Azure.Configurable)((Azure.Configurable)Azure.configure().withLogLevel(LogLevel.NONE)).withUserAgent(userAgentAppName)).authenticate((AzureTokenCredentials)credentials).withSubscription(subscriptionId);
    }

    public static ApplicationTokenCredentials getTokenCredentials(String clientId, String tenantId, String secret, String configuredAzureEnvironment) {
        if (ScriptBytecodeAdapter.compareEqual((Object)configuredAzureEnvironment, (Object)"AZURE_US_GOVERNMENT")) {
            return new ApplicationTokenCredentials(clientId, tenantId, secret, AzureEnvironment.AZURE_US_GOVERNMENT);
        }
        if (ScriptBytecodeAdapter.compareEqual((Object)configuredAzureEnvironment, (Object)"AZURE_CHINA")) {
            return new ApplicationTokenCredentials(clientId, tenantId, secret, AzureEnvironment.AZURE_CHINA);
        }
        if (ScriptBytecodeAdapter.compareEqual((Object)configuredAzureEnvironment, (Object)"AZURE_GERMANY")) {
            return new ApplicationTokenCredentials(clientId, tenantId, secret, AzureEnvironment.AZURE_GERMANY);
        }
        return new ApplicationTokenCredentials(clientId, tenantId, secret, AzureEnvironment.AZURE);
    }

    public static <T> T executeOp(Closure<T> operation, long count) {
        long retryCount = count <= (long)0 ? count - (long)1 : (long)0;
        long interval = $const$0;
        while (retryCount < count) {
            long l = retryCount;
            long cfr_ignored_0 = l + 1L;
            Object object = operation.call();
            try {
                return (T)object;
            }
            catch (Exception e) {
                block13: {
                    Object v1;
                    Boolean bl = AzureBaseClient.resourceNotFound(e);
                    if (!(bl == null ? false : bl)) break block13;
                    if (log.isWarnEnabled()) {
                        log.warn(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{e.getMessage()}, new String[]{"Azure resource(s) not found: ", ""})));
                        v1 = null;
                    } else {
                        v1 = null;
                    }
                    T t = null;
                    return t;
                }
                if (retryCount < count) {
                    Object v2;
                    if (!(!AzureBaseClient.handleTooManyRequestsResponse(e)) || !AzureBaseClient.canRetry(e)) continue;
                    if (log.isWarnEnabled()) {
                        log.warn(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{e.getMessage()}, new String[]{"Retrying Azure operation: ", ""})));
                        v2 = null;
                    } else {
                        v2 = null;
                    }
                    DefaultGroovyStaticMethods.sleep(null, (long)(interval * retryCount));
                    continue;
                }
                throw (Throwable)e;
            }
        }
        return null;
    }

    private static boolean canRetry(Exception e) {
        boolean retry = false;
        if (ScriptBytecodeAdapter.compareEqual(e.getClass(), CloudException.class)) {
            boolean bl;
            int code = ((CloudException)((Object)ScriptBytecodeAdapter.asType((Object)e, CloudException.class))).response().code();
            retry = bl = code == HttpURLConnection.HTTP_CLIENT_TIMEOUT || code >= HttpURLConnection.HTTP_INTERNAL_ERROR && code <= HttpURLConnection.HTTP_GATEWAY_TIMEOUT;
        } else if (ScriptBytecodeAdapter.compareEqual(e.getClass(), SocketTimeoutException.class)) {
            boolean bl;
            retry = bl = true;
        }
        return retry;
    }

    private static boolean handleTooManyRequestsResponse(Exception e) {
        if (ScriptBytecodeAdapter.compareEqual(e.getClass(), CloudException.class) && ((CloudException)((Object)ScriptBytecodeAdapter.asType((Object)e, CloudException.class))).response().code() == 429) {
            int retryAfterIntervalSec = StringGroovyMethods.toInteger((CharSequence)((CloudException)((Object)ScriptBytecodeAdapter.asType((Object)e, CloudException.class))).response().headers().get("Retry-After"));
            if (retryAfterIntervalSec != 0) {
                Object v0;
                if (log.isWarnEnabled()) {
                    log.warn(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{retryAfterIntervalSec}, new String[]{"Received 'Too Many Requests' (429) response from Azure. Retrying in ", " seconds"})));
                    v0 = null;
                } else {
                    v0 = null;
                }
                DefaultGroovyStaticMethods.sleep(null, (long)(retryAfterIntervalSec * 1000));
                return true;
            }
        }
        return false;
    }

    public static ServiceResponse<Void> deleteAzureResource(Closure azureOps, String resourceGroup, String resourceName, String parentResourceName, String msgRetry, String msgFail, long count) {
        ServiceResponse<Void> result = null;
        long operationRetry = 0L;
        while (operationRetry < count) {
            try {
                long l;
                long l2 = operationRetry;
                operationRetry = l2 + 1L;
                if (DefaultTypeTransformation.booleanUnbox((Object)parentResourceName)) {
                    azureOps.call(new Object[]{resourceGroup, parentResourceName, resourceName});
                } else {
                    azureOps.call(new Object[]{resourceGroup, resourceName});
                }
                operationRetry = l = count;
            }
            catch (CloudException e) {
                Boolean bl = AzureBaseClient.resourceNotFound((Exception)((Object)e));
                if (bl == null ? false : bl) {
                    long l;
                    operationRetry = l = count;
                    continue;
                }
                if (!(operationRetry >= count)) continue;
                throw (Throwable)e;
            }
            catch (Exception e) {
                Object v1;
                DefaultGroovyStaticMethods.sleep(null, (long)200);
                if (log.isWarnEnabled()) {
                    log.warn(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{msgRetry, e.getMessage()}, new String[]{"", ": ", ""})));
                    v1 = null;
                } else {
                    v1 = null;
                }
                if (!(operationRetry >= count)) continue;
                log.error(msgFail);
                throw (Throwable)e;
            }
        }
        return result;
    }

    public static Boolean resourceNotFound(Exception e) {
        return ScriptBytecodeAdapter.compareEqual(e.getClass(), CloudException.class) ? ((CloudException)((Object)ScriptBytecodeAdapter.asType((Object)e, CloudException.class))).response().code() == HttpURLConnection.HTTP_NOT_FOUND : false;
    }

    public void register(AzureResourceManagerClient resourceManagerClient) {
        if (DefaultTypeTransformation.booleanUnbox((Object)resourceManagerClient) && DefaultTypeTransformation.booleanUnbox((Object)this.getProviderNamespace())) {
            resourceManagerClient.registerProvider(this.getProviderNamespace());
        }
    }

    protected abstract String getProviderNamespace();

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != AzureBaseClient.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    public static <T> T executeOp(Closure<T> operation) {
        return AzureBaseClient.executeOp(operation, AZURE_ATOMICOPERATION_RETRY);
    }

    @Generated
    public static ServiceResponse<Void> deleteAzureResource(Closure azureOps, String resourceGroup, String resourceName, String parentResourceName, String msgRetry, String msgFail) {
        return AzureBaseClient.deleteAzureResource(azureOps, resourceGroup, resourceName, parentResourceName, msgRetry, msgFail, AZURE_ATOMICOPERATION_RETRY);
    }

    @Generated
    @Internal
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @Internal
    public void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    public static /* synthetic */ void __$swapInit() {
        long l;
        $const$0 = l = 200L;
    }

    static {
        Logger logger;
        AzureBaseClient.__$swapInit();
        int n = 5;
        AZURE_ATOMICOPERATION_RETRY = n;
        log = logger = LoggerFactory.getLogger((String)"com.netflix.spinnaker.clouddriver.azure.client.AzureBaseClient");
    }

    @Generated
    public final String getSubscriptionId() {
        return this.subscriptionId;
    }

    @Generated
    public static long getAZURE_ATOMICOPERATION_RETRY() {
        return AZURE_ATOMICOPERATION_RETRY;
    }

    @Generated
    public static ObjectMapper getMapper() {
        return mapper;
    }

    @Generated
    public static void setMapper(ObjectMapper objectMapper) {
        mapper = objectMapper;
    }

    @Generated
    public final String getUserAgentApplicationName() {
        return this.userAgentApplicationName;
    }

    @Generated
    public final Azure getAzure() {
        return this.azure;
    }
}

